/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.Arrays;
import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

public final class CustomElementName
extends AbstractDatatype {
    private String[] PROHIBITED_NAMES = new String[]{"annotation-xml", "color-profile", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "missing-glyph"};
    public static final CustomElementName THE_INSTANCE = new CustomElementName();

    public static boolean isPCENChar(int c) {
        return c == 45 || c == 46 || c >= 48 && c <= 57 || c == 95 || c >= 97 && c <= 122 || c == 183 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 893 || c >= 895 && c <= 8191 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8255 && c <= 8256 || c >= 8255 && c <= 8256 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    private CustomElementName() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        State state = State.EXPECTING_LOWERCASE_ALPHA;
        if (literal.length() == 0) {
            throw this.newDatatypeException("Must be non-empty.");
        }
        for (int c : literal.codePoints().toArray()) {
            if (state == State.EXPECTING_LOWERCASE_ALPHA) {
                if (c >= 97 && c <= 122) {
                    state = State.EXPECTING_HYPHEN;
                    continue;
                }
                throw this.newDatatypeException("Must begin with a lowercase ASCII letter.");
            }
            if (c >= 65 && c <= 90) {
                throw this.newDatatypeException("Uppercase ASCII letters are not allowed.");
            }
            if (c == 45) {
                state = State.EXPECTING_PNECHAR;
                continue;
            }
            if (CustomElementName.isPCENChar(c)) continue;
            throw this.newDatatypeException(String.format("Code point \u201c%s\u201d is not allowed", String.format("U+%04x", c).toUpperCase()));
        }
        if (state == State.EXPECTING_HYPHEN) {
            throw this.newDatatypeException("Must contain \"\u201c-\u201d\" (hyphen)");
        }
        if (Arrays.binarySearch(this.PROHIBITED_NAMES, literal) > -1) {
            throw this.newDatatypeException(String.format("Element name \u201c%s\u201d is not allowed.", literal));
        }
    }

    @Override
    public String getName() {
        return "custom element name";
    }

    private static enum State {
        EXPECTING_LOWERCASE_ALPHA,
        EXPECTING_HYPHEN,
        EXPECTING_PNECHAR;

    }
}

