/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import nu.validator.checker.Checker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UncheckedSubtreeWarner
extends Checker {
    private boolean alreadyWarnedAboutRdf = false;
    private boolean alreadyWarnedAboutOpenMath = false;
    private boolean alreadyWarnedAboutInkscape = false;
    private boolean alreadyWarnedAboutSvgVersion = false;

    @Override
    public void startDocument() throws SAXException {
        this.alreadyWarnedAboutRdf = false;
        this.alreadyWarnedAboutOpenMath = false;
        this.alreadyWarnedAboutInkscape = false;
        this.alreadyWarnedAboutSvgVersion = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.alreadyWarnedAboutRdf && "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == uri) {
            this.warn("This validator does not validate RDF. RDF subtrees go unchecked.");
            this.alreadyWarnedAboutRdf = true;
        }
        if (!this.alreadyWarnedAboutOpenMath && "http://www.openmath.org/OpenMath" == uri) {
            this.warn("This validator does not validate OpenMath. OpenMath subtrees go unchecked.");
            this.alreadyWarnedAboutOpenMath = true;
        }
        if (!this.alreadyWarnedAboutInkscape && ("http://www.w3.org/2000/svg" == uri && this.attrsContainInkscape(atts) || "http://www.inkscape.org/namespaces/inkscape" == uri || "http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd" == uri)) {
            this.warn("This validator does not validate Inkscape extensions properly. Inkscape-specific errors may go unnoticed.");
            this.alreadyWarnedAboutInkscape = true;
        }
        if (!this.alreadyWarnedAboutSvgVersion && "http://www.w3.org/2000/svg" == uri && this.hasUnsupportedVersion(atts)) {
            this.warn("Unsupported SVG version specified. This validator only supports SVG 1.1. The recommended way to suppress this warning is to remove the \u201cversion\u201d attribute altogether.");
            this.alreadyWarnedAboutSvgVersion = true;
        }
    }

    private boolean hasUnsupportedVersion(Attributes atts) {
        String version = atts.getValue("", "version");
        return "1.0".equals(version) || "1.2".equals(version);
    }

    private boolean attrsContainInkscape(Attributes atts) {
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String uri = atts.getURI(i);
            if ("http://www.inkscape.org/namespaces/inkscape" != uri && "http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd" != uri) continue;
            return true;
        }
        return false;
    }
}

