allDescriptors.push(...[{"dependencies":["common","sdk","ui","protocol"],"extensions":[{"defaultValue":[],"type":"setting","settingName":"customNetworkConditions","settingType":"array"},{"category":"Network","tags":"device, throttling","title":"Go offline","className":"MobileThrottling.ThrottlingManager.ActionDelegate","actionId":"network-conditions.network-offline","type":"action"},{"category":"Network","tags":"device, throttling","title":"Enable slow 3G throttling","className":"MobileThrottling.ThrottlingManager.ActionDelegate","actionId":"network-conditions.network-low-end-mobile","type":"action"},{"category":"Network","tags":"device, throttling","title":"Enable fast 3G throttling","className":"MobileThrottling.ThrottlingManager.ActionDelegate","actionId":"network-conditions.network-mid-tier-mobile","type":"action"},{"category":"Network","tags":"device, throttling","title":"Go online","className":"MobileThrottling.ThrottlingManager.ActionDelegate","actionId":"network-conditions.network-online","type":"action"},{"title":"Throttling","settings":["customNetworkConditions"],"id":"throttling-conditions","className":"MobileThrottling.ThrottlingSettingsTab","location":"settings-view","type":"view","order":35}],"name":"mobile_throttling"},{"dependencies":["common","browser_sdk"],"name":"har_importer","scripts":["har_importer_module.js"]},{"dependencies":["components","extensions","inline_editor","color_picker","event_listeners"],"extensions":[{"title":"Elements","id":"elements","className":"Elements.ElementsPanel","location":"panel","type":"view","order":10},{"className":"Elements.ElementsPanel.ContextMenuProvider","contextTypes":["SDK.RemoteObject","SDK.DOMNode","SDK.DeferredDOMNode"],"type":"@UI.ContextMenu.Provider"},{"className":"Elements.ElementsTreeOutline.Renderer","contextTypes":["SDK.DOMNode","SDK.DeferredDOMNode"],"type":"@Common.Renderer"},{"className":"Elements.ElementsPanel.DOMNodeRevealer","contextTypes":["SDK.DOMNode","SDK.DeferredDOMNode","SDK.RemoteObject"],"destination":"Elements panel","type":"@Common.Revealer"},{"className":"Elements.DOMLinkifier.Linkifier","contextTypes":["SDK.DOMNode","SDK.DeferredDOMNode"],"type":"@Common.Linkifier"},{"className":"Elements.ElementsPanel.CSSPropertyRevealer","contextTypes":["SDK.CSSProperty"],"destination":"styles sidebar","type":"@Common.Revealer"},{"category":"Elements","title":"Color format:","defaultValue":"original","options":[{"text":"As authored","value":"original","title":"Set color format as authored"},{"raw":true,"text":"HEX: #dac0de","value":"hex","title":"Set color format to HEX"},{"raw":true,"text":"RGB: rgb(128, 255, 255)","value":"rgb","title":"Set color format to RGB"},{"raw":true,"text":"HSL: hsl(300, 80%, 90%)","value":"hsl","title":"Set color format to HSL"}],"settingName":"colorFormat","settingType":"enum","type":"setting","order":0},{"category":"Elements","title":"Show user agent shadow DOM","defaultValue":false,"settingName":"showUAShadowDOM","settingType":"boolean","type":"setting","order":1},{"category":"Elements","title":"Word wrap","defaultValue":true,"options":[{"value":true,"title":"Enable DOM word wrap"},{"value":false,"title":"Disable DOM word wrap"}],"settingName":"domWordWrap","settingType":"boolean","type":"setting","order":2},{"category":"Elements","title":"Show HTML comments","defaultValue":true,"options":[{"value":true,"title":"Show HTML comments"},{"value":false,"title":"Hide HTML comments"}],"settingName":"showHTMLComments","settingType":"boolean","type":"setting","order":3},{"category":"Elements","title":"Reveal DOM node on hover","defaultValue":true,"settingName":"highlightNodeOnHoverInOverlay","settingType":"boolean","type":"setting","order":4},{"defaultValue":true,"type":"setting","settingName":"showEventListenersForAncestors","settingType":"boolean"},{"className":"Elements.ElementStatePaneWidget.ButtonProvider","type":"@UI.ToolbarItem.Provider","order":1,"location":"styles-sidebarpane-toolbar"},{"className":"Elements.ClassesPaneWidget.ButtonProvider","type":"@UI.ToolbarItem.Provider","order":2,"location":"styles-sidebarpane-toolbar"},{"className":"Elements.StylesSidebarPane.ButtonProvider","type":"@UI.ToolbarItem.Provider","order":100,"location":"styles-sidebarpane-toolbar"},{"className":"Elements.ElementsActionDelegate","contextTypes":["Elements.ElementsPanel"],"bindings":[{"shortcut":"H"}],"type":"action","actionId":"elements.hide-element"},{"className":"Elements.ElementsActionDelegate","contextTypes":["Elements.ElementsPanel"],"bindings":[{"shortcut":"F2"}],"type":"action","actionId":"elements.edit-as-html"},{"className":"Elements.ElementsActionDelegate","contextTypes":["Elements.ElementsPanel"],"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Z"},{"platform":"mac","shortcut":"Meta+Z"}],"type":"action","actionId":"elements.undo"},{"className":"Elements.ElementsActionDelegate","contextTypes":["Elements.ElementsPanel"],"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Y"},{"platform":"mac","shortcut":"Meta+Shift+Z"}],"type":"action","actionId":"elements.redo"},{"className":"Elements.ElementsPanel.PseudoStateMarkerDecorator","marker":"pseudo-state-marker","type":"@Elements.MarkerDecorator"},{"marker":"hidden-marker","factoryName":"Elements.GenericDecorator","type":"@Elements.MarkerDecorator","color":"#555","title":"Element is hidden"},{"iconClass":"largeicon-node-search","title":"Select an element in the page to inspect it","className":"Elements.InspectElementModeController.ToggleSearchActionDelegate","actionId":"elements.toggle-element-search","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Shift+C"},{"platform":"mac","shortcut":"Meta+Shift+C"}],"type":"action"},{"order":0,"type":"@UI.ToolbarItem.Provider","actionId":"elements.toggle-element-search","location":"main-toolbar-left"},{"category":"Elements","className":"Elements.ElementsPanel","type":"@UI.ViewLocationResolver","name":"elements-sidebar"},{"title":"Event Listeners","id":"elements.eventListeners","className":"Elements.EventListenersWidget","location":"elements-sidebar","hasToolbar":true,"type":"view","order":5,"persistence":"permanent"},{"title":"Properties","id":"elements.domProperties","className":"Elements.PropertiesWidget","location":"elements-sidebar","type":"view","order":7,"persistence":"permanent"}],"name":"elements","scripts":["elements_module.js"]},{"dependencies":["ui","host"],"extensions":[{"title":"What's New","id":"release-note","className":"Help.ReleaseNoteView","location":"drawer-view","type":"view","order":1,"persistence":"closeable"},{"category":"Appearance","title":"Show What's New after each update","defaultValue":true,"settingName":"help.show-release-note","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Show What's New after each update"},{"value":false,"title":"Do not show What's New after each update"}]},{"category":"Help","className":"Help.ReleaseNotesActionDelegate","type":"action","actionId":"help.release-notes","title":"Release notes"},{"order":10,"type":"context-menu-item","location":"mainMenuHelp/default","actionId":"help.release-notes"},{"className":"Help.HelpLateInitialization","type":"late-initialization"}],"name":"help","scripts":["help_module.js"]},{"dependencies":["browser_sdk","console"],"extensions":[{"className":"BrowserConsole.BrowserConsole","contextTypes":["SDK.ConsoleMessage"],"type":"@UI.ContextMenu.Provider"},{"className":"BrowserConsole.BrowserConsole","contextTypes":["SDK.ConsoleMessage"],"type":"@Common.Renderer","source":"network"}],"name":"browser_console","scripts":["browser_console_module.js"]},{"dependencies":["components","layer_viewer","timeline_model","perf_ui","extensions","data_grid","product_registry","profiler","mobile_throttling"],"extensions":[{"title":"Performance","id":"timeline","className":"Timeline.TimelinePanel","location":"panel","type":"view","order":50},{"category":"Performance","title":"Hide chrome frame in Layers view","defaultValue":false,"settingName":"frameViewerHideChromeWindow","settingType":"boolean","type":"setting"},{"className":"Timeline.LoadTimelineHandler","type":"@Common.QueryParamHandler","name":"loadTimelineFromURL"},{"order":10,"type":"context-menu-item","location":"timelineMenu/open","actionId":"timeline.load-from-file"},{"order":15,"type":"context-menu-item","location":"timelineMenu/open","actionId":"timeline.save-to-file"},{"iconClass":"largeicon-start-recording","toggledIconClass":"largeicon-stop-recording","className":"Timeline.TimelinePanel.ActionDelegate","toggleWithRedColor":true,"actionId":"timeline.toggle-recording","contextTypes":["Timeline.TimelinePanel"],"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+E"},{"platform":"mac","shortcut":"Meta+E"}],"type":"action","options":[{"value":true,"title":"Record"},{"value":false,"title":"Stop"}]},{"iconClass":"largeicon-refresh","category":"Performance","title":"Start profiling and reload page","className":"Timeline.TimelinePanel.ActionDelegate","contextTypes":["Timeline.TimelinePanel"],"actionId":"timeline.record-reload","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Shift+E"},{"platform":"mac","shortcut":"Meta+Shift+E"}],"type":"action"},{"category":"Timeline","title":"Save profile\u2026","className":"Timeline.TimelinePanel.ActionDelegate","contextTypes":["Timeline.TimelinePanel"],"actionId":"timeline.save-to-file","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+S"},{"platform":"mac","shortcut":"Meta+S"}],"type":"action"},{"category":"Timeline","title":"Load profile\u2026","className":"Timeline.TimelinePanel.ActionDelegate","contextTypes":["Timeline.TimelinePanel"],"actionId":"timeline.load-from-file","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+O"},{"platform":"mac","shortcut":"Meta+O"}],"type":"action"},{"className":"Timeline.TimelinePanel.ActionDelegate","contextTypes":["Timeline.TimelinePanel"],"bindings":[{"shortcut":"["}],"type":"action","actionId":"timeline.jump-to-previous-frame"},{"className":"Timeline.TimelinePanel.ActionDelegate","contextTypes":["Timeline.TimelinePanel"],"bindings":[{"shortcut":"]"}],"type":"action","actionId":"timeline.jump-to-next-frame"},{"category":"Performance","title":"Show recent timeline sessions","className":"Timeline.TimelinePanel.ActionDelegate","contextTypes":["Timeline.TimelinePanel"],"actionId":"timeline.show-history","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+H"},{"platform":"mac","shortcut":"Meta+Y"}],"type":"action"},{"title":"JavaScript Profiler","id":"js_profiler","className":"Profiler.JSProfilerPanel","location":"panel","type":"view","order":65,"persistence":"closeable"},{"className":"Timeline.TimelinePanel.ActionDelegate","contextTypes":["Timeline.TimelinePanel"],"bindings":[{"platform":"windows,linux","shortcut":"Alt+Left"},{"platform":"mac","shortcut":"Meta+Left"}],"type":"action","actionId":"timeline.previous-recording"},{"className":"Timeline.TimelinePanel.ActionDelegate","contextTypes":["Timeline.TimelinePanel"],"bindings":[{"platform":"windows,linux","shortcut":"Alt+Right"},{"platform":"mac","shortcut":"Meta+Right"}],"type":"action","actionId":"timeline.next-recording"}],"name":"timeline","scripts":["timeline_module.js"]},{"dependencies":["elements","sources","console"],"extensions":[{"title":"Event Listener Breakpoints","id":"sources.eventListenerBreakpoints","className":"BrowserDebugger.EventListenerBreakpointsSidebarPane","location":"sources-sidebar","type":"view","order":9,"persistence":"permanent"},{"className":"BrowserDebugger.XHRBreakpointsSidebarPane","contextTypes":["SDK.DebuggerPausedDetails"],"type":"@UI.ContextFlavorListener"},{"title":"XHR/fetch Breakpoints","id":"sources.xhrBreakpoints","className":"BrowserDebugger.XHRBreakpointsSidebarPane","location":"sources-sidebar","hasToolbar":true,"type":"view","order":5,"persistence":"permanent"},{"title":"DOM Breakpoints","id":"sources.domBreakpoints","factoryName":"BrowserDebugger.DOMBreakpointsSidebarPane","location":"sources-sidebar","type":"view","order":7,"persistence":"permanent"},{"title":"DOM Breakpoints","id":"elements.domBreakpoints","factoryName":"BrowserDebugger.DOMBreakpointsSidebarPane","location":"elements-sidebar","type":"view","order":6,"persistence":"permanent"},{"marker":"breakpoint-marker","factoryName":"Elements.GenericDecorator","type":"@Elements.MarkerDecorator","color":"rgb(105, 140, 254)","title":"DOM Breakpoint"},{"className":"BrowserDebugger.DOMBreakpointsSidebarPane.ContextMenuProvider","contextTypes":["SDK.DOMNode"],"type":"@UI.ContextMenu.Provider"},{"className":"BrowserDebugger.DOMBreakpointsSidebarPane","contextTypes":["SDK.DebuggerPausedDetails"],"type":"@UI.ContextFlavorListener"},{"title":"Global Listeners","id":"sources.globalListeners","className":"BrowserDebugger.ObjectEventListenersSidebarPane","location":"sources-sidebar","hasToolbar":true,"type":"view","order":8,"persistence":"permanent"},{"title":"Page","id":"navigator-network","className":"Sources.NetworkNavigatorView","location":"navigator-view","type":"view","order":2,"persistence":"permanent"},{"title":"Overrides","id":"navigator-overrides","className":"Sources.OverridesNavigatorView","location":"navigator-view","type":"view","order":4,"persistence":"permanent"},{"title":"Content scripts","id":"navigator-contentScripts","className":"Sources.ContentScriptsNavigatorView","location":"navigator-view","type":"view","order":5,"persistence":"permanent"},{"className":"Sources.OverridesNavigatorView","viewId":"navigator-overrides","type":"@Sources.NavigatorView"},{"className":"Sources.ContentScriptsNavigatorView","viewId":"navigator-contentScripts","type":"@Sources.NavigatorView"}],"name":"browser_debugger","scripts":["browser_debugger_module.js"]},{"dependencies":["components","sdk","timeline_model","ui","perf_ui"],"name":"layer_viewer","scripts":["layer_viewer_module.js"]},{"dependencies":["ui","sdk","data_grid"],"name":"cookie_table","scripts":["cookie_table_module.js"]},{"dependencies":["sdk"],"name":"timeline_model","scripts":["timeline_model_module.js"]},{"dependencies":["common","product_registry"],"extensions":[{"className":"ProductRegistryImpl.Registry","type":"@ProductRegistry.Registry"}],"name":"product_registry_impl","scripts":["product_registry_impl_module.js"]},{"dependencies":["components","mobile_throttling"],"extensions":[{"className":"WorkerMain.WorkerMain","type":"early-initialization"}],"name":"worker_main"},{"dependencies":["source_frame","cookie_table","inline_editor","data_grid","components","object_ui","perf_ui","mobile_throttling","network","sources"],"extensions":[{"title":"Application","id":"resources","className":"Resources.ResourcesPanel","location":"panel","type":"view","order":70},{"className":"Resources.ResourcesPanel.ResourceRevealer","contextTypes":["SDK.Resource"],"destination":"Application panel","type":"@Common.Revealer"}],"name":"resources","scripts":["resources_module.js"]},{"dependencies":["search","source_frame","components","perf_ui","cookie_table","data_grid","browser_sdk","product_registry","mobile_throttling","har_importer","persistence"],"extensions":[{"title":"Network","id":"network","className":"Network.NetworkPanel","location":"panel","type":"view","order":40},{"className":"Network.NetworkPanel.ContextMenuProvider","contextTypes":["SDK.NetworkRequest","SDK.Resource","Workspace.UISourceCode"],"type":"@UI.ContextMenu.Provider"},{"className":"Network.NetworkPanel.RequestRevealer","contextTypes":["SDK.NetworkRequest"],"destination":"Network panel","type":"@Common.Revealer"},{"className":"Network.NetworkPanel.RequestLocationRevealer","contextTypes":["Network.UIRequestLocation"],"type":"@Common.Revealer"},{"category":"Network","title":"Color-code resource types","defaultValue":false,"tags":"color code, resource type","settingName":"networkColorCodeResourceTypes","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Color code by resource type"},{"value":false,"title":"Use default colors"}]},{"category":"Network","title":"Group network log by frame","defaultValue":false,"tags":"network, frame, group","settingName":"network.group-by-frame","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Group network log items by frame"},{"value":false,"title":"Don't group network log items by frame"}]},{"iconClass":"largeicon-start-recording","toggledIconClass":"largeicon-stop-recording","className":"Network.NetworkPanel.ActionDelegate","toggleWithRedColor":true,"actionId":"network.toggle-recording","contextTypes":["Network.NetworkPanel"],"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+E"},{"platform":"mac","shortcut":"Meta+E"}],"type":"action","options":[{"value":true,"title":"Record network log"},{"value":false,"title":"Stop recording network log"}]},{"className":"Network.NetworkPanel.ActionDelegate","contextTypes":["Network.NetworkPanel"],"bindings":[{"shortcut":"Esc"}],"type":"action","actionId":"network.hide-request-details"},{"title":"Request blocking","id":"network.blocked-urls","className":"Network.BlockedURLsPane","location":"drawer-view","type":"view","order":60,"persistence":"closeable"},{"title":"Network conditions","tags":"disk cache, network throttling, useragent, user agent","id":"network.config","className":"Network.NetworkConfigView","location":"drawer-view","type":"view","order":40,"persistence":"closeable"},{"category":"Network","className":"Network.NetworkPanel","type":"@UI.ViewLocationResolver","name":"network-sidebar"},{"title":"Search","className":"Network.SearchNetworkView","location":"network-sidebar","type":"view","id":"network.search-network-tab","persistence":"permanent"},{"category":"DevTools","title":"Search","className":"Network.NetworkPanel.ActionDelegate","contextTypes":["Network.NetworkPanel"],"actionId":"network.search","bindings":[{"platform":"mac","shortcut":"Meta+F"},{"platform":"windows,linux","shortcut":"Ctrl+F"}],"type":"action"}],"name":"network","scripts":["network_module.js"]}]);applicationDescriptor.modules.push(...[{"type":"autostart","name":"mobile_throttling"},{"name":"har_importer"},{"name":"elements"},{"name":"help"},{"name":"browser_console"},{"name":"timeline"},{"name":"browser_debugger"},{"name":"layer_viewer"},{"name":"cookie_table"},{"name":"timeline_model"},{"type":"remote","name":"product_registry_impl"},{"type":"autostart","name":"worker_main"},{"name":"resources"},{"name":"network"}])
self['MobileThrottling']=self['MobileThrottling']||{};MobileThrottling.CPUThrottlingRates={NoThrottling:1,MidTierMobile:4,LowEndMobile:6,};MobileThrottling.Conditions;MobileThrottling.NoThrottlingConditions={title:SDK.NetworkManager.NoThrottlingConditions.title,description:Common.UIString('No throttling'),network:SDK.NetworkManager.NoThrottlingConditions,cpuThrottlingRate:MobileThrottling.CPUThrottlingRates.NoThrottling,};MobileThrottling.OfflineConditions={title:SDK.NetworkManager.OfflineConditions.title,description:Common.UIString('No internet connectivity'),network:SDK.NetworkManager.OfflineConditions,cpuThrottlingRate:MobileThrottling.CPUThrottlingRates.NoThrottling,};MobileThrottling.LowEndMobileConditions={title:Common.UIString('Low-end mobile'),description:Common.UIString('Slow 3G & 6x CPU slowdown'),network:SDK.NetworkManager.Slow3GConditions,cpuThrottlingRate:MobileThrottling.CPUThrottlingRates.LowEndMobile,};MobileThrottling.MidTierMobileConditions={title:Common.UIString('Mid-tier mobile'),description:Common.UIString('Fast 3G & 4x CPU slowdown'),network:SDK.NetworkManager.Fast3GConditions,cpuThrottlingRate:MobileThrottling.CPUThrottlingRates.MidTierMobile,};MobileThrottling.PlaceholderConditions;MobileThrottling.CustomConditions={title:Common.UIString('Custom'),description:Common.UIString('Check Network and Performance panels'),};MobileThrottling.NetworkThrottlingConditionsGroup;MobileThrottling.MobileThrottlingConditionsGroup;MobileThrottling.ConditionsList;MobileThrottling.mobilePresets=[MobileThrottling.MidTierMobileConditions,MobileThrottling.LowEndMobileConditions,MobileThrottling.CustomConditions];MobileThrottling.advancedMobilePresets=[MobileThrottling.OfflineConditions,];MobileThrottling.networkPresets=[SDK.NetworkManager.Fast3GConditions,SDK.NetworkManager.Slow3GConditions,SDK.NetworkManager.OfflineConditions,];MobileThrottling.cpuThrottlingPresets=[MobileThrottling.CPUThrottlingRates.NoThrottling,MobileThrottling.CPUThrottlingRates.MidTierMobile,MobileThrottling.CPUThrottlingRates.LowEndMobile,];;MobileThrottling.MobileThrottlingSelector=class{constructor(populateCallback,selectCallback){this._populateCallback=populateCallback;this._selectCallback=selectCallback;MobileThrottling.throttlingManager().addEventListener(MobileThrottling.ThrottlingManager.Events.RateChanged,this._conditionsChanged,this);SDK.multitargetNetworkManager.addEventListener(SDK.MultitargetNetworkManager.Events.ConditionsChanged,this._conditionsChanged,this);this._options=this._populateOptions();this._conditionsChanged();}
optionSelected(conditions){SDK.multitargetNetworkManager.setNetworkConditions(conditions.network);MobileThrottling.throttlingManager().setCPUThrottlingRate(conditions.cpuThrottlingRate);}
_populateOptions(){const disabledGroup={title:Common.UIString('Disabled'),items:[MobileThrottling.NoThrottlingConditions]};const presetsGroup={title:Common.UIString('Presets'),items:MobileThrottling.mobilePresets};const advancedGroup={title:Common.UIString('Advanced'),items:MobileThrottling.advancedMobilePresets};return this._populateCallback([disabledGroup,presetsGroup,advancedGroup]);}
_conditionsChanged(){const networkConditions=SDK.multitargetNetworkManager.networkConditions();const cpuThrottlingRate=MobileThrottling.throttlingManager().cpuThrottlingRate();for(let index=0;index<this._options.length;++index){const option=this._options[index];if(option&&option.network===networkConditions&&option.cpuThrottlingRate===cpuThrottlingRate){this._selectCallback(index);return;}}
this._selectCallback(this._options.indexOf(MobileThrottling.CustomConditions));}};;MobileThrottling.NetworkPanelIndicator=class{constructor(){if(!UI.inspectorView.hasPanel('network'))
return;const manager=SDK.multitargetNetworkManager;manager.addEventListener(SDK.MultitargetNetworkManager.Events.ConditionsChanged,updateVisibility);manager.addEventListener(SDK.MultitargetNetworkManager.Events.BlockedPatternsChanged,updateVisibility);manager.addEventListener(SDK.MultitargetNetworkManager.Events.InterceptorsChanged,updateVisibility);updateVisibility();function updateVisibility(){let icon=null;if(manager.isThrottling()){icon=UI.Icon.create('smallicon-warning');icon.title=Common.UIString('Network throttling is enabled');}else if(SDK.multitargetNetworkManager.isIntercepting()){icon=UI.Icon.create('smallicon-warning');icon.title=Common.UIString('Requests may be rewritten by local overrides');}else if(manager.isBlocking()){icon=UI.Icon.create('smallicon-warning');icon.title=Common.UIString('Requests may be blocked');}
UI.inspectorView.setPanelIcon('network',icon);}}};;MobileThrottling.NetworkThrottlingSelector=class{constructor(populateCallback,selectCallback,customNetworkConditionsSetting){this._populateCallback=populateCallback;this._selectCallback=selectCallback;this._customNetworkConditionsSetting=customNetworkConditionsSetting;this._customNetworkConditionsSetting.addChangeListener(this._populateOptions,this);SDK.multitargetNetworkManager.addEventListener(SDK.MultitargetNetworkManager.Events.ConditionsChanged,this._networkConditionsChanged,this);this._options;this._populateOptions();}
revealAndUpdate(){Common.Revealer.reveal(this._customNetworkConditionsSetting);this._networkConditionsChanged();}
optionSelected(conditions){SDK.multitargetNetworkManager.setNetworkConditions(conditions);}
_populateOptions(){const disabledGroup={title:Common.UIString('Disabled'),items:[SDK.NetworkManager.NoThrottlingConditions]};const presetsGroup={title:Common.UIString('Presets'),items:MobileThrottling.networkPresets};const customGroup={title:Common.UIString('Custom'),items:this._customNetworkConditionsSetting.get()};this._options=this._populateCallback([disabledGroup,presetsGroup,customGroup]);if(!this._networkConditionsChanged()){for(let i=this._options.length-1;i>=0;i--){if(this._options[i]){this.optionSelected((this._options[i]));break;}}}}
_networkConditionsChanged(){const value=SDK.multitargetNetworkManager.networkConditions();for(let index=0;index<this._options.length;++index){const option=this._options[index];if(option&&option.download===value.download&&option.upload===value.upload&&option.latency===value.latency&&option.title===value.title){this._selectCallback(index);return true;}}
return false;}};;MobileThrottling.ThrottlingSettingsTab=class extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('mobile_throttling/throttlingSettingsTab.css');this.contentElement.createChild('div','header').textContent=Common.UIString('Network Throttling Profiles');const addButton=UI.createTextButton(Common.UIString('Add custom profile...'),this._addButtonClicked.bind(this),'add-conditions-button');this.contentElement.appendChild(addButton);this._list=new UI.ListWidget(this);this._list.element.classList.add('conditions-list');this._list.registerRequiredCSS('mobile_throttling/throttlingSettingsTab.css');this._list.show(this.contentElement);this._customSetting=Common.moduleSetting('customNetworkConditions');this._customSetting.addChangeListener(this._conditionsUpdated,this);this.setDefaultFocusedElement(addButton);this.contentElement.tabIndex=0;}
wasShown(){super.wasShown();this._conditionsUpdated();}
_conditionsUpdated(){this._list.clear();const conditions=this._customSetting.get();for(let i=0;i<conditions.length;++i)
this._list.appendItem(conditions[i],true);this._list.appendSeparator();}
_addButtonClicked(){this._list.addNewItem(this._customSetting.get().length,{title:'',download:-1,upload:-1,latency:0});}
renderItem(item,editable){const conditions=(item);const element=createElementWithClass('div','conditions-list-item');const title=element.createChild('div','conditions-list-text conditions-list-title');const titleText=title.createChild('div','conditions-list-title-text');titleText.textContent=conditions.title;titleText.title=conditions.title;element.createChild('div','conditions-list-separator');element.createChild('div','conditions-list-text').textContent=MobileThrottling.throughputText(conditions.download);element.createChild('div','conditions-list-separator');element.createChild('div','conditions-list-text').textContent=MobileThrottling.throughputText(conditions.upload);element.createChild('div','conditions-list-separator');element.createChild('div','conditions-list-text').textContent=Common.UIString('%dms',conditions.latency);return element;}
removeItemRequested(item,index){const list=this._customSetting.get();list.splice(index,1);this._customSetting.set(list);}
commitEdit(item,editor,isNew){const conditions=(item);conditions.title=editor.control('title').value.trim();const download=editor.control('download').value.trim();conditions.download=download?parseInt(download,10)*(1024/8):-1;const upload=editor.control('upload').value.trim();conditions.upload=upload?parseInt(upload,10)*(1024/8):-1;const latency=editor.control('latency').value.trim();conditions.latency=latency?parseInt(latency,10):0;const list=this._customSetting.get();if(isNew)
list.push(conditions);this._customSetting.set(list);}
beginEdit(item){const conditions=(item);const editor=this._createEditor();editor.control('title').value=conditions.title;editor.control('download').value=conditions.download<=0?'':String(conditions.download/(1024/8));editor.control('upload').value=conditions.upload<=0?'':String(conditions.upload/(1024/8));editor.control('latency').value=conditions.latency?String(conditions.latency):'';return editor;}
_createEditor(){if(this._editor)
return this._editor;const editor=new UI.ListWidget.Editor();this._editor=editor;const content=editor.contentElement();const titles=content.createChild('div','conditions-edit-row');titles.createChild('div','conditions-list-text conditions-list-title').textContent=Common.UIString('Profile Name');titles.createChild('div','conditions-list-separator conditions-list-separator-invisible');titles.createChild('div','conditions-list-text').textContent=Common.UIString('Download');titles.createChild('div','conditions-list-separator conditions-list-separator-invisible');titles.createChild('div','conditions-list-text').textContent=Common.UIString('Upload');titles.createChild('div','conditions-list-separator conditions-list-separator-invisible');titles.createChild('div','conditions-list-text').textContent=Common.UIString('Latency');const fields=content.createChild('div','conditions-edit-row');fields.createChild('div','conditions-list-text conditions-list-title').appendChild(editor.createInput('title','text','',titleValidator));fields.createChild('div','conditions-list-separator conditions-list-separator-invisible');let cell=fields.createChild('div','conditions-list-text');cell.appendChild(editor.createInput('download','text',Common.UIString('kb/s'),throughputValidator));cell.createChild('div','conditions-edit-optional').textContent=Common.UIString('optional');fields.createChild('div','conditions-list-separator conditions-list-separator-invisible');cell=fields.createChild('div','conditions-list-text');cell.appendChild(editor.createInput('upload','text',Common.UIString('kb/s'),throughputValidator));cell.createChild('div','conditions-edit-optional').textContent=Common.UIString('optional');fields.createChild('div','conditions-list-separator conditions-list-separator-invisible');cell=fields.createChild('div','conditions-list-text');cell.appendChild(editor.createInput('latency','text',Common.UIString('ms'),latencyValidator));cell.createChild('div','conditions-edit-optional').textContent=Common.UIString('optional');return editor;function titleValidator(item,index,input){const value=input.value.trim();return value.length>0&&value.length<50;}
function throughputValidator(item,index,input){const value=input.value.trim();return!value||(/^[\d]+(\.\d+)?|\.\d+$/.test(value)&&value>=0&&value<=10000000);}
function latencyValidator(item,index,input){const value=input.value.trim();return!value||(/^[\d]+$/.test(value)&&value>=0&&value<=1000000);}}};MobileThrottling.throughputText=function(throughput,plainText){if(throughput<0)
return'';const throughputInKbps=throughput/(1024/8);const delimiter=plainText?'':' ';if(throughputInKbps<1024)
return Common.UIString('%d%skb/s',throughputInKbps,delimiter);if(throughputInKbps<1024*10)
return Common.UIString('%.1f%sMb/s',throughputInKbps/1024,delimiter);return Common.UIString('%d%sMb/s',(throughputInKbps/1024)|0,delimiter);};;MobileThrottling.ThrottlingManager=class extends Common.Object{constructor(){super();this._cpuThrottlingRate=MobileThrottling.CPUThrottlingRates.NoThrottling;this._cpuThrottlingControls=new Set();this._cpuThrottlingRates=MobileThrottling.cpuThrottlingPresets;this._customNetworkConditionsSetting=Common.moduleSetting('customNetworkConditions');this._currentNetworkThrottlingConditions=SDK.NetworkManager.NoThrottlingConditions;this._lastNetworkThrottlingConditions;SDK.multitargetNetworkManager.addEventListener(SDK.MultitargetNetworkManager.Events.ConditionsChanged,()=>{this._lastNetworkThrottlingConditions=this._currentNetworkThrottlingConditions;this._currentNetworkThrottlingConditions=SDK.multitargetNetworkManager.networkConditions();});SDK.targetManager.observeModels(SDK.EmulationModel,this);}
decorateSelectWithNetworkThrottling(selectElement){let options=[];const selector=new MobileThrottling.NetworkThrottlingSelector(populate,select,this._customNetworkConditionsSetting);selectElement.addEventListener('change',optionSelected,false);return selector;function populate(groups){selectElement.removeChildren();options=[];for(let i=0;i<groups.length;++i){const group=groups[i];const groupElement=selectElement.createChild('optgroup');groupElement.label=group.title;for(const conditions of group.items){const title=conditions.title;const option=new Option(title,title);groupElement.appendChild(option);options.push(conditions);}
if(i===groups.length-1){groupElement.appendChild(new Option(Common.UIString('Add\u2026'),Common.UIString('Add\u2026')));options.push(null);}}
return options;}
function optionSelected(){if(selectElement.selectedIndex===selectElement.options.length-1)
selector.revealAndUpdate();else
selector.optionSelected(options[selectElement.selectedIndex]);}
function select(index){if(selectElement.selectedIndex!==index)
selectElement.selectedIndex=index;}}
createOfflineToolbarCheckbox(){const checkbox=new UI.ToolbarCheckbox(Common.UIString('Offline'),Common.UIString('Force disconnected from network'),forceOffline.bind(this));SDK.multitargetNetworkManager.addEventListener(SDK.MultitargetNetworkManager.Events.ConditionsChanged,networkConditionsChanged);checkbox.setChecked(SDK.multitargetNetworkManager.networkConditions()===SDK.NetworkManager.OfflineConditions);function forceOffline(){if(checkbox.checked())
SDK.multitargetNetworkManager.setNetworkConditions(SDK.NetworkManager.OfflineConditions);else
SDK.multitargetNetworkManager.setNetworkConditions(this._lastNetworkThrottlingConditions);}
function networkConditionsChanged(){checkbox.setChecked(SDK.multitargetNetworkManager.networkConditions()===SDK.NetworkManager.OfflineConditions);}
return checkbox;}
createMobileThrottlingButton(){const button=new UI.ToolbarMenuButton(appendItems);button.setTitle(Common.UIString('Throttling'));button.setGlyph('');button.turnIntoSelect();button.setDarkText();let options=[];let selectedIndex=-1;const selector=new MobileThrottling.MobileThrottlingSelector(populate,select);return button;function appendItems(contextMenu){for(let index=0;index<options.length;++index){const conditions=options[index];if(!conditions)
continue;if(conditions.title===MobileThrottling.CustomConditions.title&&conditions.description===MobileThrottling.CustomConditions.description)
continue;contextMenu.defaultSection().appendCheckboxItem(Common.UIString(conditions.title),selector.optionSelected.bind(selector,(conditions)),selectedIndex===index);}}
function populate(groups){options=[];for(const group of groups){for(const conditions of group.items)
options.push(conditions);options.push(null);}
return options;}
function select(index){selectedIndex=index;button.setText(options[index].title);button.setTitle(options[index].description);}}
cpuThrottlingRate(){return this._cpuThrottlingRate;}
setCPUThrottlingRate(rate){this._cpuThrottlingRate=rate;for(const emulationModel of SDK.targetManager.models(SDK.EmulationModel))
emulationModel.setCPUThrottlingRate(this._cpuThrottlingRate);let icon=null;if(this._cpuThrottlingRate!==MobileThrottling.CPUThrottlingRates.NoThrottling){Host.userMetrics.actionTaken(Host.UserMetrics.Action.CpuThrottlingEnabled);icon=UI.Icon.create('smallicon-warning');icon.title=Common.UIString('CPU throttling is enabled');}
const index=this._cpuThrottlingRates.indexOf(this._cpuThrottlingRate);for(const control of this._cpuThrottlingControls)
control.setSelectedIndex(index);UI.inspectorView.setPanelIcon('timeline',icon);this.dispatchEventToListeners(MobileThrottling.ThrottlingManager.Events.RateChanged,this._cpuThrottlingRate);}
modelAdded(emulationModel){if(this._cpuThrottlingRate!==MobileThrottling.CPUThrottlingRates.NoThrottling)
emulationModel.setCPUThrottlingRate(this._cpuThrottlingRate);}
modelRemoved(emulationModel){}
createCPUThrottlingSelector(){const control=new UI.ToolbarComboBox(event=>this.setCPUThrottlingRate(this._cpuThrottlingRates[event.target.selectedIndex]));this._cpuThrottlingControls.add(control);const currentRate=this._cpuThrottlingRate;for(let i=0;i<this._cpuThrottlingRates.length;++i){const rate=this._cpuThrottlingRates[i];const title=rate===1?Common.UIString('No throttling'):Common.UIString('%d\xD7 slowdown',rate);const option=control.createOption(title);control.addOption(option);if(currentRate===rate)
control.setSelectedIndex(i);}
return control;}};MobileThrottling.ThrottlingManager.Events={RateChanged:Symbol('RateChanged')};MobileThrottling.ThrottlingManager.ActionDelegate=class{handleAction(context,actionId){if(actionId==='network-conditions.network-online'){SDK.multitargetNetworkManager.setNetworkConditions(SDK.NetworkManager.NoThrottlingConditions);return true;}
if(actionId==='network-conditions.network-low-end-mobile'){SDK.multitargetNetworkManager.setNetworkConditions(SDK.NetworkManager.Slow3GConditions);return true;}
if(actionId==='network-conditions.network-mid-tier-mobile'){SDK.multitargetNetworkManager.setNetworkConditions(SDK.NetworkManager.Fast3GConditions);return true;}
if(actionId==='network-conditions.network-offline'){SDK.multitargetNetworkManager.setNetworkConditions(SDK.NetworkManager.OfflineConditions);return true;}
return false;}};MobileThrottling.throttlingManager=function(){return self.singleton(MobileThrottling.ThrottlingManager);};;self['WorkerMain']=self['WorkerMain']||{};WorkerMain.WorkerMain=class extends Common.Object{run(){const capabilities=SDK.Target.Capability.Browser|SDK.Target.Capability.Log|SDK.Target.Capability.Network|SDK.Target.Capability.Target|SDK.Target.Capability.Inspector;SDK.targetManager.createTarget('main',Common.UIString('Main'),capabilities,this._createMainConnection.bind(this),null,false);InspectorFrontendHost.connectionReady();new MobileThrottling.NetworkPanelIndicator();}
_createMainConnection(params){return SDK.createMainConnection(params,()=>Components.TargetDetachedDialog.webSocketConnectionLost());}};SDK.ChildTargetManager.install(({target,waitingForDebugger})=>{const parentTarget=target.parentTarget();if(!parentTarget.parentTarget()&&waitingForDebugger){const debuggerModel=target.model(SDK.DebuggerModel);if(debuggerModel)
debuggerModel.pause();}});;;Runtime.cachedResources["mobile_throttling/throttlingSettingsTab.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    overflow:hidden;\n}\n\n.header {\n    padding: 0 0 6px;\n    border-bottom: 1px solid #EEEEEE;\n    font-size: 18px;\n    font-weight: normal;\n    flex: none;\n}\n\n.add-conditions-button {\n    flex: none;\n    margin: 10px 2px;\n    min-width: 140px;\n    align-self: flex-start;\n}\n\n.conditions-list {\n    max-width: 500px;\n    min-width: 340px;\n    flex: auto;\n}\n\n.conditions-list-item {\n    padding: 3px 5px 3px 5px;\n    height: 30px;\n    display: flex;\n    align-items: center;\n    position: relative;\n    flex: auto 1 1;\n}\n\n.conditions-list-text {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    flex: 0 0 70px;\n    -webkit-user-select: none;\n    color: #222;\n    text-align: end;\n    position: relative;\n}\n\n.conditions-list-title {\n    text-align: start;\n    flex: auto;\n    display: flex;\n    align-items: flex-start;\n}\n\n.conditions-list-title-text {\n    overflow: hidden;\n    flex: auto;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n\n.conditions-list-separator {\n    flex: 0 0 1px;\n    background-color: rgb(231, 231, 231);\n    height: 30px;\n    margin: 0 4px;\n}\n\n.conditions-list-separator-invisible {\n    visibility: hidden;\n    height: 100% !important;\n}\n\n.conditions-edit-row {\n    flex: none;\n    display: flex;\n    flex-direction: row;\n    margin: 6px 5px;\n}\n\n.conditions-edit-row input {\n    width: 100%;\n    text-align: inherit;\n}\n\n.conditions-edit-optional {\n    position: absolute;\n    bottom: -20px;\n    right: 0;\n    color: rgb(128, 128, 128);\n}\n\n/*# sourceURL=mobile_throttling/throttlingSettingsTab.css */";