/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.iq80.leveldb.impl.LogChunkType;
import org.iq80.leveldb.impl.LogWriter;
import org.iq80.leveldb.impl.Logs;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;

public class FileChannelLogWriter
implements LogWriter {
    private final File file;
    private final long fileNumber;
    private final FileChannel fileChannel;
    private final AtomicBoolean closed = new AtomicBoolean();
    private int blockOffset;

    public FileChannelLogWriter(File file, long fileNumber) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)file, (Object)"file is null");
        Preconditions.checkArgument((fileNumber >= 0L ? 1 : 0) != 0, (Object)"fileNumber is negative");
        this.file = file;
        this.fileNumber = fileNumber;
        this.fileChannel = new FileOutputStream(file).getChannel();
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public synchronized void close() {
        this.closed.set(true);
        try {
            this.fileChannel.force(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Closeables.closeQuietly((Closeable)this.fileChannel);
    }

    @Override
    public synchronized void delete() {
        this.closed.set(true);
        Closeables.closeQuietly((Closeable)this.fileChannel);
        this.file.delete();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getFileNumber() {
        return this.fileNumber;
    }

    @Override
    public synchronized void addRecord(Slice record, boolean force) throws IOException {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"Log has been closed");
        SliceInput sliceInput = record.input();
        boolean begin = true;
        do {
            int fragmentLength;
            boolean end;
            int bytesAvailableInBlock;
            int bytesRemainingInBlock;
            Preconditions.checkState(((bytesRemainingInBlock = 32768 - this.blockOffset) >= 0 ? 1 : 0) != 0);
            if (bytesRemainingInBlock < 7) {
                if (bytesRemainingInBlock > 0) {
                    this.fileChannel.write(ByteBuffer.allocate(bytesRemainingInBlock));
                }
                this.blockOffset = 0;
                bytesRemainingInBlock = 32768 - this.blockOffset;
            }
            Preconditions.checkState(((bytesAvailableInBlock = bytesRemainingInBlock - 7) >= 0 ? 1 : 0) != 0);
            if (sliceInput.available() > bytesAvailableInBlock) {
                end = false;
                fragmentLength = bytesAvailableInBlock;
            } else {
                end = true;
                fragmentLength = sliceInput.available();
            }
            LogChunkType type = begin && end ? LogChunkType.FULL : (begin ? LogChunkType.FIRST : (end ? LogChunkType.LAST : LogChunkType.MIDDLE));
            this.writeChunk(type, sliceInput.readSlice(fragmentLength));
            begin = false;
        } while (sliceInput.isReadable());
        if (force) {
            this.fileChannel.force(false);
        }
    }

    private void writeChunk(LogChunkType type, Slice slice) throws IOException {
        Preconditions.checkArgument((slice.length() <= 65535 ? 1 : 0) != 0, (String)"length %s is larger than two bytes", (Object[])new Object[]{slice.length()});
        Preconditions.checkArgument((this.blockOffset + 7 <= 32768 ? 1 : 0) != 0);
        Slice header = this.newLogRecordHeader(type, slice, slice.length());
        header.getBytes(0, this.fileChannel, header.length());
        slice.getBytes(0, this.fileChannel, slice.length());
        this.blockOffset += 7 + slice.length();
    }

    private Slice newLogRecordHeader(LogChunkType type, Slice slice, int length) {
        int crc = Logs.getChunkChecksum(type.getPersistentId(), slice.getRawArray(), slice.getRawOffset(), length);
        SliceOutput header = Slices.allocate(7).output();
        header.writeInt(crc);
        header.writeByte((byte)(length & 0xFF));
        header.writeByte((byte)(length >>> 8));
        header.writeByte((byte)type.getPersistentId());
        return header.slice();
    }
}

