/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDataSupport
implements CompositeData,
Serializable {
    private static final long serialVersionUID = 8003518976613702244L;
    private SortedMap<String, Object> contents;
    private CompositeType compositeType;

    public CompositeDataSupport(CompositeType type, Map<String, ?> items) throws OpenDataException {
        this(type, items.keySet().toArray(new String[items.size()]), items.values().toArray());
    }

    public CompositeDataSupport(CompositeType type, String[] names, Object[] values) throws OpenDataException {
        if (type == null) {
            throw new IllegalArgumentException("The given composite type is null.");
        }
        this.compositeType = type;
        if (names == null) {
            throw new IllegalArgumentException("The names array is null.");
        }
        if (values == null) {
            throw new IllegalArgumentException("The values array is null.");
        }
        if (names.length != values.length) {
            throw new IllegalArgumentException("The sizes of the arrays differ.");
        }
        Set<String> typeKeys = type.keySet();
        if (typeKeys.size() != names.length) {
            throw new OpenDataException("The number of field names does not match the type description.");
        }
        this.contents = new TreeMap<String, Object>();
        int a = 0;
        while (a < names.length) {
            if (names[a] == null) {
                throw new IllegalArgumentException("Element " + a + " of the names " + "array is null.");
            }
            if (names[a].length() == 0) {
                throw new IllegalArgumentException("Element " + a + " of the names " + "array is an empty string.");
            }
            if (values[a] == null) {
                throw new IllegalArgumentException("Element " + a + " of the values " + "array is null.");
            }
            if (!typeKeys.contains(names[a])) {
                throw new OpenDataException("The name, " + names[a] + ", is not a " + "field in the given type description.");
            }
            if (!type.getType(names[a]).isValue(values[a])) {
                throw new OpenDataException("The value, " + values[a] + ", is not a " + "valid value for the " + names[a] + " field.");
            }
            this.contents.put(names[a], values[a]);
            ++a;
        }
    }

    @Override
    public boolean containsKey(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        return this.contents.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeData)) {
            return false;
        }
        CompositeData data = (CompositeData)obj;
        if (!data.getCompositeType().equals(this.compositeType)) {
            return false;
        }
        for (String key : this.contents.keySet()) {
            if (!data.containsKey(key)) {
                return false;
            }
            if (data.get(key).equals(this.contents.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("The supplied key is null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("The supplied key is the empty string.");
        }
        if (!this.contents.containsKey(key)) {
            throw new InvalidKeyException("The supplied key does not exist.");
        }
        return this.contents.get(key);
    }

    @Override
    public Object[] getAll(String[] keys) {
        Object[] values = new Object[keys.length];
        int a = 0;
        while (a < keys.length) {
            values[a] = this.get(keys[a]);
            ++a;
        }
        return values;
    }

    @Override
    public CompositeType getCompositeType() {
        return this.compositeType;
    }

    @Override
    public int hashCode() {
        int code = this.compositeType.hashCode();
        for (Object o : this.contents.values()) {
            code += o.hashCode();
        }
        return code;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[compositeType=" + this.compositeType + ",contents=" + this.contents + "]";
    }

    @Override
    public Collection<?> values() {
        return Collections.unmodifiableCollection(this.contents.values());
    }
}

