/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import gnu.java.awt.EventModifier;
import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectInputStream;

public class MouseEvent
extends InputEvent {
    private static final long serialVersionUID = -991214153494842848L;
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 507;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int NOBUTTON = 0;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    private int x;
    private int y;
    private int absX;
    private int absY;
    private final int clickCount;
    private int button;
    private final boolean popupTrigger;

    public MouseEvent(Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger, int button) {
        this(source, id, when, modifiers, x, y, 0, 0, clickCount, popupTrigger, button);
    }

    public MouseEvent(Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger) {
        this(source, id, when, modifiers, x, y, clickCount, popupTrigger, 0);
    }

    public MouseEvent(Component source, int id, long when, int modifiers, int x, int y, int absX, int absY, int clickCount, boolean popupTrigger, int button) {
        super(source, id, when, modifiers);
        this.x = x;
        this.y = y;
        this.clickCount = clickCount;
        this.popupTrigger = popupTrigger;
        this.button = button;
        if (button < 0 || button > 3) {
            throw new IllegalArgumentException();
        }
        if ((modifiers & 0x3F) != 0) {
            if ((modifiers & 0x10) != 0) {
                this.button = 1;
            } else if ((modifiers & 8) != 0) {
                this.button = 2;
            } else if ((modifiers & 4) != 0) {
                this.button = 3;
            }
        }
        if (id == 502) {
            this.modifiersEx &= 0xFFFFE3FF;
        }
        this.absX = absX;
        this.absY = absY;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getLocationOnScreen() {
        return new Point(this.absX, this.absY);
    }

    public int getXOnScreen() {
        return this.absX;
    }

    public int getYOnScreen() {
        return this.absY;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public void translatePoint(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getButton() {
        return this.button;
    }

    public boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public static String getMouseModifiersText(int modifiers) {
        if (((modifiers &= 0x3F) & 8) != 0) {
            modifiers |= 0x800;
        }
        if ((modifiers & 4) != 0) {
            modifiers |= 0x1000;
        }
        return MouseEvent.getModifiersExText(EventModifier.extend(modifiers));
    }

    public String paramString() {
        CPStringBuilder s = new CPStringBuilder();
        switch (this.id) {
            case 500: {
                s.append("MOUSE_CLICKED,(");
                break;
            }
            case 501: {
                s.append("MOUSE_PRESSED,(");
                break;
            }
            case 502: {
                s.append("MOUSE_RELEASED,(");
                break;
            }
            case 503: {
                s.append("MOUSE_MOVED,(");
                break;
            }
            case 504: {
                s.append("MOUSE_ENTERED,(");
                break;
            }
            case 505: {
                s.append("MOUSE_EXITED,(");
                break;
            }
            case 506: {
                s.append("MOUSE_DRAGGED,(");
                break;
            }
            case 507: {
                s.append("MOUSE_WHEEL,(");
                break;
            }
            default: {
                s.append("unknown type,(");
            }
        }
        s.append(this.x).append(',').append(this.y).append("),button=").append(this.button);
        if (this.modifiersEx != 0) {
            s.append(",extModifiers=").append(MouseEvent.getModifiersExText(this.modifiersEx));
        }
        s.append(",clickCount=").append(this.clickCount);
        s.append(",consumed=").append(this.consumed);
        return s.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if ((this.modifiers & 0x3F) != 0) {
            if ((this.modifiers & 0x10) != 0) {
                this.button = 1;
            } else if ((this.modifiers & 8) != 0) {
                this.button = 2;
            } else if ((this.modifiers & 4) != 0) {
                this.button = 3;
            }
            this.modifiersEx = EventModifier.extend(this.modifiers) & 0x3FC0;
        }
    }
}

