/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import virtuoso.jdbc4.ConnectionWrapper;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.jdbc4.VirtuosoException;

public class VirtuosoPooledConnection
implements PooledConnection,
Cloneable {
    private LinkedList<Object> listeners = null;
    private LinkedList<Object> pStmtsPool = null;
    private ConnectionWrapper connWrapper = null;
    private VirtuosoConnection conn;
    private boolean sendEvent = true;
    private int maxStatements = 0;
    protected String connURL;
    protected int hashConnURL;
    protected long tmClosed;

    protected VirtuosoPooledConnection(VirtuosoConnection virtuosoConnection, String string) {
        this.conn = virtuosoConnection;
        this.conn.pooled_connection = this;
        this.connURL = string;
        this.hashConnURL = this.connURL.hashCode();
        this.tmClosed = System.currentTimeMillis();
    }

    protected VirtuosoPooledConnection(VirtuosoConnection virtuosoConnection, String string, VirtuosoConnectionPoolDataSource virtuosoConnectionPoolDataSource) {
        this(virtuosoConnection, string);
        this.init(virtuosoConnectionPoolDataSource);
    }

    protected void init(VirtuosoConnectionPoolDataSource virtuosoConnectionPoolDataSource) {
        this.listeners = new LinkedList();
        this.addConnectionEventListener(virtuosoConnectionPoolDataSource);
        this.maxStatements = virtuosoConnectionPoolDataSource.getMaxStatements();
        this.conn.pooled_connection = this;
    }

    public synchronized void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listeners.clear();
    }

    protected synchronized Object clone() {
        try {
            VirtuosoPooledConnection virtuosoPooledConnection = (VirtuosoPooledConnection)super.clone();
            virtuosoPooledConnection.listeners = null;
            virtuosoPooledConnection.connWrapper = null;
            virtuosoPooledConnection.conn = this.conn;
            virtuosoPooledConnection.pStmtsPool = null;
            virtuosoPooledConnection.sendEvent = true;
            virtuosoPooledConnection.maxStatements = 0;
            virtuosoPooledConnection.connURL = this.connURL;
            virtuosoPooledConnection.hashConnURL = this.hashConnURL;
            virtuosoPooledConnection.tmClosed = this.tmClosed;
            return virtuosoPooledConnection;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    protected VirtuosoPooledConnection reuse() {
        LinkedList<Object> linkedList = this.connWrapper.reset();
        VirtuosoPooledConnection virtuosoPooledConnection = (VirtuosoPooledConnection)this.clone();
        this.listeners.clear();
        this.connWrapper = null;
        this.conn.pooled_connection = null;
        this.conn.xa_connection = null;
        this.conn = null;
        this.pStmtsPool = null;
        this.connURL = null;
        virtuosoPooledConnection.tmClosed = System.currentTimeMillis();
        virtuosoPooledConnection.pStmtsPool = linkedList;
        virtuosoPooledConnection.conn.pooled_connection = virtuosoPooledConnection;
        virtuosoPooledConnection.conn.clearFutures();
        return virtuosoPooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        LinkedList<Object> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(connectionEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        LinkedList<Object> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(connectionEventListener);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        SQLException sQLException = null;
        if (this.connWrapper != null) {
            try {
                this.connWrapper.closeAll();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            this.connWrapper = null;
        }
        if (this.conn != null) {
            this.conn.pooled_connection = null;
            this.conn.xa_connection = null;
        }
        this.conn = null;
        if (this.pStmtsPool != null) {
            this.pStmtsPool.clear();
        }
        this.pStmtsPool = null;
        this.sendErrorEvent(new VirtuosoException("Physical Connection is closed", 0));
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public void closeAll() throws SQLException {
        if (this.connWrapper != null) {
            this.connWrapper.clearStmtsCache();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            VirtuosoException virtuosoException = new VirtuosoException("Physical Connection is closed", 0);
            this.sendErrorEvent(virtuosoException);
            throw virtuosoException;
        }
        if (this.connWrapper != null) {
            this.sendEvent = false;
            this.pStmtsPool = this.connWrapper.reset();
            this.connWrapper.close();
            this.sendEvent = true;
        }
        this.connWrapper = new ConnectionWrapper(this.conn, this, this.pStmtsPool, this.maxStatements);
        return this.connWrapper;
    }

    public VirtuosoConnection getVirtuosoConnection() throws SQLException {
        if (this.conn == null) {
            VirtuosoException virtuosoException = new VirtuosoException("Connection is closed", 0);
            this.sendErrorEvent(virtuosoException);
            throw virtuosoException;
        }
        return this.conn;
    }

    public boolean isConnectionLost() {
        if (this.conn == null) {
            return true;
        }
        return this.conn.isClosed() || this.conn.isConnectionLost();
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
    }

    protected boolean isClosed() {
        return this.conn == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCloseEvent() {
        LinkedList linkedList;
        if (!this.sendEvent) {
            return;
        }
        if (this.listeners == null) {
            return;
        }
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        Object object = this.listeners;
        synchronized (object) {
            linkedList = (LinkedList)this.listeners.clone();
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            ((ConnectionEventListener)object.next()).connectionClosed(connectionEvent);
        }
        linkedList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendErrorEvent(SQLException sQLException) {
        LinkedList linkedList;
        if (this.listeners == null) {
            return;
        }
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        Object object = this.listeners;
        synchronized (object) {
            linkedList = (LinkedList)this.listeners.clone();
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            ((ConnectionEventListener)object.next()).connectionErrorOccurred(connectionEvent);
        }
        linkedList.clear();
    }
}

