/*
 *  Kartograph 0.8.2 - a svg mapping library
 *  Copyright (C) 2011-2013  Gregor Aisch
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
*/
!function(){function t(){var t={},e=[],n=1,o=1;return t.size=function(r){return arguments.length?(o=r,t):o},t.iterations=function(r){return arguments.length?(n=r,t):n},t.add=function(r){return e.push(r),t},t.means=function(){for(var t=[],i={},a=Math.min(o,e.length),s=0,l=2*a;l>s;s++){var u=e[~~(Math.random()*e.length)],p=u.x+"/"+u.y;if(!(p in i)&&(i[p]=1,t.push({x:u.x,y:u.y})>=a))break}a=t.length;for(var h=0;n>h;h++){for(var c=r().points(t),s=0;a>s;s++){var f=t[s];f.sumX=0,f.sumY=0,f.size=0,f.points=[],f.indices=[]}for(var s=0;s<e.length;s++){var d=e[s],f=c.find(d);f.sumX+=d.x,f.sumY+=d.y,f.size++,f.points.push(d),f.indices.push(s)}for(var s=0;a>s;s++){var f=t[s];f.size&&(f.x=f.sumX/f.size,f.y=f.sumY/f.size)}}return t},t}function r(){function t(r,n){if(r.length){var o=a[n%a.length],i=r.length>>1;return r.sort(e(o)),{axis:o,point:r[i],left:t(r.slice(0,i),n+1),right:t(r.slice(i+1),n+1)}}}function r(t,r){for(var e=0,n=0;n<a.length;n++){var o=a[n],i=t[o]-r[o];e+=i*i}return e}function e(t){return function(r,e){return r=r[t],e=e[t],e>r?-1:r>e?1:0}}function n(t,e,o){if(r(t.point,e)<r(o.point,e)&&(o=t),t.left&&(o=n(t.left,e,o)),t.right){var i=t.point[t.axis]-e[t.axis];i*i<r(o.point,e)&&(o=n(t.right,e,o))}return o}var o,i={},a=["x","y"],s=[];return i.axes=function(t){return arguments.length?(a=t,i):a},i.points=function(t){return arguments.length?(s=t,o=null,i):s},i.find=function(t){return n(i.root(),t,o).point},i.root=function(){return o||(o=t(s,0))},i}var e,n,o,i,a,l,u,p,h,c,f,d,y,v,g,_,b,x,w,M,P,C,j,A,B,L,S,k,I,N,G,z,E,T,R,F,V,O,H,X,q,D,U,Q,Y,W,Z,$,K,J,tr,rr,er,nr,or,ir,ar,sr,lr,ur,pr,hr,cr,fr,dr,yr,mr,vr,gr,_r,br,xr,wr,Mr,Pr,Cr,jr,Ar,Br,Lr,Sr,kr,Ir,Nr,Gr,zr,Er,Tr,Rr,Fr,Vr,Or,Hr,Xr,qr,Dr,Ur,Qr,Yr,Wr,Zr,$r,Kr,Jr,te,re,ee,ne,oe,ie={}.hasOwnProperty,ae=function(t,r){function e(){this.constructor=t}for(var n in r)ie.call(r,n)&&(t[n]=r[n]);return e.prototype=r.prototype,t.prototype=new e,t.__super__=r.prototype,t},se=function(t,r){return function(){return t.apply(r,arguments)}},le=[].indexOf||function(t){for(var r=0,e=this.length;e>r;r++)if(r in this&&this[r]===t)return r;return-1};Br="undefined"!=typeof exports&&null!==exports?exports:this,br=Br.$K=null!=(Rr=Br.kartograph)?Rr:Br.kartograph={},br.version="0.8.1",e=Br.jQuery,br.__verbose=!1,Sr=function(){var t;try{return console.warn.apply(console,arguments)}catch(r){t=r;try{return opera.postError.apply(opera,arguments)}catch(r){return t=r,alert(Array.prototype.join.call(arguments," "))}}},xr=function(){var t;if(br.__verbose)try{return console.debug.apply(console,arguments)}catch(r){t=r;try{return opera.postError.apply(opera,arguments)}catch(r){return t=r,alert(Array.prototype.join.call(arguments," "))}}},null==(Fr=(Er=String.prototype).trim)&&(Er.trim=function(){return this.replace(/^\s+|\s+$/g,"")}),Array.prototype.indexOf||(Array.prototype.indexOf=function(t){"use strict";if(null==this)throw new TypeError;var r=Object(this),e=r.length>>>0;if(0===e)return-1;var n=0;if(arguments.length>0&&(n=Number(arguments[1]),n!=n?n=0:0!=n&&1/0!=n&&n!=-1/0&&(n=(n>0||-1)*Math.floor(Math.abs(n)))),n>=e)return-1;for(var o=n>=0?n:Math.max(e-Math.abs(n),0);e>o;o++)if(o in r&&r[o]===t)return o;return-1}),zr=function(){var t,r,e,n,o;for(t={},o="Boolean Number String Function Array Date RegExp Undefined Null".split(" "),e=0,n=o.length;n>e;e++)r=o[e],t["[object "+r+"]"]=r.toLowerCase();return function(r){var e;return e=Object.prototype.toString.call(r),t[e]||"object"}}(),i=function(){function t(t,r,e,n){var o;null==t&&(t=0),null==r&&(r=0),null==e&&(e=null),null==n&&(n=null),o=this,null===e?(o.xmin=Number.MAX_VALUE,o.xmax=-1*Number.MAX_VALUE):(o.xmin=o.left=t,o.xmax=o.right=t+e,o.width=e),null===n?(o.ymin=Number.MAX_VALUE,o.ymax=-1*Number.MAX_VALUE):(o.ymin=o.top=r,o.ymax=o.bottom=n+r,o.height=n)}return t.prototype.update=function(t,r){var e;return null==r&&(r=t[1],t=t[0]),e=this,e.xmin=Math.min(e.xmin,t),e.ymin=Math.min(e.ymin,r),e.xmax=Math.max(e.xmax,t),e.ymax=Math.max(e.ymax,r),e.left=e.xmin,e.top=e.ymin,e.right=e.xmax,e.bottom=e.ymax,e.width=e.xmax-e.xmin,e.height=e.ymax-e.ymin,this},t.prototype.intersects=function(t){return t.left<s.right&&t.right>s.left&&t.top<s.bottom&&t.bottom>s.top},t.prototype.inside=function(t,r){var e;return e=this,t>=e.left&&t<=e.right&&r>=e.top&&r<=e.bottom},t.prototype.join=function(t){var r;return r=this,r.update(t.left,t.top),r.update(t.right,t.bottom),this},t}(),i.fromXML=function(t){var r,e,n,o;return n=Number(t.getAttribute("x")),o=Number(t.getAttribute("y")),e=Number(t.getAttribute("w")),r=Number(t.getAttribute("h")),new br.BBox(n,o,e,r)},br.BBox=i,null==(Zr=br.geom)&&(br.geom={}),null==(Kr=(Tr=br.geom).clipping)&&(Tr.clipping={}),d=function(){function t(){}var r,e,n,o,i;return e=0,n=1,o=2,r=4,i=8,t.prototype.compute_out_code=function(t,r,e){var n,o;return o=this,n=o.INSIDE,r<t.left?n|=o.LEFT:r>t.right&&(n|=o.RIGHT),e<t.top?n|=o.TOP:e>t.bottom&&(n|=o.BOTTOM),n},t.prototype.clip=function(t,r,e,n,o){var i,a,s,l,u,p,h;for(u=this,a=u.compute_out_code(t,r,e),s=u.compute_out_code(t,n,o),i=False;True;){if(!(a|s)){i=True;break}if(a&s)break;l=0===code?s:a,l&u.TOP?(p=r+(n-r)*(t.top-e)/(o-e),h=t.top):l&u.BOTTOM?(p=r+(n-r)*(t.bottom-e)/(o-e),h=t.bottom):l&u.RIGHT?(h=e+(o-e)*(t.right-r)/(n-r),p=t.right):l&u.LEFT&&(h=e+(o-e)*(t.left-r)/(n-r),p=t.left),l===a?(r=p,e=h,a=u.compute_out_code(t,r,e)):(n=p,o=h,s=u.compute_out_code(t,n,o))}return i?[r,e,n,o]:null},t}(),br.geom.clipping.CohenSutherland=d,S=function(){function t(t,r,n){var o,i;i=this,i.container=o=e(t),null==r&&(r=o.width()),null==n&&(n=o.height()),0===n&&(n="auto"),i.size={h:n,w:r},i.markers=[],i.pathById={},i.container.addClass("kartograph")}return t.prototype.createSVGLayer=function(t){var r,n,o,i,a,s,l,u;return i=this,null==(u=i._layerCnt)&&(i._layerCnt=0),o=i._layerCnt++,l=i.viewport,n=i.container,a=Raphael(n[0],l.width,l.height),s=e(a.canvas),s.css({position:"absolute",top:"0px",left:"0px","z-index":o+5}),"static"===n.css("position")&&n.css({position:"relative",height:l.height+"px"}),s.addClass(t),r=e("desc",a.canvas).text(),e("desc",a.canvas).text(r.replace("with ","with kartograph "+br.version+" and ")),a},t.prototype.createHTMLLayer=function(t){var r,n,o,i,a,s;return i=this,a=i.viewport,r=i.container,null==(s=i._layerCnt)&&(i._layerCnt=0),o=i._layerCnt++,n=e('<div class="layer '+t+'" />'),n.css({position:"absolute",top:"0px",left:"0px",width:a.width+"px",height:a.height+"px","z-index":o+5}),r.append(n),n},t.prototype.load=function(t,r,n){var o,i,a,s;return i=this,o=e.Deferred(),i.clear(),i.opts=null!=n?n:{},null==(s=(a=i.opts).zoom)&&(a.zoom=1),i.mapLoadCallback=r,i._loadMapDeferred=o,i._lastMapUrl=t,i.cacheMaps&&null!=br.__mapCache[t]?i._mapLoaded(br.__mapCache[t]):e.ajax({url:t,dataType:"text",success:i._mapLoaded,context:i,error:function(t,r,e){return Sr(t,r,e)}}),o.promise()},t.prototype.loadMap=function(){return this.load.apply(this,arguments)},t.prototype.setMap=function(t,r){var e,n,o;e=this,e.opts=null!=r?r:{},null==(o=(n=e.opts).zoom)&&(n.zoom=1),e._lastMapUrl="string",e._mapLoaded(t)},t.prototype._mapLoaded=function(t){var r,n,o,a,s,l,u,p,h,c,f,d,y,m,v,g,_;l=this,l.cacheMaps&&(null==(y=br.__mapCache)&&(br.__mapCache={}),br.__mapCache[l._lastMapUrl]=t);try{t=e(t)}catch(b){return o=b,Sr("something went horribly wrong while parsing svg"),l._loadMapDeferred.reject("could not parse svg"),void 0}l.svgSrc=t,r=e("view",t),null==l.paper&&(f=l.size.w,a=l.size.h,"auto"===a&&(p=r.attr("w")/r.attr("h"),a=f/p),l.viewport=new i(0,0,f,a)),c=l.viewport,l.viewAB=n=br.View.fromXML(r[0]),u=null!=(m=l.opts.padding)?m:0,s=null!=(v=l.opts.halign)?v:"center",h=null!=(g=l.opts.valign)?g:"center",d=null!=(_=l.opts.zoom)?_:1,l.viewBC=new br.View(l.viewAB.asBBox(),c.width*d,c.height*d,u,s,h),l.proj=br.Proj.fromXML(e("proj",r)[0]),null!=l.mapLoadCallback&&l.mapLoadCallback(l),null!=l._loadMapDeferred&&l._loadMapDeferred.resolve(l)},t.prototype.addLayer=function(t,r){var n,o,i,a,s,l,u,p,h,c,f,d,y,m,v,g,_;return null==r&&(r={}),u=this,null==(v=u.layerIds)&&(u.layerIds=[]),null==(g=u.layers)&&(u.layers={}),null==u.paper&&(u.paper=u.createSVGLayer()),d=t,"object"===zr(r)?(s=r.name,c=r.key,m=r.title):r={},l=u.paper,r.add_svg_layer&&(l=u.createSVGLayer()),null==s&&(s=d),y=e("#"+d,u.svgSrc),0!==y.length?(a=new V(s,c,u,r.filter,l),n=e("*",y[0]),f=n.length,o=null!=(_=r.chunks)?_:f,i=0,h=function(){var t,e,s,l,u,c;for(t=o*i,e=u=0;o>=0?o>u:u>o;e=o>=0?++u:--u)f>t+e&&a.addPath(n.get(t+e),m);if(null!=r.styles){c=r.styles;for(s in c)l=c[s],a.style(s,l)}return i++,f>i*o?setTimeout(h,0):p()},p=function(){var t,e,n,o;for(a.paths.length>0&&(u.layers[s]=a,u.layerIds.push(s)),t=["click","mouseenter","mouseleave","dblclick","mousedown","mouseup","mouseover","mouseout"],n=0,o=t.length;o>n;n++)e=t[n],"function"===zr(r[e])&&a.on(e,r[e]);return null!=r.tooltips&&a.tooltips(r.tooltips),null!=r.done?r.done():void 0},null!=r.chunks?setTimeout(h,0):h(),u):void 0},t.prototype.getLayer=function(t){var r;return r=this,null==r.layers[t]?(Sr("could not find layer "+t),null):r.layers[t]},t.prototype.getLayerPath=function(t,r){var e,n;return n=this,e=n.getLayer(t),null!=e?"object"===zr(r)?e.getPaths(r)[0]:e.getPath(r):null},t.prototype.onLayerEvent=function(t,r,e){var n;return n=this,n.getLayer(e).on(t,r),n},t.prototype.addMarker=function(t){var r,e;return r=this,r.markers.push(t),e=r.viewBC.project(r.viewAB.project(r.proj.project(t.lonlat.lon,t.lonlat.lat))),t.render(e[0],e[1],r.container,r.paper)},t.prototype.clearMarkers=function(){var t,r,e,n,o;for(r=this,o=r.markers,e=0,n=o.length;n>e;e++)t=o[e],t.clear();return r.markers=[]},t.prototype.fadeIn=function(t){var r,e,n,o,i,a,s,l,u,p,h;null==t&&(t={}),i=this,o=null!=(l=t.layer)?l:i.layerIds[i.layerIds.length-1],e=null!=(u=t.duration)?u:500,p=i.layers[o].pathsById,h=[];for(n in p)s=p[n],h.push(function(){var t,n,o;for(o=[],t=0,n=s.length;n>t;t++)a=s[t],r="function"===zr(e)?e(a.data):e,a.svgPath.attr("opacity",0),o.push(a.svgPath.animate({opacity:1},r));return o}());return h},t.prototype.loadCoastline=function(){var t;return t=this,e.ajax({url:"coastline.json",success:t.renderCoastline,context:t})},t.prototype.resize=function(t,r){var e,n,o,i,a,s,l,u,p,h,c,f,d,y,m,v,g;a=this,e=a.container,null==t&&(t=e.width()),null==r&&(r=e.height()),a.viewport=p=new br.BBox(0,0,t,r),null!=a.paper&&a.paper.setSize(p.width,p.height),p=a.viewport,s=null!=(d=a.opts.padding)?d:0,n=null!=(y=a.opts.halign)?y:"center",u=null!=(m=a.opts.valign)?m:"center",h=a.opts.zoom,a.viewBC=new br.View(a.viewAB.asBBox(),p.width*h,p.height*h,s,n,u),v=a.layers;for(o in v)i=v[o],i.setView(a.viewBC);if(null!=a.symbolGroups)for(g=a.symbolGroups,c=0,f=g.length;f>c;c++)l=g[c],l.onResize()},t.prototype.lonlat2xy=function(t){var r,e;return e=this,2===t.length&&(t=new br.LonLat(t[0],t[1])),3===t.length&&(t=new br.LonLat(t[0],t[1],t[2])),r=e.proj.project(t.lon,t.lat,t.alt),e.viewBC.project(e.viewAB.project(r))},t.prototype.addSymbolGroup=function(t){var r,e;return r=this,null==(e=r.symbolGroups)&&(r.symbolGroups=[]),r.symbolGroups.push(t)},t.prototype.removeSymbols=function(t){var r,e,n,o,i,a;if(r=this,null!=t)return r.symbolGroups[t].remove();for(i=r.symbolGroups,a=[],n=0,o=i.length;o>n;n++)e=i[n],a.push(e.remove());return a},t.prototype.clear=function(){var t,r,n,o,i,a;if(r=this,null!=r.layers){for(t in r.layers)r.layers[t].remove();r.layers={},r.layerIds=[]}if(null!=r.symbolGroups){for(a=r.symbolGroups,o=0,i=a.length;i>o;o++)n=a[o],n.remove();r.symbolGroups=[]}return null!=r.paper?(e(r.paper.canvas).remove(),r.paper=void 0):void 0},t.prototype.loadCSS=function(t,r){var n;return n=this,Raphael.svg?(e("body").append('<link rel="stylesheet" href="'+t+'" />'),r()):e.ajax({url:t,dataType:"text",success:function(t){return n.styles=br.parsecss(t),r()},error:function(r,e,n){return Sr("error while loading "+t,r,e,n)}})},t.prototype.applyCSS=function(t,r){var e,n,o,i,a,s,l,u,p,h,c,f,d,y,m;if(o=this,null==o.styles)return t;null==(f=o._pathTypes)&&(o._pathTypes=["path","circle","rectangle","ellipse"]),null==(d=o._regardStyles)&&(o._regardStyles=["fill","stroke","fill-opacity","stroke-width","stroke-opacity"]);for(s in o.styles)for(i=s,y=i.split(","),u=0,h=y.length;h>u;u++)if(l=y[u],i=l.split(" "),i=i[i.length-1],i=i.split(":"),!(i.length>1||(i=i[0].split("."),e=i.slice(1),e.length>0&&e.indexOf(r)<0||(i=i[0],o._pathTypes.indexOf(i)>=0&&i!==t.type))))for(a=o.styles[s],m=o._regardStyles,p=0,c=m.length;c>p;p++)n=m[p],null!=a[n]&&t.attr(n,a[n]);return t},t.prototype.style=function(t,r,e,n,o){var i;return i=this,t=i.getLayer(t),null!=t?t.style(r,e,n,o):void 0},t}(),L=br,Br.kartograph=function(t,r,e){return new S(t,r,e)},br.map=function(t,r,e){return new S(t,r,e)},br.__mapCache={},e.extend(Br.kartograph,L),R=function(){function t(t,r,e){null==e&&(e=0),this.lon=Number(t),this.lat=Number(r),this.alt=Number(e)}return t.prototype.distance=function(t){var r,e,n,o,i,a,s,l,u;return u=this,r=6371,a=Math.PI/180,o=(t.lat-u.lat)*a,i=(t.lon-u.lon)*a,s=u.lat*a,l=t.lat*a,e=Math.sin(o/2)*Math.sin(o/2)+Math.sin(i/2)*Math.sin(i/2)*Math.cos(s)*Math.cos(l),n=2*Math.atan2(Math.sqrt(e),Math.sqrt(1-e)),r*n},t}(),G=function(t){function r(t,e,n){null==n&&(n=0),r.__super__.constructor.call(this,e,t,n)}return ae(r,t),r}(R),br.LonLat=R,br.LatLon=G,V=function(){function t(t,r,e,n,o){var i;i=this,i.id=t,i.path_id=r,i.paper=null!=o?o:e.paper,i.view=e.viewBC,i.map=e,i.filter=n}return t.prototype.addPath=function(t,r){var e,n,o,i,a,s,l;return n=this,null==(a=n.paths)&&(n.paths=[]),e=new O(t,n.id,n,r),"function"===zr(n.filter)&&n.filter(e.data)===!1?(e.remove(),void 0):(n.paths.push(e),null!=n.path_id?(null==(s=n.pathsById)&&(n.pathsById={}),null==(l=(o=n.pathsById)[i=e.data[n.path_id]])&&(o[i]=[]),n.pathsById[e.data[n.path_id]].push(e)):void 0)},t.prototype.hasPath=function(t){var r;return r=this,null!=r.pathsById&&null!=r.pathsById[t]},t.prototype.getPathsData=function(){var t,r,e,n,o,i;for(t=this,e=[],i=t.paths,n=0,o=i.length;o>n;n++)r=i[n],e.push(r.data);return e},t.prototype.getPath=function(t){var r;return r=this,r.hasPath(t)?r.pathsById[t][0]:null},t.prototype.getPaths=function(t){var r,e,n,o,i,a,s,l;if(o=this,n=[],"object"===zr(t))for(l=o.paths,a=0,s=l.length;s>a;a++){i=l[a],e=!0;for(r in t)e=e&&i.data[r]===t[r];e&&n.push(i)}return n},t.prototype.setView=function(t){var r,e,n,o,i;for(r=this,i=r.paths,n=0,o=i.length;o>n;n++)e=i[n],e.setView(t);return r},t.prototype.remove=function(){var t,r,e,n,o,i;for(t=this,o=t.paths,i=[],e=0,n=o.length;n>e;e++)r=o[e],i.push(r.remove());return i},t.prototype.style=function(t,r,e,n){var o,i,a,s,l,u,p,h,c,f,d;if(u=this,"object"===zr(t)){for(l in t)h=t[l],u.style(l,h);return u}for(null==e&&(e=0),null==n&&(n=0),d=u.paths,c=0,f=d.length;f>c;c++)p=d[c],h=jr(r,p.data),s=jr(e,p.data),a=jr(n,p.data),s>0?(i={},i[t]=h,o=Raphael.animation(i,1e3*s),p.svgPath.animate(o.delay(1e3*a))):p.svgPath.attr(t,h);return u},t.prototype.on=function(t,r){var n,o,i,a,s,l,u;for(i=this,n=function(){function t(t,r,e){this.type=t,this.cb=r,this.layer=e,this.handle=se(this.handle,this)}return t.prototype.handle=function(t){var r;return i=this,r=i.layer.map.pathById[t.target.getAttribute("id")],i.cb(r.data,r.svgPath,t)},t}(),o=new n(t,r,i),u=i.paths,s=0,l=u.length;l>s;s++)a=u[s],e(a.svgPath.node).bind(t,o.handle);return i},t.prototype.tooltips=function(t,r){var n,o,i,a,s,l,u;for(n=this,i=function(t,n){var o;return o={position:{target:"mouse",viewport:e(window),adjust:{x:7,y:7}},show:{delay:null!=r?r:20},events:{show:function(t,r){return e(".qtip").filter(function(){return this!==r.elements.tooltip.get(0)}).hide()}},content:{}},null!=n?"string"==typeof n?o.content.text=n:e.isArray(n)&&(o.content.title=n[0],o.content.text=n[1]):o.content.text="n/a",e(t.svgPath.node).qtip(o)},u=n.paths,s=0,l=u.length;l>s;s++)o=u[s],a=jr(t,o.data),i(o,a);return n},t.prototype.sort=function(t){var r,e,n,o,i,a;for(e=this,e.paths.sort(function(r,e){var n,o,i;return n=t(r.data),o=t(e.data),n===o?0:null!=(i=n>o)?i:{1:-1}}),r=!1,a=e.paths,o=0,i=a.length;i>o;o++)n=a[o],r&&n.svgPath.insertAfter(r.svgPath),r=n;return e},t}(),jr=function(t,r){return"function"===zr(t)?t(r):t},wr=0,O=function(){function t(t,r,e,n){var o,i,a,s,l,u,p,h,c,f,d,y,m,v;for(l=this,u=e.paper,s=e.map,d=s.viewBC,l.path=p=br.geom.Path.fromSVG(t),l.vpath=d.projectPath(p),l.svgPath=l.vpath.toSVG(u),l.svgPath.data("path",l),null==s.styles?Raphael.svg&&l.svgPath.node.setAttribute("class",r):s.applyCSS(l.svgPath,r),c="path_"+wr++,l.svgPath.node.setAttribute("id",c),s.pathById[c]=l,i={},a=m=0,v=t.attributes.length-1;v>=0?v>=m:m>=v;a=v>=0?++m:--m)o=t.attributes[a],"data-"===o.name.substr(0,5)&&(f=o.value,y=Number(f),""===f.trim()||y!==f||isNaN(y)||(f=y),i[o.name.substr(5)]=f);l.data=i,"string"===zr(n)?h=n:"function"===zr(n)&&(h=n(i)),null!=h&&l.svgPath.attr("title",h)}return t.prototype.setView=function(t){var r,e,n;return r=this,e=t.projectPath(r.path),r.vpath=e,"path"===r.path.type?(n=e.svgString(),r.svgPath.attr({path:n})):"circle"===r.path.type?r.svgPath.attr({cx:e.x,cy:e.y,r:e.r}):void 0},t.prototype.remove=function(){var t;return t=this,t.svgPath.remove()},t}(),br.parsecss=function(t,r){var e,n,o,i,a,s,l,u;for(i={},t=Mr(t),u=t.split("`b%"),s=0,l=u.length;l>s;s++)if(e=u[s],e=e.split("%b`"),!(e.length<2))if(e[0]=Ar(e[0]),o=Cr(e[1]),null!=i[e[0]])for(n in o)a=o[n],i[e[0]][n]=a;else i[e[0]]=o;return"function"!==zr(r)?i:(r(i),void 0)},Pr={},Cr=function(t){var r,e,n,o,i,a;for(n=Pr[t].replace(/^{|}$/g,""),n=Mr(n),e={},a=n.split(";"),o=0,i=a.length;i>o;o++)r=a[o],r=r.split(":"),r.length<2||(e[Ar(r[0])]=Ar(r.slice(1).join(":")));return e},J=/{[^{}]*}/,rr=/\[[^\[\]]*\]|{[^{}]*}|\([^()]*\)|function(\s+\w+)?(\s*%b`\d+`b%){2}/,tr=/(?:\/\*(?:[^\*]|\*[^\/])*\*\/)|(\\.|"(?:[^\\\"]|\\.|\\\n)*"|'(?:[^\\\']|\\.|\\\n)*')/g,er=/%\w`(\d+)`\w%/,Lr=0,Mr=function(t,r){var e,n,o;for(t=t.replace(tr,function(t,r){var e;return r?(e="%s`"+ ++Lr+"`s%",Pr[Lr]=r.replace(/^\\/,""),e):""}),e=r?rr:J;n=e.exec(t);)o="%b`"+ ++Lr+"`b%",Pr[Lr]=n[0],t=t.replace(e,o);return t},Ar=function(t){var r;if(null==t)return t;for(;r=er.exec(t);)t=t.replace(er,Pr[r[1]]);return t.trim()},null==(Jr=br.geom)&&(br.geom={}),Q=function(){function t(t,r,e){var n,o,i,a;for(null==e&&(e=!0),o=this,o.type=t,o.contours=[],i=0,a=r.length;a>i;i++)n=r[i],Ir(n)||n.reverse(),o.contours.push(n);o.closed=e}return t.prototype.clipToBBox=function(){throw"path clipping is not implemented yet"},t.prototype.toSVG=function(t){var r;return r=this.svgString(),t.path(r)},t.prototype.svgString=function(){var t,r,e,n,o,i,a,s,l,u,p,h,c;for(n=this,o="",e=n.closed?"Z M":"M",h=n.contours,s=0,u=h.length;u>s;s++)for(t=h[s],r=!0,o+=""===o?"M":e,l=0,p=t.length;p>l;l++)c=t[l],i=c[0],a=c[1],r||(o+="L"),o+=i+","+a,r=!1;return n.closed&&(o+="Z"),o},t.prototype.area=function(){var t,r,e,n,o,i;if(e=this,null!=e.areas)return e._area;for(e.areas=[],e._area=0,i=e.contours,n=0,o=i.length;o>n;n++)r=i[n],t=kr(r),e.areas.push(t),e._area+=t;return e._area},t.prototype.centroid=function(){var t,r,e,n,o,i,a,s,l,u,p,h,c,f,d,y,m,v,g,_,b,x,w,M,P,C,j,A,B,L,S,k,I,N,G,z,E;if(y=this,null!=y._centroid)return y._centroid;for(e=y.area(),i=a=0,p=j=0,I=y.contours.length-1;I>=0?I>=j:j>=I;p=I>=0?++j:--j)if(o=y.contours[p],n=[],f=o.length,r=y.areas[p],c=r/e,0!==c){for(h=A=0,N=f-1;N>=0?N>=A:A>=N;h=N>=0?++A:--A)if(m=o[h],v=o[(h+1)%f],s=0,n.push(m),m[0]===v[0]&&(s=Math.abs(m[1]-v[1])),m[1]===v[1]&&(s=Math.abs(m[0]-v[0])),s>10)for(t=Math.floor(2*s),g=B=1,G=t-1;G>=1?G>=B:B>=G;g=G>=1?++B:--B)_=[m[0]+g/t*(v[0]-m[0]),m[1]+g/t*(v[1]-m[1])],n.push(_);for(w=P=M=C=0,f=n.length,S=[],b=0,h=L=0,z=f-1;z>=0?z>=L:L>=z;h=z>=0?++L:--L)m=n[h],v=n[(h+1)%f],l=v[0]-m[0],u=v[1]-m[1],d=Math.sqrt(l*l+u*u),S.push(d),b+=d;for(h=k=0,E=f-1;E>=0?E>=k:k>=E;h=E>=0?++k:--k)m=n[h],x=S[h]/b,w+=x*m[0],P+=x*m[1];i+=w*c,a+=P*c}return y._centroid=[i,a],y._centroid},t.prototype.isInside=function(t,r){var e,n,o,i,a,s;if(i=this,e=i._bbox,t<e[0]||t>e[2]||r<e[1]||r>e[3])return!1;for(o=a=0,s=i.contours.length-1;s>=0?s>=a:a>=s;o=s>=0?++a:--a)if(n=i.contours[o],Nr(n,[t,r]))return!0;return!1},t}(),br.geom.Path=Q,f=function(t){function r(t,e,n){this.x=t,this.y=e,this.r=n,r.__super__.constructor.call(this,"circle",null,!0)}return ae(r,t),r.prototype.toSVG=function(t){var r;return r=this,t.circle(r.x,r.y,r.r)},r.prototype.centroid=function(){var t;return t=this,[t.x,t.y]},r.prototype.area=function(){var t;return t=this,Math.PI*t.r*m.r},r}(Q),br.geom.Circle=f,Q.fromSVG=function(t){var r,e,n,o,i,a,s,l,u,p,h,c,f,d;if(o=[],c=t.nodeName,p=null,"path"===c){for(l=t.getAttribute("d").trim(),s=Raphael.parsePathString(l),r="Z"===s[s.length-1],h=r?"Z M":"M",n=[],f=0,d=s.length;d>f;f++)e=s[f],0!==e.length&&("M"===e[0]?(n.length>2&&(o.push(n),n=[]),n.push([e[1],e[2]])):"L"===e[0]?n.push([e[1],e[2]]):"Z"===e[0]&&n.length>2&&(o.push(n),n=[]));n.length>=2&&(o.push(n),n=[]),p=new br.geom.Path(c,o,r)}else"circle"===c&&(i=t.getAttribute("cx"),a=t.getAttribute("cy"),u=t.getAttribute("r"),p=new br.geom.Circle(i,a,u));return p},z=function(){function t(t){this.points=t}return t.prototype.clipToBBox=function(r){var e,n,o,i,a,s,l,u,p,h,c,f,d,y,m,v,g,_,b,x;for(c=this,e=(new br.geom.clipping.CohenSutherland).clip,h=[],a=[],i=!1,o=v=0,g=c.points.length-2;g>=0?g>=v:v>=g;o=g>=0?++v:--v){_=c.points[o],s=_[0],l=_[1],b=c.points[o+1],u=b[0],p=b[1];try{x=e(r,s,l,u,p),f=x[0],y=x[1],d=x[2],m=x[3],i=!0,h.push([f,y]),(u!==d||p!==y||o===len(c.points)-2)&&h.push([d,m])}catch(w){n=w,i&&h.length>1&&(a.push(new t(h)),h=[]),i=!1}}return h.length>1&&a.push(new t(h)),a},t.prototype.toSVG=function(){var t,r,e,n,o,i,a,s;for(r=this,t=[],a=r.points,o=0,i=a.length;i>o;o++)s=a[o],e=s[0],n=s[1],t.push(e+","+n);return"M"+t.join("L")},t}(),br.geom.Line=z,Nr=function(t,r){var e,n,o,i,a,s,l,u,p,h,c,f,d,y,m;for(s=Math.PI,n=Math.atan2,p=2*s,a=t.length,e=0,i=y=0,m=a-1;m>=0?m>=y:y>=m;i=m>=0?++y:--y){for(h=t[i][0]-r[0],f=t[i][1]-r[1],c=t[(i+1)%a][0]-r[0],d=t[(i+1)%a][1]-r[1],l=n(f,h),u=n(d,c),o=u-l;o>s;)o-=p;for(;-s>o;)o+=p;e+=o}return Math.abs(e)>=s},Ir=function(t){return kr(t)>0},kr=function(t){var r,e,n,o,i,a,s,l;for(n=0,e=t.length,r=l=0;e>=0?e>l:l>e;r=e>=0?++l:--l)o=t[r][0],a=t[r][1],i=t[(r+1)%e][0],s=t[(r+1)%e][1],n+=o*s-i*a;return n*=.5},Gr=br.proj={},Function.prototype.bind=function(t){var r;return r=this,function(){return r.apply(t,arguments)}},W=function(){function t(t){var r,e,n;r=this,r.lon0=null!=(e=t.lon0)?e:0,r.lat0=null!=(n=t.lat0)?n:0,r.PI=Math.PI,r.HALFPI=.5*r.PI,r.QUARTERPI=.25*r.PI,r.RAD=r.PI/180,r.DEG=180/r.PI,r.lam0=r.rad(this.lon0),r.phi0=r.rad(this.lat0),r.minLat=-90,r.maxLat=90}return t.parameters=[],t.title="Projection",t.prototype.rad=function(t){return t*this.RAD},t.prototype.deg=function(t){return t*this.DEG},t.prototype.plot=function(t,r){var e,n,o,i,a,s,l,u,p,h,c;for(null==r&&(r=!0),i=[],e=!0,u=0,p=t.length;p>u;u++)h=t[u],o=h[0],n=h[1],a=this._visible(o,n),a&&(e=!1),c=this.project(o,n),s=c[0],l=c[1],!a&&r?i.push(this._truncate(s,l)):i.push([s,l]);return e?null:[i]},t.prototype.sea=function(){var t,r,e,n,o,i,a,s,l,u,p,h,c,f;for(i=this,o=i.project.bind(this),n=[],t=i.lon0,i.lon0=0,e=a=-180;180>=a;e=++a)n.push(o(e,i.maxLat));for(r=s=p=i.maxLat,h=i.minLat;h>=p?h>=s:s>=h;r=h>=p?++s:--s)n.push(o(180,r));for(e=l=180;l>=-180;e=--l)n.push(o(e,i.minLat));for(r=u=c=i.minLat,f=i.maxLat;f>=c?f>=u:u>=f;r=f>=c?++u:--u)n.push(o(-180,r));return i.lon0=t,n},t.prototype.world_bbox=function(){var t,r,e,n,o,i;for(r=this.project.bind(this),n=this.sea(),t=new br.BBox,o=0,i=n.length;i>o;o++)e=n[o],t.update(e[0],e[1]);return t},t.prototype.toString=function(){var t;return t=this,"[Proj: "+t.name+"]"},t}(),W.fromXML=function(t){var r,e,n,o,i,a,s;for(n=t.getAttribute("id"),o={},e=a=0,s=t.attributes.length-1;s>=0?s>=a:a>=s;e=s>=0?++a:--a)r=t.attributes[e],"id"!==r.name&&(o[r.name]=r.value);return i=new br.proj[n](o),i.name=n,i},br.Proj=W,v=function(t){function r(t){var e,n,o;null==t&&(t={}),e=this,e.flip=Number(null!=(n=t.flip)?n:0),1===e.flip&&(t.lon0=null!=(o=-t.lon0)?o:0),r.__super__.constructor.call(this,t)}return ae(r,t),r.parameters=["lon0","flip"],r.title="Cylindrical Projection",r.prototype._visible=function(){return!0},r.prototype.clon=function(t){return t-=this.lon0,-180>t?t+=360:t>180&&(t-=360),t},r.prototype.ll=function(t,r){return 1===this.flip?[-t,-r]:[t,r]},r}(W),b=function(t){function r(){return te=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.title="Equirectangular Projection",r.prototype.project=function(t,r){var e;return e=this.ll(t,r),t=e[0],r=e[1],t=this.clon(t),[1e3*t*Math.cos(this.phi0),1e3*-1*r]},r}(v),Gr.lonlat=b,h=function(t){function r(t){var e;r.__super__.constructor.call(this,t),this.lat1=null!=(e=t.lat1)?e:0,this.phi1=this.rad(this.lat1)}return ae(r,t),r.parameters=["lon0","lat1","flip"],r.title="Cylindrical Equal Area",r.prototype.project=function(t,r){var e,n,o,i,a;return a=this.ll(t,r),t=a[0],r=a[1],e=this.rad(this.clon(t)),n=this.rad(-1*r),o=e*Math.cos(this.phi1),i=Math.sin(n)/Math.cos(this.phi1),[1e3*o,1e3*i]},r}(v),Gr.cea=h,w=function(t){function r(t){t.lat1=45,r.__super__.constructor.call(this,t)}return ae(r,t),r.title="Gall-Peters Projection",r.parameters=["lon0","flip"],r}(h),Gr.gallpeters=w,j=function(t){function r(t){t.lat1=37.7,r.__super__.constructor.call(this,t)}return ae(r,t),r.title="Hobo-Dyer Projection",r.parameters=["lon0","flip"],r}(h),Gr.hobodyer=j,l=function(t){function r(t){t.lat1=30,r.__super__.constructor.call(this,t)}return ae(r,t),r.title="Behrmann Projection",r.parameters=["lon0","flip"],r}(h),Gr.behrmann=l,a=function(t){function r(t){t.lat1=50,r.__super__.constructor.call(this,t)}return ae(r,t),r.title="Balthasart Projection",r.parameters=["lon0","flip"],r}(h),Gr.balthasart=a,H=function(t){function r(t){r.__super__.constructor.call(this,t),this.minLat=-85,this.maxLat=85}return ae(r,t),r.title="Mercator Projection",r.prototype.project=function(t,r){var e,n,o,i,a,s,l;return i=this,l=i.ll(t,r),t=l[0],r=l[1],n=Math,e=i.rad(i.clon(t)),o=i.rad(-1*r),a=1e3*e,s=1e3*n.log((1+n.sin(o))/n.cos(o)),[a,s]},r}(v),Gr.mercator=H,$=function(t){function r(){return re=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.title="Pseudo-Cylindrical Projection",r}(v),q=function(t){function r(t){var e;r.__super__.constructor.call(this,t),e=this,e.A0=.8707,e.A1=-.131979,e.A2=-.013791,e.A3=.003971,e.A4=-.001529,e.B0=1.007226,e.B1=.015085,e.B2=-.044475,e.B3=.028874,e.B4=-.005916,e.C0=e.B0,e.C1=3*e.B1,e.C2=7*e.B2,e.C3=9*e.B3,e.C4=11*e.B4,e.EPS=1e-11,e.MAX_Y=.8707*.52*Math.PI}return ae(r,t),r.title="Natural Earth Projection",r.prototype.project=function(t,r){var e,n,o,i,a,s,l,u;return a=this,u=a.ll(t,r),t=u[0],r=u[1],e=a.rad(a.clon(t)),n=a.rad(-1*r),o=n*n,i=o*o,s=180*e*(a.A0+o*(a.A1+o*(a.A2+i*o*(a.A3+o*a.A4))))+500,l=180*n*(a.B0+o*(a.B1+i*(a.B2+a.B3*o+a.B4*i)))+270,[s,l]},r}($),Gr.naturalearth=q,nr=function(t){function r(t){var e;r.__super__.constructor.call(this,t),e=this,e.X=[1,-5.67239e-12,-715511e-10,311028e-11,.9986,-482241e-9,-24897e-9,-133094e-11,.9954,-831031e-9,-44861e-9,-9.86588e-7,.99,-.00135363,-596598e-10,367749e-11,.9822,-.00167442,-44975e-10,-572394e-11,.973,-.00214869,-903565e-10,1.88767e-8,.96,-.00305084,-900732e-10,164869e-11,.9427,-.00382792,-653428e-10,-261493e-11,.9216,-.00467747,-104566e-9,48122e-10,.8962,-.00536222,-323834e-10,-543445e-11,.8679,-.00609364,-1139e-7,332521e-11,.835,-.00698325,-640219e-10,9.34582e-7,.7986,-.00755337,-500038e-10,9.35532e-7,.7597,-.00798325,-359716e-10,-227604e-11,.7186,-.00851366,-70112e-9,-863072e-11,.6732,-.00986209,-199572e-9,191978e-10,.6213,-.010418,883948e-10,624031e-11,.5722,-.00906601,181999e-9,624033e-11,.5322,0,0,0],e.Y=[0,.0124,3.72529e-10,1.15484e-9,.062,.0124001,1.76951e-8,-5.92321e-9,.124,.0123998,-7.09668e-8,2.25753e-8,.186,.0124008,2.66917e-7,-8.44523e-8,.248,.0123971,-9.99682e-7,3.15569e-7,.31,.0124108,373349e-11,-11779e-10,.372,.0123598,-13935e-9,439588e-11,.434,.0125501,520034e-10,-100051e-10,.4968,.0123198,-980735e-10,922397e-11,.5571,.0120308,402857e-10,-52901e-10,.6176,.0120369,-390662e-10,7.36117e-7,.6769,.0117015,-280246e-10,-8.54283e-7,.7346,.0113572,-408389e-10,-5.18524e-7,.7903,.0109099,-486169e-10,-10718e-10,.8435,.0103433,-646934e-10,5.36384e-9,.8936,.00969679,-646129e-10,-854894e-11,.9394,.00840949,-192847e-9,-421023e-11,.9761,.00616525,-256001e-9,-421021e-11,1,0,0,0],e.NODES=18,e.FXC=.8487,e.FYC=1.3523,e.C1=11.459155902616464,e.RC1=.08726646259971647,e.ONEEPS=1.000001,e.EPS=1e-8}return ae(r,t),r.title="Robinson Projection",r.prototype._poly=function(t,r,e){return t[r]+e*(t[r+1]+e*(t[r+2]+e*t[r+3]))},r.prototype.project=function(t,r){var e,n,o,i,a,s,l,u;return a=this,u=a.ll(t,r),t=u[0],r=u[1],t=a.clon(t),n=a.rad(t),o=a.rad(-1*r),i=Math.abs(o),e=Math.floor(i*a.C1),e>=a.NODES&&(e=a.NODES-1),i=a.deg(i-a.RC1*e),e*=4,s=1e3*a._poly(a.X,e,i)*a.FXC*n,l=1e3*a._poly(a.Y,e,i)*a.FYC,0>o&&(l=-l),[s,l]},r}($),Gr.robinson=nr,g=function(t){function r(t){var e;r.__super__.constructor.call(this,t),e=this,e.C_x=.4222382003157712,e.C_y=1.3265004281770023,e.RC_y=.7538633073600218,e.C_p=3.5707963267948966,e.RC_p=.2800495767557787,e.EPS=1e-7,e.NITER=6}return ae(r,t),r.title="Eckert IV Projection",r.prototype.project=function(t,r){var e,n,o,i,a,s,l,u,p,h,c;for(s=this,c=s.ll(t,r),t=c[0],r=c[1],i=s.rad(s.clon(t)),a=s.rad(-1*r),l=s.C_p*Math.sin(a),e=a*a,a*=.895168+e*(.0218849+.00826809*e),o=s.NITER;o>0&&(n=Math.cos(a),u=Math.sin(a),e=(a+u*(n+2)-l)/(1+n*(n+2)-u*u),a-=e,!(Math.abs(e)<s.EPS));)o-=1;return 0===o?(p=s.C_x*i,h=0>a?-s.C_y:s.C_y):(p=s.C_x*i*(1+Math.cos(a)),h=s.C_y*Math.sin(a)),[p,h]},r}($),Gr.eckert4=g,ar=function(t){function r(){return ee=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.title="Sinusoidal Projection",r.prototype.project=function(t,r){var e,n,o,i,a,s;return n=this,s=n.ll(t,r),t=s[0],r=s[1],e=n.rad(n.clon(t)),o=n.rad(-1*r),i=1032*e*Math.cos(o),a=1032*o,[i,a]},r}($),Gr.sinusoidal=ar,X=function(t){function r(t,e,n,o,i){var a,s,l,u;null==e&&(e=1.5707963267948966),null==n&&(n=null),null==o&&(o=null),null==i&&(i=null),r.__super__.constructor.call(this,t),a=this,a.MAX_ITER=10,a.TOLERANCE=1e-7,null!=e?(s=e+e,u=Math.sin(e),l=Math.sqrt(2*Math.PI*u/(s+Math.sin(s))),a.cx=2*l/Math.PI,a.cy=l/u,a.cp=s+Math.sin(s)):null!=n&&null!=o&&"undefined"!=typeof cz&&null!==cz?(a.cx=n,a.cy=o,a.cp=i):Sr("kartograph.proj.Mollweide: either p or cx,cy,cp must be defined")}return ae(r,t),r.title="Mollweide Projection",r.prototype.project=function(t,r){var e,n,o,i,a,s,l,u,p,h,c;for(s=this,c=s.ll(t,r),t=c[0],r=c[1],a=Math,e=a.abs,i=s.rad(s.clon(t)),l=s.rad(r),o=s.cp*a.sin(l),n=s.MAX_ITER;0!==n&&(u=(l+a.sin(l)-o)/(1+a.cos(l)),l-=u,!(e(u)<s.TOLERANCE));)n-=1;return 0===n?l=l>=0?s.HALFPI:-s.HALFPI:l*=.5,p=1e3*s.cx*i*a.cos(l),h=1e3*s.cy*a.sin(l),[p,-1*h]},r}($),Gr.mollweide=X,dr=function(t){function r(t){r.__super__.constructor.call(this,t,1.0471975511965976)}return ae(r,t),r.title="Wagner IV Projection",r}(X),Gr.wagner4=dr,yr=function(t){function r(t){r.__super__.constructor.call(this,t,null,.90977,1.65014,3.00896)}return ae(r,t),r.title="Wagner V Projection",r}(X),Gr.wagner5=yr,F=function(t){function r(){return ne=r.__super__.constructor.apply(this,arguments)}var e,n;return ae(r,t),n=-89,e=89,r.parameters=["lon0","lat0","flip"],r.title="Loximuthal Projection (equidistant)",r.prototype.project=function(t,r){var e,n,o,i,a,s,l;return o=this,l=o.ll(t,r),t=l[0],r=l[1],n=Math,e=o.rad(o.clon(t)),i=o.rad(r),a=i===o.phi0?e*n.cos(o.phi0):e*(i-o.phi0)/(n.log(n.tan(o.QUARTERPI+.5*i))-n.log(n.tan(o.QUARTERPI+.5*o.phi0))),a*=1e3,s=1e3*(i-o.phi0),[a,-1*s]},r}($),Gr.loximuthal=F,c=function(t){function r(){return oe=r.__super__.constructor.apply(this,arguments)}var e,n,o,i,a;return ae(r,t),r.title="Canters Modified Sinusoidal I",r.parameters=["lon0"],e=1.1966,n=-.129,o=3*n,i=-.0076,a=5*i,r.prototype.project=function(t,r){var s,l,u,p,h,c;return s=this,c=s.ll(t,r),t=c[0],r=c[1],t=s.rad(s.clon(t)),r=s.rad(r),p=r*r,h=p*p,l=1e3*t*Math.cos(r)/(e+o*p+a*h),u=1e3*r*(e+n*p+i*h),[l,-1*u]},r}($),Gr.canters1=c,C=function(t){function r(t){r.__super__.constructor.call(this,t)}var e,n,o,i,a,s,l,u,p,h,c,f,d;return ae(r,t),r.title="Hatano Projection",l=20,o=1e-7,u=1.000001,e=2.67595,n=2.43763,p=.3736990601468637,h=.4102345310814193,a=1.75859,s=1.93052,f=.5686373742600607,d=.5179951515653813,i=.85,c=1.1764705882352942,r.prototype.project=function(t,r){var u,p,h,c,f,d,y,m,v,g;
for(c=this,g=c.ll(t,r),t=g[0],r=g[1],h=c.rad(c.clon(t)),f=c.rad(r),u=Math.sin(f)*(0>f?n:e),p=v=l;v>=1&&(d=(f+Math.sin(f)-u)/(1+Math.cos(f)),f-=d,!(Math.abs(d)<o));p=v+=-1);return y=1e3*i*h*Math.cos(f*=.5),m=1e3*Math.sin(f)*(0>f?s:a),[y,-1*m]},r}($),Gr.hatano=C,P=function(t){function r(t){var e;r.__super__.constructor.call(this,t),e=this,e.lat1=41.737,e.p1=new X,e.p0=new ar}return ae(r,t),r.title="Goode Homolosine Projection",r.parameters=["lon0"],r.prototype.project=function(t,r){var e,n;return e=this,n=e.ll(t,r),t=n[0],r=n[1],t=e.clon(t),Math.abs(r)>e.lat1?e.p1.project(t,r):e.p0.project(t,r)},r}($),Gr.goodehomolosine=P,D=function(t){function r(t){r.__super__.constructor.call(this,t),this.r=100*this.HALFPI}var e;return ae(r,t),r.title="Nicolosi Globular Projection",r.parameters=["lon0"],e=1e-10,r.prototype._visible=function(t){var r;return r=this,t=r.clon(t),t>-90&&90>t},r.prototype.project=function(t,r){var n,o,i,a,s,l,u,p,h,c,f,d,y;return s=this,y=s.ll(t,r),t=y[0],r=y[1],i=s.rad(s.clon(t)),u=s.rad(r),Math.abs(i)<e?(f=0,d=u):Math.abs(u)<e?(f=i,d=0):Math.abs(Math.abs(i)-s.HALFPI)<e?(f=i*Math.cos(u),d=s.HALFPI*Math.sin(u)):Math.abs(Math.abs(u)-s.HALFPI)<e?(f=0,d=u):(c=s.HALFPI/i-i/s.HALFPI,n=u/s.HALFPI,h=Math.sin(u),o=(1-n*n)/(h-n),p=c/o,p*=p,a=(c*h/o-.5*c)/(1+p),l=(h/p+.5*o)/(1+1/p),f=Math.cos(u),f=Math.sqrt(a*a+f*f/(1+p)),f=s.HALFPI*(a+(0>i?-f:f)),d=Math.sqrt(l*l-(h*h/p+o*h-1)/(1+1/p)),d=s.HALFPI*(l+(0>u?d:-d))),[100*f,-100*d]},r.prototype.sea=function(){var t,r,e,n,o;for(r=[],n=this.r,t=Math,e=o=0;360>=o;e=++o)r.push([t.cos(this.rad(e))*n,t.sin(this.rad(e))*n]);return r},r.prototype.world_bbox=function(){var t;return t=this.r,new br.BBox(-t,-t,2*t,2*t)},r}($),Gr.nicolosi=D,o=function(t){function r(t,e){var n;null==e&&(e=1e3),r.__super__.constructor.call(this,t),n=this,n.r=e,n.elevation0=n.to_elevation(n.lat0),n.azimuth0=n.to_azimuth(n.lon0)}return ae(r,t),r.parameters=["lon0","lat0"],r.title="Azimuthal Projection",r.prototype.to_elevation=function(t){var r;return r=this,(t+90)/180*r.PI-r.HALFPI},r.prototype.to_azimuth=function(t){var r;return r=this,2*(t+180)/360*r.PI-r.PI},r.prototype._visible=function(t,r){var e,n,o,i,a;return a=this,i=Math,o=a.to_elevation(r),e=a.to_azimuth(t),n=i.sin(o)*i.sin(a.elevation0)+i.cos(a.elevation0)*i.cos(o)*i.cos(e-a.azimuth0),n>=0},r.prototype._truncate=function(t,r){var e,n,o,i,a;return e=Math,n=this.r,o=e.atan2(r-n,t-n),i=n+n*e.cos(o),a=n+n*e.sin(o),[i,a]},r.prototype.sea=function(){var t,r,e,n,o;for(r=[],n=this.r,t=Math,e=o=0;360>=o;e=++o)r.push([n+t.cos(this.rad(e))*n,n+t.sin(this.rad(e))*n]);return r},r.prototype.world_bbox=function(){var t;return t=this.r,new br.BBox(0,0,2*t,2*t)},r}(W),U=function(t){function r(){return Vr=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.title="Orthographic Projection",r.prototype.project=function(t,r){var e,n,o,i,a,s,l,u;return i=this,o=Math,n=i.to_elevation(r),e=i.to_azimuth(t),s=i.r*o.cos(n)*o.sin(e-i.azimuth0),u=-i.r*(o.cos(i.elevation0)*o.sin(n)-o.sin(i.elevation0)*o.cos(n)*o.cos(e-i.azimuth0)),a=i.r+s,l=i.r+u,[a,l]},r}(o),Gr.ortho=U,k=function(t){function r(t){r.__super__.constructor.call(this,t),this.scale=.5*Math.sqrt(2)}return ae(r,t),r.title="Lambert Azimuthal Equal-Area Projection",r.prototype.project=function(t,r){var e,n,o,i,a,s,l,u,p,h;return a=this.rad(r),o=this.rad(t),i=Math,s=i.sin,e=i.cos,n=i.pow(2/(1+s(this.phi0)*s(a)+e(this.phi0)*e(a)*e(o-this.lam0)),.5),n*=this.scale,u=this.r*n*e(a)*s(o-this.lam0),h=-this.r*n*(e(this.phi0)*s(a)-s(this.phi0)*e(a)*e(o-this.lam0)),l=this.r+u,p=this.r+h,[l,p]},r}(o),Gr.laea=k,ur=function(t){function r(){return Or=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.title="Stereographic Projection",r.prototype.project=function(t,r){var e,n,o,i,a,s,l,u,p,h,c;return s=this.rad(r),i=this.rad(t),a=Math,l=a.sin,e=a.cos,o=.5,n=2*o/(1+l(this.phi0)*l(s)+e(this.phi0)*e(s)*e(i-this.lam0)),p=this.r*n*e(s)*l(i-this.lam0),c=-this.r*n*(e(this.phi0)*l(s)-l(this.phi0)*e(s)*e(i-this.lam0)),u=this.r+p,h=this.r+c,[u,h]},r}(o),Gr.stereo=ur,or=function(t){function r(t){var e,n,o,i,a,s,l,u,p,h;for(r.__super__.constructor.call(this,{lon0:0,lat0:0}),this.dist=null!=(u=t.dist)?u:3,this.up=this.rad(null!=(p=t.up)?p:0),this.tilt=this.rad(null!=(h=t.tilt)?h:0),this.scale=1,i=Number.MAX_VALUE,o=-1*Number.MAX_VALUE,e=s=0;179>=s;e=++s)for(n=l=0;360>=l;n=++l)a=this.project(n-180,e-90),i=Math.min(a[0],i),o=Math.max(a[0],o);this.scale=2*this.r/(o-i),r.__super__.constructor.call(this,t)}return ae(r,t),r.parameters=["lon0","lat0","tilt","dist","up"],r.title="Satellite Projection",r.prototype.project=function(t,r,e){var n,o,i,a,s,l,u,p,h,c,f,d,y,m,v,g,_,b,x,w,M;return null==e&&(e=0),c=this.rad(r),p=this.rad(t),h=Math,y=h.sin,i=h.cos,f=this.r,d=f*(e+6371)/3671,a=y(this.phi0)*y(c)+i(this.phi0)*i(c)*i(p-this.lam0),u=(this.dist-1)/(this.dist-a),u=(this.dist-1)/(this.dist-a),u*=this.scale,_=d*u*i(c)*y(p-this.lam0),w=-d*u*(i(this.phi0)*y(c)-y(this.phi0)*i(c)*i(p-this.lam0)),l=i(this.up),v=y(this.up),s=i(this.tilt),m=y(this.tilt),o=d*(this.dist-1),n=(w*l+_*v)*y(this.tilt)/o+s,b=(_*l-w*v)*i(this.tilt)/n,M=(w*l+_*v)/n,g=f+b,x=f+M,[g,x]},r.prototype._visible=function(t,r){var e,n,o,i;return o=this.to_elevation(r),e=this.to_azimuth(t),i=Math,n=i.sin(o)*i.sin(this.elevation0)+i.cos(this.elevation0)*i.cos(o)*i.cos(e-this.azimuth0),n>=1/this.dist},r.prototype.sea=function(){var t,r,e,n,o;for(r=[],n=this.r,t=Math,e=o=0;360>=o;e=++o)r.push([n+t.cos(this.rad(e))*n,n+t.sin(this.rad(e))*n]);return r},r}(o),Gr.satellite=or,_=function(t){function r(){return Hr=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.title="Equidistant Azimuthal Projection",r.prototype.project=function(t,r){var e,n,o,i,a,s,l,u,p,h,c,f,d;return l=this,u=l.rad(r),a=l.rad(t),s=Math,p=s.sin,n=s.cos,o=p(this.phi0)*p(u)+n(this.phi0)*n(u)*n(a-this.lam0),e=s.acos(o),i=.325*e/p(e),c=this.r*i*n(u)*p(a-this.lam0),d=-this.r*i*(n(this.phi0)*p(u)-p(this.phi0)*n(u)*n(a-this.lam0)),h=this.r+c,f=this.r+d,[h,f]},r.prototype._visible=function(){return!0},r}(o),Gr.equi=_,n=function(t){function r(t){var e;e=this,t.lat0=0,r.__super__.constructor.call(this,t),e.lam0=0}var e;return ae(r,t),r.title="Aitoff Projection",r.parameters=["lon0"],e=.6366197723675814,r.prototype.project=function(t,r){var n,o,i,a,s,l,u,p;return a=this,p=a.ll(t,r),t=p[0],r=p[1],t=a.clon(t),i=a.rad(t),s=a.rad(r),n=.5*i,o=Math.acos(Math.cos(s)*Math.cos(n)),0!==o?(u=1/Math.sin(o),l=2*o*Math.cos(s)*Math.sin(n)*u,u*=o*Math.sin(s)):l=u=0,a.winkel&&(l=.5*(l+i*e),u=.5*(u+s)),[1e3*l,-1e3*u]},r.prototype._visible=function(){return!0},r}($),Gr.aitoff=n,mr=function(t){function r(t){r.__super__.constructor.call(this,t),this.winkel=!0}return ae(r,t),r.title="Winkel Tripel Projection",r}(n),Gr.winkel3=mr,y=function(t){function r(t){var e,n,o;e=this,r.__super__.constructor.call(this,t),e.lat1=null!=(n=t.lat1)?n:30,e.phi1=e.rad(e.lat1),e.lat2=null!=(o=t.lat2)?o:50,e.phi2=e.rad(e.lat2)}return ae(r,t),r.title="Conic Projection",r.parameters=["lon0","lat0","lat1","lat2"],r.prototype._visible=function(t,r){var e;return e=this,r>e.minLat&&r<e.maxLat},r.prototype._truncate=function(t,r){return[t,r]},r.prototype.clon=function(t){return t-=this.lon0,-180>t?t+=360:t>180&&(t-=360),t},r}(W),I=function(t){function r(t){var e,n,o,i,a,s,l,u,p,h,c,f,d;p=this,r.__super__.constructor.call(this,t),a=Math,d=[a.sin,a.cos,a.abs,a.log,a.tan,a.pow],h=d[0],o=d[1],e=d[2],xr=d[3],f=d[4],l=d[5],p.n=s=c=h(p.phi1),i=o(p.phi1),u=e(p.phi1-p.phi2)>=1e-10,u&&(s=xr(i/o(p.phi2))/xr(f(p.QUARTERPI+.5*p.phi2)/f(p.QUARTERPI+.5*p.phi1))),p.c=n=i*l(f(p.QUARTERPI+.5*p.phi1),s)/s,p.rho0=e(e(p.phi0)-p.HALFPI)<1e-10?0:n*l(f(p.QUARTERPI+.5*p.phi0),-s),p.minLat=-60,p.maxLat=85}return ae(r,t),r.title="Lambert Conformal Conic Projection",r.prototype.project=function(t,r){var e,n,o,i,a,s,l,u,p,h,c,f,d,y,m;return h=this,l=h.rad(r),o=h.rad(h.clon(t)),a=Math,m=[a.sin,a.cos,a.abs,a.log,a.tan,a.pow],c=m[0],n=m[1],e=m[2],xr=m[3],f=m[4],u=m[5],s=h.n,p=e(e(l)-h.HALFPI)<1e-10?0:h.c*u(f(h.QUARTERPI+.5*l),-s),i=o*s,d=1e3*p*c(i),y=1e3*(h.rho0-p*n(i)),[d,-1*y]},r}(y),Gr.lcc=I,Z=function(t){function r(){return Xr=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r}(y),fr=function(){function t(t,r,e,n,o,i){var a;a=this,a.bbox=t,a.width=r,a.padding=null!=n?n:0,a.halign=null!=o?o:"center",a.valign=null!=i?i:"center",a.height=e,a.scale=Math.min((r-2*n)/t.width,(e-2*n)/t.height)}return t.prototype.project=function(t,r){var e,n,o,i,a,s,l;return null==r&&(r=t[1],t=t[0]),o=this,i=o.scale,e=o.bbox,n=o.height,a=o.width,s="center"===o.halign?.5*(a-e.width*i):"left"===o.halign?o.padding*i:a-(e.width-o.padding)*i,l="center"===o.valign?.5*(n-e.height*i):"top"===o.valign?o.padding*i:0,t=(t-e.left)*i+s,r=(r-e.top)*i+l,[t,r]},t.prototype.projectPath=function(t){var r,e,n,o,i,a,s,l,u,p,h,c,f,d,y,m,v;if(o=this,"path"===t.type){for(n=[],r=[99999,99999,-99999,-99999],d=t.contours,p=0,c=d.length;c>p;p++){for(a=d[p],e=[],h=0,f=a.length;f>h;h++)y=a[h],l=y[0],u=y[1],m=o.project(l,u),l=m[0],u=m[1],e.push([l,u]),r[0]=Math.min(r[0],l),r[1]=Math.min(r[1],u),r[2]=Math.max(r[2],l),r[3]=Math.max(r[3],u);n.push(e)}return i=new br.geom.Path(t.type,n,t.closed),i._bbox=r,i}return"circle"===t.type?(v=o.project(t.x,t.y),l=v[0],u=v[1],s=t.r*o.scale,new br.geom.Circle(l,u,s)):void 0},t.prototype.asBBox=function(){var t;return t=this,new br.BBox(0,0,t.width,t.height)},t}(),fr.fromXML=function(t){var r,e,n,o,a;return a=Number(t.getAttribute("w")),n=Number(t.getAttribute("h")),o=Number(t.getAttribute("padding")),e=t.getElementsByTagName("bbox")[0],r=i.fromXML(e),new br.View(r,a,n,o)},br.View=fr,S.prototype.dotgrid=function(t){var r,e,n,o,i,a,s,l,u,p,h,c,f,d,y,m,v,g,_,b,x,w,M,P,C,j,A,B,L,S,k,I,N,G,z,E,T,R,F,V,O,H,X,q,D,U,Q,Y,W;if(v=this,m=null!=(T=t.layer)?T:v.layerIds[v.layerIds.length-1],!v.layers.hasOwnProperty(m))return Sr('dotgrid error: layer "'+m+'" not found'),void 0;if(y=v.layers[m],e=t.data,n=t.value,o=t.key,_={},null!=o&&"array"===zr(e))for(A=0,k=e.length;k>A;A++)w=e[A],d=w[o],_[String(d)]=w;else for(d in e)w=e[d],_[String(d)]=w;if(l=null!=(R=t.style)?R:{fill:"black",stroke:"none"},P=t.size,f=null!=(F=t.gridsize)?F:15,s=null!=(V=y.dotgrid)?V:y.dotgrid={gridsize:f,grid:[]},s.gridsize!==f)for(O=s.grid,B=0,I=O.length;I>B;B++)c=O[B],null!=c.shape&&(c.shape.remove(),c.shape=null);if(f>0){if(0===s.grid.length)for(C=L=0,H=v.viewport.width;f>0?H>=L:L>=H;C=L+=f)for(j=S=0,X=v.viewport.height;f>0?X>=S:S>=X;j=S+=f){c={x:C+.2*(Math.random()-.5)*f,y:j+.2*(Math.random()-.5)*f,pathid:!1},h=!1,q=y.pathsById;for(d in q){for(b=q[d],z=0,N=b.length;N>z;z++)if(g=b[z],g.vpath.isInside(c.x,c.y)){h=!0,x=null!=(D=_[d])?D:null,M=P(x),c.pathid=d,c.shape=y.paper.circle(c.x,c.y,1);break}if(h)break}s.grid.push(c)}for(U=s.grid,E=0,G=U.length;G>E;E++)c=U[E],c.pathid&&(x=null!=(Q=_[c.pathid])?Q:null,M=P(x),p=null!=(Y=t.duration)?Y:0,i=null!=(W=t.delay)?W:0,a="function"===zr(i)?i(x):i,p>0&&Raphael.svg?(r=Raphael.animation({r:.5*M},p),c.shape.animate(r.delay(a))):c.shape.attr({r:.5*M}),u="function"===zr(l)?l(x):l,c.shape.attr(u))}},gr=null!=(qr=br.filter)?qr:br.filter={},gr.__knownFilter={},gr.__patternFills=0,V.prototype.SVG=function(t,r){var e,n;if("string"==typeof t&&(t=window.document.createElementNS("http://www.w3.org/2000/svg",t)),r)for(e in r)n=r[e],t.setAttribute(e,n);return t},S.prototype.addFilter=function(t,r,e){var n,o,i;if(null==e&&(e={}),i=this,n=window.document,null==br.filter[r])throw"unknown filter type "+r;return o=new br.filter[r](e).getFilter(t),i.paper.defs.appendChild(o)},V.prototype.applyFilter=function(t){var r;return r=this,e("."+r.id,r.paper.canvas).attr({filter:"url(#"+t+")"})},V.prototype.applyTexture=function(t,r,e){var n,o,i,a,s,l;for(null==r&&(r=!1),null==e&&(e="#000"),o=this,gr.__patternFills+=1,s=o.paths,l=[],i=0,a=s.length;a>i;i++)n=s[i],!r||r(n.data)?l.push(n.svgPath.attr({fill:"url("+t+")"})):l.push(n.svgPath.attr("fill",e));return l},x=function(){function t(t){this.params=null!=t?t:{}}return t.prototype.getFilter=function(t){var r,e;return e=this,r=e.SVG("filter",{id:t}),e.buildFilter(r),r},t.prototype._getFilter=function(){throw"not implemented"},t.prototype.SVG=function(t,r){var e,n;if("string"==typeof t&&(t=window.document.createElementNS("http://www.w3.org/2000/svg",t)),r)for(e in r)n=r[e],t.setAttribute(e,n);return t},t}(),u=function(t){function r(){return Dr=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.prototype.buildFilter=function(t){var r,e,n;return n=this,r=n.SVG,e=r("feGaussianBlur",{stdDeviation:n.params.size||4,result:"blur"}),t.appendChild(e)},r}(x),gr.blur=u,_r=function(t){var r,e,n,o;if(t.trim().match(/^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/))return(4===t.length||7===t.length)&&(t=t.substr(1)),3===t.length&&(t=t.split(""),t=t[0]+t[0]+t[1]+t[1]+t[2]+t[2]),o=parseInt(t,16),n=o>>16,e=255&o>>8,r=255&o,[n,e,r];throw'unknown color format: "'+t+'"'},M=function(t){function r(){return Ur=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.prototype.buildFilter=function(t){var r,e,n,o,i,a,s,l,u,p,h,c,f;i=this,e=null!=(l=i.params.blur)?l:4,s=null!=(u=i.params.strength)?u:1,a=null!=(p=i.params.color)?p:"#D1BEB0","string"===zr(a)&&(a=_r(a)),n=null!=(h=i.params.inner)?h:!1,o=null!=(c=i.params.knockout)?c:!1,r=null!=(f=i.params.alpha)?f:1,n?i.innerGlow(t,e,s,a,r,o):i.outerGlow(t,e,s,a,r,o)},r.prototype.outerGlow=function(t,r,e,n,o,i){var a,s,l,u,p,h,c;return p=this,a=p.SVG,u=a("feColorMatrix",{"in":"SourceGraphic",type:"matrix",values:"0 0 0 0 0   0 0 0 0 0   0 0 0 0 0   0 0 0 1 0",result:"mask"}),t.appendChild(u),e>0&&(c=a("feMorphology",{"in":"mask",radius:e,operator:"dilate",result:"mask"}),t.appendChild(c)),u=a("feColorMatrix",{"in":"mask",type:"matrix",values:"0 0 0 0 "+n[0]/255+" 0 0 0 0 "+n[1]/255+" 0 0 0 0 "+n[2]/255+"  0 0 0 1 0",result:"r0"}),t.appendChild(u),s=a("feGaussianBlur",{"in":"r0",stdDeviation:r,result:"r1"}),t.appendChild(s),l=a("feComposite",{operator:"out","in":"r1",in2:"mask",result:"comp"}),t.appendChild(l),h=a("feMerge"),i||h.appendChild(a("feMergeNode",{"in":"SourceGraphic"})),h.appendChild(a("feMergeNode",{"in":"r1"})),t.appendChild(h)},r.prototype.innerGlow=function(t,r,e,n,o,i){var a,s,l,u,p,h,c;return p=this,a=p.SVG,xr("innerglow"),u=a("feColorMatrix",{"in":"SourceGraphic",type:"matrix",values:"0 0 0 0 0   0 0 0 0 0   0 0 0 0 0   0 0 0 500 0",result:"mask"}),t.appendChild(u),c=a("feMorphology",{"in":"mask",radius:e,operator:"erode",result:"r1"}),t.appendChild(c),s=a("feGaussianBlur",{"in":"r1",stdDeviation:r,result:"r2"}),t.appendChild(s),u=a("feColorMatrix",{type:"matrix","in":"r2",values:"1 0 0 0 "+n[0]/255+" 0 1 0 0 "+n[1]/255+" 0 0 1 0 "+n[2]/255+" 0 0 0 -1 1",result:"r3"}),t.appendChild(u),l=a("feComposite",{operator:"in","in":"r3",in2:"mask",result:"comp"}),t.appendChild(l),h=a("feMerge"),i||h.appendChild(a("feMergeNode",{"in":"SourceGraphic"})),h.appendChild(a("feMergeNode",{"in":"comp"})),t.appendChild(h)},r}(x),gr.glow=M,S.prototype.addGeoPath=function(t,r,e){var n,o,i;return null==r&&(r=[]),null==e&&(e=""),n=this,i=n.getGeoPathStr(t,r),o=n.paper.path(i),""!==e&&o.node.setAttribute("class",e),o},S.prototype.getGeoPathStr=function(t,r){var e,n,o,i,a,s,l;null==r&&(r=[]),o=this,"string"===zr(r)&&(r=r.split("")),0===r.length&&r.push("M"),i="";for(n in t)a=t[n],e=null!=(l=r[n])?l:"L",s=o.lonlat2xy(a),isNaN(s[0])||isNaN(s[1])||(i+=e+s[0]+","+s[1]);return i},S.prototype.addGeoPolygon=function(t,r){var e,n,o;o=this,e=["M"];for(n in t)e.push("L");return e.push("Z"),o.addGeoPath(t,e,r)},ir=function(){function t(t,r,e){var n,o,i,a;null==t&&(t=[0,1]),null==r&&(r=null),null==e&&(e=null),this.rangedScale=se(this.rangedScale,this),this.scale=se(this.scale,this),o=this,a=[];for(n in t)("function"!==zr(e)||e(t[n])!==!1)&&(i=null!=r?"function"===zr(r)?r(t[n]):t[n][r]:t[n],isNaN(i)||a.push(i));a=a.sort(function(t,r){return t-r}),o.values=a,o._range=[0,1],o.rangedScale.range=function(t){return o._range=t,o.rangedScale}}return t.prototype.scale=function(t){return t},t.prototype.rangedScale=function(t){var r,e;return r=this,t=r.scale(t),e=r._range,t*(e[1]-e[0])+e[0]},t}(),E=function(t){function r(){return this.scale=se(this.scale,this),Qr=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.prototype.scale=function(t){var r,e;return r=this,e=r.values,(t-e[0])/(e[e.length-1]-e[0])},r}(ir),T=function(t){function r(){return this.scale=se(this.scale,this),Yr=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.prototype.scale=function(t){var r,e;return r=this,e=r.values,xr=Math.log,(xr(t)-xr(e[0]))/(xr(e[e.length-1])-xr(e[0]))},r}(ir),sr=function(t){function r(){return this.scale=se(this.scale,this),Wr=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.prototype.scale=function(t){var r,e;return r=this,e=r.values,Math.sqrt((t-e[0])/(e[e.length-1]-e[0]))},r}(ir),K=function(t){function r(){return this.scale=se(this.scale,this),$r=r.__super__.constructor.apply(this,arguments)}return ae(r,t),r.prototype.scale=function(t){var r,e,n,o,i,a;n=this,a=n.values,e=a.length-1;for(r in a){if(i=a[Number(r)],o=a[Number(r)+1],t===i)return r/e;if(e>r&&t>i&&o>t)return r/e+(t-i)/(o-i)}},r}(ir),br.scale={},br.scale.identity=function(){return new ir(domain,prop,gr).rangedScale},br.scale.linear=function(t,r,e){return new E(t,r,e).rangedScale},br.scale.log=function(t,r,e){return new T(t,r,e).rangedScale},br.scale.sqrt=function(t,r,e){return new sr(t,r,e).rangedScale},br.scale.quantile=function(t,r,e){return new K(t,r,e).rangedScale},hr=function(){function t(t){r=this,r.location=t.location,r.data=t.data,r.map=t.map,r.layers=t.layers,r.key=t.key,r.x=t.x,r.y=t.y}var r;return r=null,t.prototype.init=function(){return r},t.prototype.overlaps=function(){return!1},t.prototype.update=function(){return r},t.prototype.nodes=function(){return[]},t.prototype.clear=function(){return r},t}(),br.Symbol=hr,cr=function(){function r(t){this._initTooltips=se(this._initTooltips,this),this._noverlap=se(this._noverlap,this),this._kMeans=se(this._kMeans,this);var e,o,i,a,s,l,u,p,h,c,f,d,y,m,v,g,_,b,x,w;for(n=this,c=["data","location","type","map"],p=["filter","tooltip","click","delay","sortBy","clustering","aggregate","clusteringOpts","mouseenter","mouseleave"],f=0,v=c.length;v>f;f++){if(h=c[f],null==t[h])throw"SymbolGroup: missing argument '"+h+"'";n[h]=t[h]}for(d=0,g=p.length;g>d;d++)h=p[d],null!=t[h]&&(n[h]=t[h]);if(e=n.type,null==e)return Sr("could not resolve symbol type",n.type),void 0;for(x=e.props,y=0,_=x.length;_>y;y++)h=x[y],null!=t[h]&&(n[h]=t[h]);for(n.layers={mapcanvas:n.map.paper},w=e.layers,m=0,b=w.length;b>m;m++)s=w[m],u=r._layerid++,a="sl_"+u,"svg"===s.type?l=n.map.createSVGLayer(a):"html"===s.type&&(l=n.map.createHTMLLayer(a)),n.layers[s.id]=l;n.symbols=[];for(i in n.data)o=n.data[i],"function"===zr(n.filter)?n.filter(o,i)&&n.add(o,i):n.add(o,i);n.layout(),n.render(),n.map.addSymbolGroup(n)}var n;return n=null,r.prototype.add=function(t,r){var e,o,i,a,s,l,u,p;for(n=this,e=n.type,o=n._evaluate(n.location,t,r),"array"===zr(o)&&(o=new br.LonLat(o[0],o[1])),a={layers:n.layers,location:o,data:t,key:null!=r?r:n.symbols.length,map:n.map},p=e.props,l=0,u=p.length;u>l;l++)i=p[l],null!=n[i]&&(a[i]=n._evaluate(n[i],t,r));return s=new e(a),n.symbols.push(s),s},r.prototype.layout=function(){var t,r,e,o,i,a,s,l,u,p;for(u=n.symbols,s=0,l=u.length;l>s;s++){if(i=u[s],r=i.location,"string"===zr(r)){if(p=r.split("."),t=p[0],o=p[1],e=n.map.getLayerPath(t,o),null==e){Sr("could not find layer path "+t+"."+o);continue}a=n.map.viewBC.project(e.path.centroid())}else a=n.map.lonlat2xy(r);i.x=a[0],i.y=a[1]}return"k-means"===n.clustering?n._kMeans():"noverlap"===n.clustering&&n._noverlap(),n},r.prototype.render=function(){var t,r,o,i,a,s,l,u,p,h,c;for(n=this,n.sortBy&&(i="asc","string"===zr(n.sortBy)&&(n.sortBy=n.sortBy.split(" ",2),o=n.sortBy[0],i=null!=(p=n.sortBy[1])?p:"asc"),n.symbols=n.symbols.sort(function(t,r){var e,a,s;return"function"===zr(n.sortBy)?(a=n.sortBy(t.data,t),s=n.sortBy(r.data,r)):(a=t[o],s=r[o]),a===s?0:(e="asc"===i?1:-1,a>s?1*e:-1*e)})),h=n.symbols,a=0,l=h.length;l>a;a++)for(r=h[a],r.render(),c=r.nodes(),s=0,u=c.length;u>s;s++)t=c[s],t.symbol=r;return"function"===zr(n.tooltip)&&n._initTooltips(),e.each(["click","mouseenter","mouseleave"],function(o,i){var a,s,l,u;if("function"===zr(n[i])){for(l=n.symbols,u=[],a=0,s=l.length;s>a;a++)r=l[a],u.push(function(){var o,a,s,l;for(s=r.nodes(),l=[],o=0,a=s.length;a>o;o++)t=s[o],l.push(e(t)[i](function(t){var r;for(r=t.target;!r.symbol;)r=e(r).parent().get(0);return t.stopPropagation(),n[i](r.symbol.data,r.symbol,t)}));return l}.call(this));return u}}),n},r.prototype.tooltips=function(t){return n=this,n.tooltips=t,n._initTooltips(),n},r.prototype.remove=function(t){var r,e,o,i,a,s,l,u,p,h;for(n=this,o=[],u=n.symbols,s=0,l=u.length;l>s;s++)if(a=u[s],null==t||t(a.data))try{a.clear()}catch(c){r=c,Sr("error: symbolgroup.remove")}else o.push(a);if(null==t){p=n.layers,h=[];for(e in p)i=p[e],"mapcanvas"!==e?h.push(i.remove()):h.push(void 0);return h}return n.symbols=o},r.prototype._evaluate=function(t,r,e){var n;return n="function"===zr(t)?t(r,e):t},r.prototype._kMeans=function(){var r,e,o,i,a,s,l,u,p,h,c,f,d,y,m,v,g,_,b,x,w,M,P;for(n=this,null==(x=n.osymbols)&&(n.osymbols=n.symbols),r=n.type,null!=n.clusteringOpts&&(h=n.clusteringOpts.size),null==h&&(h=64),e=t().iterations(16).size(h),w=n.osymbols,f=0,v=w.length;v>f;f++)p=w[f],e.add({x:p.x,y:p.y});for(s=e.means(),l=[],d=0,g=s.length;g>d;d++)if(a=s[d],0!==a.size){for(o=[],M=a.indices,y=0,_=M.length;_>y;y++)i=M[y],o.push(n.osymbols[i].data);for(o=n.aggregate(o),c={layers:n.layers,location:!1,data:o,map:n.map},P=r.props,m=0,b=P.length;b>m;m++)u=P[m],null!=n[u]&&(c[u]=n._evaluate(n[u],o));p=new r(c),p.x=a.x,p.y=a.y,l.push(p)}return n.symbols=l},r.prototype._noverlap=function(){var t,r,e,o,i,a,s,l,u,p,h,c,f,d,y,m,v,g,_,b,x,w,M,P,C,j,A,B,L,S,k,I,N,G,z,E,T,R,F,V,O,H,X,q,D,U,Q;if(n=this,null==(H=n.osymbols)&&(n.osymbols=n.symbols),u=3,t=n.type,le.call(t.props,"radius")<0)return Sr('noverlap layout only available for symbols with property "radius"'),void 0;for(j=n.osymbols.slice(),null!=n.clusteringOpts&&(L=n.clusteringOpts.tolerance,f=n.clusteringOpts.maxRatio),null==L&&(L=.05),null==f&&(f=.8),s=N=0,X=u-1;X>=0?X>=N:N>=X;s=X>=0?++N:--N){for(j.sort(function(t,r){return r.radius-t.radius}),p=j.length,d=[],y=G=0,q=p-3;q>=0?q>=G:G>=q;y=q>=0?++G:--G)if(M=j[y]){for(b=M.radius*(1-L),h=M.x-b,g=M.x+b,A=M.y-b,r=M.y+b,l=[],m=z=D=y+1,U=p-2;U>=D?U>=z:z>=U;m=U>=D?++z:--z)P=j[m],P&&(x=P.radius,c=P.x-x,_=P.x+x,B=P.y-x,e=P.y+x,x/M.radius<f&&(c>g||h>_||B>r||A>e||(i=P.x-M.x,a=P.y-M.y,(b+x)*(b+x)>i*i+a*a&&l.push(m))));if(l.length>0){for(o=[M.data],v=M.radius*M.radius,E=0,T=l.length;T>E;E++)s=l[E],o.push(j[s].data),v+=j[s].radius*j[s].radius;for(o=n.aggregate(o),C={layers:n.layers,location:!1,data:o,map:n.map},Q=t.props,V=0,R=Q.length;R>V;V++)y=Q[V],null!=n[y]&&(C[y]=n._evaluate(n[y],o));for(w=new t(C),S=M.radius*M.radius/v,k=M.x*S,I=M.y*S,O=0,F=l.length;F>O;O++)s=l[O],P=j[s],S=P.radius*P.radius/v,k+=P.x*S,I+=P.y*S,j[s]=void 0;w.x=k,w.y=I,j[y]=void 0,d.push(w)}else d.push(M)}j=d}return n.symbols=j},r.prototype._initTooltips=function(){var t,r,o,i,a,s,l,u,p,h,c;for(n=this,i=n.tooltip,h=n.symbols,s=0,u=h.length;u>s;s++)for(o=h[s],t={position:{target:"mouse",viewport:e(window),adjust:{x:7,y:7}},show:{delay:20},content:{},events:{show:function(t,r){return e(".qtip").filter(function(){return this!==r.elements.tooltip.get(0)}).hide()}}},a=i(o.data,o.key),"string"===zr(a)?t.content.text=a:"array"===zr(a)&&(t.content.title=a[0],t.content.text=a[1]),c=o.nodes(),l=0,p=c.length;p>l;l++)r=c[l],e(r).qtip(t)},r.prototype.onResize=function(){var t,r,e,o;for(n=this,n.layout(),o=n.symbols,r=0,e=o.length;e>r;r++)t=o[r],t.update()},r.prototype.update=function(t,r,e){var o,i,a,s,l,u,p,h;for(n=this,null==t&&(t={}),p=n.symbols,a=0,l=p.length;l>a;a++){for(i=p[a],h=n.type.props,s=0,u=h.length;u>s;s++)o=h[s],null!=t[o]?i[o]=n._evaluate(t[o],i.data):null!=n[o]&&(i[o]=n._evaluate(n[o],i.data));i.update(r,e)}return n},r}(),cr._layerid=0,br.SymbolGroup=cr,S.prototype.addSymbols=function(t){return t.map=this,new cr(t)},br.dorlingLayout=function(t,r){var n,o,i,a,s,l,u,p,h,c,f,d,y,m,v;for(null==r&&(r=40),f=[],e.each(t.symbols,function(t,r){return f.push({i:t,x:r.path.attrs.cx,y:r.path.attrs.cy,r:r.path.attrs.r})}),f.sort(function(t,r){return r.r-t.r}),i=function(){var r,e,n;for(e=0,n=f.length;n>e;e++)r=f[e],t.symbols[r.i].path.attr({cx:r.x,cy:r.y})},d=v=1;r>=1?r>=v:v>=r;d=r>=1?++v:--v)for(h in f)for(c in f)if(c>h){if(n=f[h],o=f[c],n.x+n.r<o.x-o.r||n.x-n.r>o.x+o.r)continue;if(n.y+n.r<o.y-o.r||n.y-n.r>o.y+o.r)continue;l=n.x-o.x,u=n.y-o.y,s=l*l+u*u,y=n.r+o.r,m=y*y,m>s&&(a=Math.sqrt(s),p=10/a,n.x+=l*p*(1-n.r/y),n.y+=u*p*(1-n.r/y),o.x-=l*p*(1-o.r/y),o.y-=u*p*(1-o.r/y))}return i()},p=function(t){function r(t){this.nodes=se(this.nodes,this),this.clear=se(this.clear,this),this.update=se(this.update,this),this.render=se(this.render,this),this.overlaps=se(this.overlaps,this);var e,n,o;e=this,r.__super__.constructor.call(this,t),e.radius=null!=(n=t.radius)?n:4,e.style=t.style,e.attrs=t.attrs,e.title=t.title,e["class"]=null!=(o=t["class"])?o:"bubble"}return ae(r,t),r.prototype.overlaps=function(t){var r,e,n,o,i,a,s,l,u,p,h;return n=this,p=[n.x,n.y,n.radius],a=p[0],l=p[1],o=p[2],h=[t.x,t.y,t.radius],s=h[0],u=h[1],i=h[2],a-o>s+i||s-i>a+o||l-o>u+i||u-i>l+o?!1:(r=a-s,e=l-u,r*r+e*e>(o+i)*(o+i)?!1:!0)},r.prototype.render=function(){var t;return t=this,null==t.path&&(t.path=t.layers.mapcanvas.circle(t.x,t.y,t.radius)),t.update(),t.map.applyCSS(t.path),t},r.prototype.update=function(t,r){var n,o,i;return null==t&&(t=!1),null==r&&(r="expo-out"),o=this,i=o.path,n={cx:o.x,cy:o.y,r:o.radius},null!=o.attrs&&(n=e.extend(n,o.attrs)),t?i.animate(n,t,r):i.attr(n),null!=i.node&&(null!=o.style&&i.node.setAttribute("style",o.style),null!=o["class"]&&i.node.setAttribute("class",o["class"])),null!=o.title&&i.attr("title",o.title),o},r.prototype.clear=function(){var t;return t=this,t.path.remove(),t},r.prototype.nodes=function(){var t;return t=this,[t.path.node]},r}(hr),p.props=["radius","style","class","title","attrs"],p.layers=[],br.Bubble=p,B=function(t){function r(t){var e,n,o,i,a,s;e=this,r.__super__.constructor.call(this,t),e.icon=null!=(n=t.icon)?n:"",e.offset=null!=(o=t.offset)?o:[0,0],e.iconsize=null!=(i=t.iconsize)?i:[10,10],e["class"]=null!=(a=t["class"])?a:"",e.title=null!=(s=t.title)?s:""}return ae(r,t),r.prototype.render=function(){var t,r;return r=this,t=r.map.container,r.img=e("<img />"),r.img.attr({src:r.icon,title:r.title,alt:r.title,width:r.iconsize[0],height:r.iconsize[1]}),r.img.addClass(r["class"]),r.img.css({position:"absolute","z-index":1e3,cursor:"pointer"}),r.img[0].symbol=r,t.append(r.img),r.update()},r.prototype.update=function(){var t;return t=this,t.img.css({left:t.x+t.offset[0]+"px",top:t.y+t.offset[1]+"px"})},r.prototype.clear=function(){var t;return t=this,t.img.remove(),t},r.prototype.nodes=function(){var t;return t=this,[t.img]},r}(br.Symbol),B.props=["icon","offset","class","title","iconsize"],B.layers=[],br.Icon=B,pr=function(t){function r(t){var e,n,o,i,a;e=this,r.__super__.constructor.call(this,t),e.text=null!=(n=t.text)?n:"",e.style=null!=(o=t.style)?o:"",e["class"]=null!=(i=t["class"])?i:"",e.offset=null!=(a=t.offset)?a:[0,0]}return ae(r,t),r.prototype.render=function(){var t,r;return r=this,r.lbl=t=r.layers.mapcanvas.text(r.x,r.y,r.text),r.update(),r},r.prototype.update=function(){var t;return t=this,t.lbl.attr({x:t.x+t.offset[0],y:t.y+t.offset[1]}),t.lbl.node.setAttribute("style",t.style),t.lbl.node.setAttribute("class",t["class"])},r.prototype.clear=function(){var t;return t=this,t.lbl.remove(),t},r.prototype.nodes=function(){var t;return t=this,[t.lbl.node]},r}(br.Symbol),pr.props=["text","style","class","offset"],pr.layers=[],br.Label=pr,A=function(t){function r(t){var e,n,o,i;e=this,r.__super__.constructor.call(this,t),e.text=null!=(n=t.text)?n:"",e.css=null!=(o=t.css)?o:"",e["class"]=null!=(i=t["class"])?i:""}return ae(r,t),r.prototype.render=function(){var t,r,n;return n=this,t=e("<div>"+n.text+"</div>"),t.css({width:"80px",position:"absolute",left:"-40px","text-align":"center"}),n.lbl=r=e('<div class="label" />'),r.append(t),n.layers.lbl.append(r),t.css({height:t.height()+"px",top:t.height()*-.4+"px"}),n.update(),n},r.prototype.update=function(){var t;return t=this,t.lbl.css({position:"absolute",left:t.x+"px",top:t.y+"px"}),t.lbl.css(t.css)},r.prototype.clear=function(){var t;return t=this,t.lbl.remove(),t},r.prototype.nodes=function(){var t;return t=this,[t.lbl[0]]},r}(br.Symbol),A.props=["text","css","class"],A.layers=[{id:"lbl",type:"html"}],br.HtmlLabel=A,N=function(t){function r(t){this.nodes=se(this.nodes,this),this.clear=se(this.clear,this),this.update=se(this.update,this),this.render=se(this.render,this);var e,n,o;e=this,r.__super__.constructor.call(this,t),e.labelattrs=null!=(n=t.labelattrs)?n:{},e.buffer=t.buffer,e.center=null!=(o=t.center)?o:!0}return ae(r,t),r.prototype.render=function(t){var e;return e=this,null!=e.title&&""!==String(e.title).trim()&&(e.buffer&&(e.bufferlabel=e.layers.mapcanvas.text(e.x,e.y,e.title)),e.label=e.layers.mapcanvas.text(e.x,e.y,e.title)),r.__super__.render.call(this,t),e},r.prototype.update=function(t,n){var o,i,a,s,l;return null==t&&(t=!1),null==n&&(n="expo-out"),i=this,r.__super__.update.call(this,t,n),null!=i.label&&(a=i.map.viewport,o=e.extend({},i.labelattrs),s=i.x,l=i.y,i.center?l-=0:s>.5*a.width?(o["text-anchor"]="end",s-=i.radius+5):s<.5*a.width&&(o["text-anchor"]="start",s+=i.radius+5),o.x=s,o.y=l,i.buffer&&(i.bufferlabel.attr(o),i.bufferlabel.attr({stroke:"#fff",fill:"#fff","stroke-linejoin":"round","stroke-linecap":"round","stroke-width":6})),i.label.attr(o),i.label.toFront()),i},r.prototype.clear=function(){var t;return t=this,r.__super__.clear.apply(this,arguments)},r.prototype.nodes=function(){var t,e;return t=this,e=r.__super__.nodes.apply(this,arguments),t.label&&e.push(t.label.node),t.bufferlabel&&e.push(t.bufferlabel.node),e},r}(p),N.props=["radius","style","class","title","labelattrs","buffer","center","attrs"],N.layers=[],br.LabeledBubble=N,Y=function(t){function r(t){var n,o,i,a,s,l,u,p,h,c;e=this,r.__super__.constructor.call(this,t),e.radius=null!=(o=t.radius)?o:4,e.styles=null!=(i=t.styles)?i:"",e.colors=null!=(a=t.colors)?a:["#3cc","#c3c","#33c","#cc3"],e.titles=null!=(s=t.titles)?s:["","","","",""],e.values=null!=(l=t.values)?l:[],e.border=null!=(u=t.border)?u:!1,e.borderWidth=null!=(p=t.borderWidth)?p:2,e["class"]=null!=(h=t["class"])?h:"piechart",null==(c=(n=Raphael.fn).pieChart)&&(n.pieChart=vr)}var e;return ae(r,t),e=null,r.prototype.overlaps=function(t){var r,n,o,i,a,s,l,u,p,h;return p=[e.x,e.y,e.radius],a=p[0],l=p[1],o=p[2],h=[t.x,t.y,t.radius],s=h[0],u=h[1],i=h[2],a-o>s+i||s-i>a+o||l-o>u+i||u-i>l+o?!1:(r=a-s,n=l-u,r*r+n*n>(o+i)*(o+i)?!1:!0)},r.prototype.render=function(){var t;return e=this,null!=e.border&&(t=e.layers.mapcanvas.circle(e.x,e.y,e.radius+e.borderWidth).attr({stroke:"none",fill:e.border})),e.chart=e.layers.mapcanvas.pieChart(e.x,e.y,e.radius,e.values,e.titles,e.colors,"none"),e.chart.push(t),e},r.prototype.update=function(){},r.prototype.clear=function(){var t,r,n,o;for(e=this,o=e.chart,r=0,n=o.length;n>r;r++)t=o[r],t.remove();return e},r.prototype.nodes=function(){var t,r,n,o,i;for(o=e.chart,i=[],r=0,n=o.length;n>r;r++)t=o[r],i.push(t.node);return i},r}(hr),Y.props=["radius","values","styles","class","titles","colors","border","borderWidth"],Y.layers=[],br.PieChart=Y,vr=function(t,r,e,n,o,i,a){var s,l,u,p,h,c,f,d,y,m,v;if(isNaN(t)||isNaN(r)||isNaN(e))return[];for(p=this,c=Math.PI/180,l=p.set(),f=function(t,r,e,n,o,i){var a,s,l,u;return a=t+e*Math.cos(-n*c),s=t+e*Math.cos(-o*c),l=r+e*Math.sin(-n*c),u=r+e*Math.sin(-o*c),p.path(["M",t,r,"L",a,l,"A",e,e,0,+(o-n>180),0,s,u,"z"]).attr(i)},s=-270,d=0,h=function(o){var u,p,h,c,y,m,v;v=n[o],u=360*v/d,m=s+.5*u,p=i[o],c=500,h=30,y=f(t,r,e,s,s+u,{fill:p,stroke:a,"stroke-width":1}),y.mouseover(function(){y.stop().animate({transform:"s1.1 1.1 "+t+" "+r},c,"elastic")
}),y.mouseout(function(){y.stop().animate({transform:""},c,"elastic")}),s+=u,l.push(y)},m=0,v=n.length;v>m;m++)y=n[m],d+=y;for(u in n)h(u);return l},drawStackedBars=function(t,r,e,n,o,i,a,s){function l(t,r,e,n,o){return u.rect(t,r,e,n).attr(o)}for(var u=this,p=this.set(),h=0,c=0,f=function(i){var u=o[i],f=n*u/c,d=t-.5*e,y=r+.5*n-h,m=e,v=a[i],g=500,_=l(d,y-f,m,f,{fill:v,stroke:s,"stroke-width":1});h+=f,_.mouseover(function(){_.stop().animate({transform:"s1.1 1.1 "+t+" "+r},g,"elastic")}).mouseout(function(){_.stop().animate({transform:""},g,"elastic")}),p.push(_)},d=0,y=o.length;y>d;d++)c+=o[d];for(d=0;y>d;d++)f(d);return p},lr=function(t){function r(t){var e,n,o,i,a,s,l,u,p,h;e=this,r.__super__.constructor.call(this,t),e.styles=null!=(o=t.styles)?o:"",e.colors=null!=(i=t.colors)?i:[],e.titles=null!=(a=t.titles)?a:["","","","",""],e.values=null!=(s=t.values)?s:[],e.width=null!=(l=t.width)?l:17,e.height=null!=(u=t.height)?u:30,e["class"]=null!=(p=t["class"])?p:"barchart",null==(h=(n=Raphael.fn).drawStackedBarChart)&&(n.drawStackedBarChart=drawStackedBars)}return ae(r,t),r.prototype.overlaps=function(t){var r,e,n,o,i,a,s,l,u,p,h;return n=this,p=[n.x,n.y,n.radius],a=p[0],l=p[1],o=p[2],h=[t.x,t.y,t.radius],s=h[0],u=h[1],i=h[2],a-o>s+i||s-i>a+o||l-o>u+i||u-i>l+o?!1:(r=a-s,e=l-u,r*r+e*e>(o+i)*(o+i)?!1:!0)},r.prototype.render=function(){var t,r,e,n,o,i;return e=this,n=e.width,r=e.height,o=e.x,i=e.y,t=e.layers.mapcanvas.rect(o-.5*n-2,i-.5*r-2,n+4,r+4).attr({stroke:"none",fill:"#fff"}),e.chart=e.layers.mapcanvas.drawStackedBarChart(e.x,e.y,e.width,e.height,e.values,e.titles,e.colors,"none"),e.chart.push(t),e},r.prototype.update=function(){var t;t=this},r.prototype.clear=function(){var t,r,e,n,o;for(t=this,o=t.chart,e=0,n=o.length;n>e;e++)r=o[e],r.remove();return t.chart=[],t},r.prototype.nodes=function(){var t,r,e,n,o,i;for(r=this,o=r.chart,i=[],e=0,n=o.length;n>e;e++)t=o[e],i.push(t.node);return i},r}(br.Symbol),lr.props=["values","styles","class","titles","colors","width","height"],lr.layers=[],br.StackedBarChart=lr}.call(this);