/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class FlushableGZIPOutputStream
extends GZIPOutputStream {
    private byte[] lastByte = new byte[1];
    private boolean hasLastByte = false;
    private boolean flagReenableCompression = false;

    public FlushableGZIPOutputStream(OutputStream os) throws IOException {
        super(os);
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public synchronized void write(byte[] bytes, int offset, int length) throws IOException {
        if (length > 0) {
            this.flushLastByte();
            if (length > 1) {
                this.reenableCompression();
                super.write(bytes, offset, length - 1);
            }
            this.rememberLastByte(bytes[offset + length - 1]);
        }
    }

    public synchronized void write(int i) throws IOException {
        this.flushLastByte();
        this.rememberLastByte((byte)i);
    }

    public synchronized void finish() throws IOException {
        try {
            this.flushLastByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finish();
    }

    public synchronized void close() throws IOException {
        try {
            this.flushLastByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.close();
    }

    private void reenableCompression() {
        if (this.flagReenableCompression && !this.def.finished()) {
            this.flagReenableCompression = false;
            this.def.setLevel(-1);
        }
    }

    private void rememberLastByte(byte b) {
        this.lastByte[0] = b;
        this.hasLastByte = true;
    }

    private void flushLastByte() throws IOException {
        if (this.hasLastByte) {
            this.reenableCompression();
            this.hasLastByte = false;
            super.write(this.lastByte, 0, 1);
        }
    }

    public synchronized void flush() throws IOException {
        if (this.hasLastByte && !this.def.finished()) {
            this.def.setLevel(0);
            this.flushLastByte();
            this.flagReenableCompression = true;
        }
        this.out.flush();
    }

    protected void deflate() throws IOException {
        int len;
        do {
            if ((len = this.def.deflate(this.buf, 0, this.buf.length)) <= 0) continue;
            this.out.write(this.buf, 0, len);
        } while (len != 0);
    }
}

