/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.tablezoning;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtractTextTableFromZones {
    private String user_dir = System.getProperty("user.dir");
    String separator = System.getProperty("file.separator");
    PdfDecoder decodePdf = null;
    public static boolean showMessages = false;
    private String outputDir = "";
    private static int defX1 = -1;
    private static int defX2;
    private static int defY1;
    private static int defY2;
    private boolean isCSV = true;
    private static String testFile;
    private static String xml_testFile;

    public ExtractTextTableFromZones() {
    }

    public ExtractTextTableFromZones(String string) {
        File file;
        String string2 = System.getProperty("xml");
        if (string2 != null) {
            this.isCSV = false;
        }
        if (string == null) {
            string = testFile;
        }
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (!(file = new File(this.outputDir)).exists()) {
            file.mkdirs();
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string);
        } else {
            String[] stringArray = null;
            File file2 = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file2 = new File(string);
                if (!file2.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file2.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (showMessages) {
                    System.out.println(n + "/ " + l + ' ' + stringArray[n]);
                }
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    if (showMessages) {
                        System.out.println(string + stringArray[n]);
                    }
                    this.decodeFile(string + stringArray[n]);
                }
                ++n;
            }
        }
    }

    public ExtractTextTableFromZones(String string, String string2, String string3) {
        File file;
        this.outputDir = string3;
        String string4 = System.getProperty("xml");
        if (string4 != null) {
            this.isCSV = false;
        }
        if (string == null) {
            string = testFile;
        }
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (!(file = new File(this.outputDir)).exists()) {
            file.mkdirs();
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string, string2, this.outputDir);
        } else {
            String[] stringArray = null;
            File file2 = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file2 = new File(string);
                if (!file2.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file2.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (showMessages) {
                    System.out.println(n + "/ " + l + ' ' + stringArray[n]);
                }
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    if (showMessages) {
                        System.out.println(string + stringArray[n]);
                    }
                    this.decodeFile(string + stringArray[n], string2, this.outputDir);
                }
                ++n;
            }
        }
    }

    private void decodeFile(String string) {
        String string2 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n != -1) {
            string2 = string.substring(n + 1, string.length() - 4);
        }
        this.outputDir = this.user_dir + "tables" + this.separator + string2 + this.separator;
        File file = new File(this.outputDir + this.separator);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            this.decodePdf = new PdfDecoder(false);
            this.decodePdf.setExtractionMode(1);
            this.decodePdf.init(true);
            if (showMessages) {
                System.out.println("Opening file :" + string);
            }
            this.decodePdf.openPdfFile(string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
        }
        if (!this.decodePdf.isExtractionAllowed()) {
            System.out.println("Text extraction not allowed");
        } else if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at SimpleViewer for code sample to handle such files");
            System.out.println("Or get support/consultancy");
        } else {
            int n2 = 1;
            int n3 = this.decodePdf.getPageCount();
            try {
                for (int i = n2; i < n3 + 1; ++i) {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    this.decodePdf.decodePage(i);
                    PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decodePdf.getGroupingObject();
                    PdfPageData pdfPageData = this.decodePdf.getPdfPageData();
                    if (defX1 == -1) {
                        n7 = pdfPageData.getMediaBoxX(i);
                        n6 = pdfPageData.getMediaBoxWidth(i) + n7;
                        n5 = pdfPageData.getMediaBoxY(i);
                        n4 = pdfPageData.getMediaBoxHeight(i) + n5;
                    } else {
                        n7 = defX1;
                        n4 = defY1;
                        n6 = defX2;
                        n5 = defY2;
                    }
                    if (showMessages) {
                        System.out.println("Extracting text from rectangle as table(" + n7 + ',' + n4 + ' ' + n6 + ',' + n5 + ')');
                    }
                    String string3 = ".xml";
                    if (this.isCSV) {
                        if (showMessages) {
                            System.out.println("Table will be in CSV format");
                        }
                        string3 = ".csv";
                    } else if (showMessages) {
                        System.out.println("Table will be in xml format");
                    }
                    Map map = null;
                    String string4 = null;
                    try {
                        map = pdfGroupingAlgorithms.extractTextAsTable(n7, n4, n6, n5, i, this.isCSV, false, false, false, 0, false);
                        string4 = (String)map.get("content");
                    }
                    catch (PdfException pdfException) {
                        this.decodePdf.closePdfFile();
                        System.err.println("Exception " + pdfException.getMessage() + " with table extraction");
                    }
                    if (string4 == null) {
                        if (showMessages) {
                            System.out.println("No text found");
                        }
                    } else {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputDir + i + string3), "UTF-8");
                        if (showMessages) {
                            System.out.println("Writing to " + this.outputDir + i + string3);
                        }
                        if (!this.isCSV) {
                            outputStreamWriter.write("<xml><BODY>\n\n");
                        }
                        outputStreamWriter.write(string4);
                        if (!this.isCSV) {
                            outputStreamWriter.write("\n</body></xml>");
                        }
                        outputStreamWriter.close();
                    }
                    this.decodePdf.flushObjectValues(false);
                }
            }
            catch (Exception exception) {
                this.decodePdf.closePdfFile();
                System.err.println("Exception " + exception.getMessage());
                exception.printStackTrace();
            }
            this.decodePdf.flushObjectValues(true);
            if (showMessages) {
                System.out.println("Text read as table");
            }
        }
        this.decodePdf.closePdfFile();
    }

    private void decodeFile(String string, String string2, String string3) {
        int n = 0;
        int[] nArray = null;
        int[] nArray2 = new int[5];
        File file = new File(string2);
        if (file != null && file.exists()) {
            try {
                int n2;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                Document document = documentBuilderFactory.newDocumentBuilder().parse(file);
                NodeList nodeList = document.getElementsByTagName("TablePositions");
                Element element = (Element)nodeList.item(0);
                NodeList nodeList2 = element.getChildNodes();
                ArrayList<Node> arrayList = new ArrayList<Node>();
                int n3 = nodeList2.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    Node node = nodeList2.item(n2);
                    if (!(node instanceof Element)) continue;
                    arrayList.add(node);
                }
                n2 = arrayList.size();
                int n4 = 0;
                Element element2 = (Element)arrayList.get(n4);
                String string4 = element2.getNodeName();
                String string5 = element2.getAttribute("value");
                if (string4.endsWith("Count")) {
                    n = Integer.parseInt(string5);
                    nArray = new int[n];
                }
                nArray = new int[n];
                Vector_Int vector_Int = new Vector_Int(n);
                Vector_Int vector_Int2 = new Vector_Int(n);
                Vector_Int vector_Int3 = new Vector_Int(n);
                Vector_Int vector_Int4 = new Vector_Int(n);
                int n5 = 0;
                for (n4 = 0; n4 < n2; ++n4) {
                    element2 = (Element)arrayList.get(n4);
                    string4 = element2.getNodeName();
                    string5 = element2.getAttribute("value");
                    if (string4.endsWith("page")) {
                        nArray[n5] = Integer.parseInt(string5);
                        ++n5;
                    }
                    if (string4.endsWith("x1")) {
                        vector_Int.addElement(Integer.parseInt(string5));
                    }
                    if (string4.endsWith("y1")) {
                        vector_Int2.addElement(Integer.parseInt(string5));
                    }
                    if (string4.endsWith("x2")) {
                        vector_Int3.addElement(Integer.parseInt(string5));
                    }
                    if (!string4.endsWith("y2")) continue;
                    vector_Int4.addElement(Integer.parseInt(string5));
                }
                int[][] nArray3 = new int[n][5];
                n4 = 0;
                int[] nArray4 = vector_Int.get();
                int[] nArray5 = vector_Int3.get();
                int[] nArray6 = vector_Int2.get();
                int[] nArray7 = vector_Int4.get();
                int n6 = 0;
                if (showMessages) {
                    System.out.println("\nOpening file :" + string);
                }
                while (n4 < n) {
                    nArray3[n4][0] = nArray[n4];
                    nArray3[n4][1] = nArray4[n4];
                    nArray3[n4][2] = nArray5[n4];
                    nArray3[n4][3] = nArray6[n4];
                    nArray3[n4][4] = nArray7[n4];
                    nArray2 = nArray3[n4];
                    ++n4;
                    String string6 = "demo";
                    int n7 = string.lastIndexOf(this.separator);
                    if (n7 != -1) {
                        string6 = string.substring(n7 + 1, string.length() - 4);
                    }
                    this.outputDir = string3.length() == 0 || string3 == null ? this.user_dir + "tables" + this.separator + string6 + this.separator : string3 + this.separator + "tables" + this.separator + string6 + this.separator;
                    File file2 = new File(this.outputDir + this.separator);
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    try {
                        this.decodePdf = new PdfDecoder(false);
                        this.decodePdf.setExtractionMode(1);
                        this.decodePdf.init(true);
                        this.decodePdf.openPdfFile(string);
                    }
                    catch (Exception exception) {
                        System.err.println("Exception " + exception + " in pdf code");
                    }
                    if (!this.decodePdf.isExtractionAllowed()) {
                        System.out.println("Text extraction not allowed");
                        continue;
                    }
                    if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied()) {
                        System.out.println("Encrypted settings");
                        System.out.println("Please look at SimpleViewer for code sample to handle such files");
                        System.out.println("Or get support/consultancy");
                        continue;
                    }
                    try {
                        for (int i = 0; i < 5; ++i) {
                            int n8;
                            int n9;
                            int n10;
                            int n11;
                            int n12 = nArray[n6];
                            ++n6;
                            this.decodePdf.decodePage(n12);
                            PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decodePdf.getGroupingObject();
                            if (defX1 == -1) {
                                n11 = nArray2[++i];
                                n10 = nArray2[++i];
                                n9 = nArray2[++i];
                                n8 = nArray2[++i];
                            } else {
                                n11 = defX1;
                                n9 = defY1;
                                n10 = defX2;
                                n8 = defY2;
                            }
                            if (showMessages) {
                                System.out.println("\nExtracting text from Page " + n12 + " in rectangle(" + n11 + ',' + n9 + ' ' + n10 + ',' + n8 + ')');
                            }
                            String string7 = ".xml";
                            if (this.isCSV) {
                                if (showMessages) {
                                    System.out.println("Table will be in CSV format");
                                }
                                string7 = ".csv";
                            } else if (showMessages) {
                                System.out.println("Table will be in xml format");
                            }
                            Map map = null;
                            String string8 = null;
                            try {
                                map = pdfGroupingAlgorithms.extractTextAsTable(n11, n9, n10, n8, n12, this.isCSV, false, false, false, 0, false);
                                string8 = (String)map.get("content");
                            }
                            catch (PdfException pdfException) {
                                this.decodePdf.closePdfFile();
                                System.err.println("Exception " + pdfException.getMessage() + " with table extraction");
                            }
                            if (string8 == null) {
                                if (showMessages) {
                                    System.out.println("No text found");
                                }
                            } else {
                                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputDir + n6 + string7), "UTF-8");
                                if (showMessages) {
                                    System.out.println("Writing to " + this.outputDir + n6 + string7);
                                }
                                if (!this.isCSV) {
                                    outputStreamWriter.write("<xml><BODY>\n\n");
                                }
                                outputStreamWriter.write(string8);
                                if (!this.isCSV) {
                                    outputStreamWriter.write("\n</body></xml>");
                                }
                                outputStreamWriter.close();
                            }
                            this.decodePdf.flushObjectValues(false);
                        }
                    }
                    catch (Exception exception) {
                        this.decodePdf.closePdfFile();
                        System.err.println("Exception " + exception.getMessage());
                        exception.printStackTrace();
                    }
                    this.decodePdf.flushObjectValues(true);
                    if (!showMessages) continue;
                    System.out.println("Text read as table");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.decodePdf.closePdfFile();
        } else {
            System.out.println("File Not Found.");
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Simple demo to extract text objects as CSV or xml tables");
        String string = testFile;
        String string2 = xml_testFile;
        String string3 = "";
        if (stringArray.length == 1) {
            string = stringArray[0];
            System.out.println("File :" + string);
        } else if (stringArray.length == 3) {
            string = stringArray[0];
            System.out.println("PDF File :" + string);
            string2 = stringArray[1];
            System.out.println("XML File :" + string2);
            string3 = stringArray[2];
            System.out.println("Output Folder :" + string3);
        } else if (stringArray.length == 5) {
            string = stringArray[0];
            System.out.println("File :" + string);
            System.out.println("User coordinates supplied");
            defX1 = Integer.parseInt(stringArray[1]);
            defY1 = Integer.parseInt(stringArray[2]);
            defX2 = Integer.parseInt(stringArray[3]);
            defY2 = Integer.parseInt(stringArray[4]);
        } else {
            System.out.println("Please call with either ");
            System.out.println("FileName");
            System.out.println("or");
            System.out.println("FileName x1 y1 x2 y2");
        }
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " not found");
        }
        if (stringArray.length == 1) {
            new ExtractTextTableFromZones(string);
        }
        if (stringArray.length == 3) {
            File file2 = new File(string2);
            if (!file2.exists()) {
                System.out.println("File " + string + " not found");
            }
            ExtractTextTableFromZones extractTextTableFromZones = new ExtractTextTableFromZones(string, string2, string3);
        }
    }

    static {
        testFile = "C:/Tables/test.pdf";
        xml_testFile = "C:/Tables/test.xml";
    }
}

