/*
 * Decompiled with CFR 0.152.
 */
package railo.loader.classloader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import railo.loader.util.Util;

public final class RailoClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();
    private Hashtable resources = new Hashtable();
    private ClassLoader pcl;

    public RailoClassLoader(File jarFile, ClassLoader parent) throws IOException {
        this(new FileInputStream(jarFile), parent, RailoClassLoader.isSecure(jarFile));
    }

    private static boolean isSecure(File jarFile) {
        return !jarFile.getName().toLowerCase().endsWith(".rc");
    }

    public RailoClassLoader(InputStream jar, ClassLoader parent, boolean secured) throws IOException {
        super(parent);
        if (secured) {
            throw new IOException("secured core files are not supported");
        }
        this.pcl = parent;
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(jar));
        try {
            ZipEntry ze;
            byte[] buffer = new byte[65535];
            while ((ze = zis.getNextEntry()) != null) {
                int bytes_read;
                if (ze.isDirectory()) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((bytes_read = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytes_read);
                }
                String name = ze.getName().replace('\\', '/');
                byte[] barr = baos.toByteArray();
                if (name.endsWith(".class")) {
                    String className = name.substring(0, name.length() - 6);
                    className = className.replace('/', '.');
                    this.classes.put(className, barr);
                }
                this.resources.put(name, barr);
                zis.closeEntry();
                baos.close();
            }
        }
        finally {
            Util.closeEL(zis);
        }
    }

    public Class findClass(String className) throws ClassNotFoundException {
        byte[] classBytes = (byte[])this.classes.get(className);
        if (classBytes == null) {
            throw new ClassNotFoundException("class [" + className + "] not found");
        }
        return this.defineClass(className, classBytes, 0, classBytes.length);
    }

    private Class findClassEL(String className) {
        byte[] classBytes = (byte[])this.classes.get(className);
        if (classBytes == null) {
            return null;
        }
        return this.defineClass(className, classBytes, 0, classBytes.length);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null && (c = this.findClassEL(name)) == null) {
            c = this.pcl.loadClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytes = (byte[])this.resources.get(name = name.replace('\\', '/'));
        if (bytes == null) {
            return super.getResourceAsStream(name);
        }
        return new ByteArrayInputStream(bytes);
    }
}

