/*
 * Decompiled with CFR 0.152.
 */
package railo.cli;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class MainEntryPoint {
    public static void main(String[] args) throws Throwable {
        File[] children;
        File libDir = new File("./").getCanonicalFile();
        System.out.println(libDir);
        if (libDir.getName().equals(".") || libDir.getName().equals("..")) {
            libDir = libDir.getParentFile();
        }
        if ((children = libDir.listFiles(new ExtFilter())).length < 2) {
            libDir = new File(libDir, "lib");
            children = libDir.listFiles(new ExtFilter());
        }
        URL[] urls = new URL[children.length];
        System.out.println("Loading Jars");
        int i = 0;
        while (i < children.length) {
            urls[i] = new URL("jar:file://" + children[i] + "!/");
            System.out.println("- " + urls[i]);
            ++i;
        }
        System.out.println();
        URLClassLoader cl = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
        Class<?> cli = cl.loadClass("railo.cli.CLI");
        Method main = cli.getMethod("main", String[].class);
        main.invoke(null, new Object[]{args});
    }

    public static class ExtFilter
    implements FilenameFilter {
        private String ext = ".jar";

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(this.ext);
        }
    }
}

