/*
 * Decompiled with CFR 0.152.
 */
package railo.cli;

import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import railo.cli.CLIInvoker;
import railo.cli.servlet.ServletConfigImpl;
import railo.cli.servlet.ServletContextImpl;
import railo.loader.engine.CFMLEngine;
import railo.loader.engine.CFMLEngineFactory;

public class CLIInvokerImpl
implements CLIInvoker {
    private ServletConfigImpl servletConfig;
    private CFMLEngine engine;
    private long lastAccess;

    public CLIInvokerImpl(File root, String servletName) throws ServletException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("railo-server-directory", new File(root, "server").getAbsolutePath());
        ServletContextImpl servletContext = new ServletContextImpl(root, attributes, initParameters, 1, 0);
        this.servletConfig = new ServletConfigImpl(servletContext, servletName);
        this.engine = CFMLEngineFactory.getInstance(this.servletConfig);
    }

    @Override
    public void invoke(Map<String, String> config) throws RemoteException {
        try {
            this.engine.cli(config, this.servletConfig);
            this.lastAccess = System.currentTimeMillis();
        }
        catch (Throwable t) {
            throw new RemoteException("fail to call CFML Engine", t);
        }
    }

    public long lastAccess() {
        return this.lastAccess;
    }
}

