/*
 * Decompiled with CFR 0.152.
 */
package railo.cli;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import railo.cli.CLIFactory;
import railo.cli.CLIInvokerImpl;
import railo.loader.util.Util;

public class CLI {
    private static boolean useRMI = false;

    public static void main(String[] args) throws ServletException, IOException, JspException {
        Map<String, String> config = CLI.toMap(args);
        System.setProperty("railo.cli.call", "true");
        String strWebroot = config.get("webroot");
        if (Util.isEmpty(strWebroot, true)) {
            throw new IOException("missing webroot configuration");
        }
        File root = new File(strWebroot);
        root.mkdirs();
        String servletName = config.get("servlet-name");
        if (Util.isEmpty(servletName, true)) {
            servletName = "CFMLServlet";
        }
        if (useRMI) {
            CLIFactory factory = new CLIFactory(root, servletName, config);
            factory.setDaemon(false);
            factory.start();
        } else {
            CLIInvokerImpl invoker = new CLIInvokerImpl(root, servletName);
            invoker.invoke(config);
        }
    }

    private static Map<String, String> toMap(String[] args) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                String raw = args[i].trim();
                if (!Util.isEmpty(raw, true)) {
                    String value;
                    String key;
                    int index;
                    if (raw.startsWith("-")) {
                        raw = raw.substring(1).trim();
                    }
                    if ((index = raw.indexOf(61)) == -1) {
                        key = raw;
                        value = "";
                    } else {
                        key = raw.substring(0, index).trim();
                        value = raw.substring(index + 1).trim();
                    }
                    config.put(key.toLowerCase(), value);
                }
                ++i;
            }
        }
        return config;
    }
}

