/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.storage.HeaderBlockConstants;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.IntegerField;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LongField;

public class HeaderBlockReader
implements HeaderBlockConstants {
    private IntegerField _bat_count;
    private IntegerField _property_start;
    private IntegerField _sbat_start;
    private IntegerField _xbat_start;
    private IntegerField _xbat_count;
    private byte[] _data = new byte[512];

    public HeaderBlockReader(InputStream inputStream) throws IOException {
        int n = IOUtils.readFully(inputStream, this._data);
        if (n != 512) {
            String string = " byte".concat(String.valueOf(String.valueOf(n == 1 ? "" : "s")));
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Unable to read entire header; ").append(n).append(string).append(" read; expected ").append(512).append(" bytes"))));
        }
        LongField longField = new LongField(0, this._data);
        if (longField.get() != -2226271756974174256L) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Invalid header signature; read ").append(longField.get()).append(", expected ").append(-2226271756974174256L))));
        }
        this._bat_count = new IntegerField(44, this._data);
        this._property_start = new IntegerField(48, this._data);
        this._sbat_start = new IntegerField(60, this._data);
        this._xbat_start = new IntegerField(68, this._data);
        this._xbat_count = new IntegerField(72, this._data);
    }

    public int getPropertyStart() {
        return this._property_start.get();
    }

    public int getSBATStart() {
        return this._sbat_start.get();
    }

    public int getBATCount() {
        return this._bat_count.get();
    }

    public int[] getBATArray() {
        int[] nArray = new int[109];
        int n = 76;
        for (int i = 0; i < 109; ++i) {
            nArray[i] = LittleEndian.getInt(this._data, n);
            n += 4;
        }
        return nArray;
    }

    public int getXBATCount() {
        return this._xbat_count.get();
    }

    public int getXBATIndex() {
        return this._xbat_start.get();
    }
}

