/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.util.IntegerField;

public class BATBlock
extends BigBlock {
    private static final int _entries_per_block = 128;
    private static final int _entries_per_xbat_block = 127;
    private static final int _xbat_chain_offset = 508;
    private static final byte _default_value = -1;
    private IntegerField[] _fields;
    private byte[] _data = new byte[512];

    private BATBlock() {
        Arrays.fill(this._data, (byte)-1);
        this._fields = new IntegerField[128];
        int n = 0;
        for (int i = 0; i < 128; ++i) {
            this._fields[i] = new IntegerField(n);
            n += 4;
        }
    }

    public static BATBlock[] createBATBlocks(int[] nArray) {
        int n = BATBlock.calculateStorageRequirements(nArray.length);
        BATBlock[] bATBlockArray = new BATBlock[n];
        int n2 = 0;
        int n3 = nArray.length;
        for (int i = 0; i < nArray.length; i += 128) {
            bATBlockArray[n2++] = new BATBlock(nArray, i, n3 > 128 ? i + 128 : nArray.length);
            n3 -= 128;
        }
        return bATBlockArray;
    }

    public static BATBlock[] createXBATBlocks(int[] nArray, int n) {
        int n2 = BATBlock.calculateXBATStorageRequirements(nArray.length);
        BATBlock[] bATBlockArray = new BATBlock[n2];
        int n3 = 0;
        int n4 = nArray.length;
        if (n2 != 0) {
            for (int i = 0; i < nArray.length; i += 127) {
                bATBlockArray[n3++] = new BATBlock(nArray, i, n4 > 127 ? i + 127 : nArray.length);
                n4 -= 127;
            }
            for (n3 = 0; n3 < bATBlockArray.length - 1; ++n3) {
                bATBlockArray[n3].setXBATChain(n + n3 + 1);
            }
            bATBlockArray[n3].setXBATChain(-2);
        }
        return bATBlockArray;
    }

    public static int calculateStorageRequirements(int n) {
        return (n + 128 - 1) / 128;
    }

    public static int calculateXBATStorageRequirements(int n) {
        return (n + 127 - 1) / 127;
    }

    public static final int entriesPerBlock() {
        return 128;
    }

    public static final int entriesPerXBATBlock() {
        return 127;
    }

    public static final int getXBATChainOffset() {
        return 508;
    }

    private void setXBATChain(int n) {
        this._fields[127].set(n, this._data);
    }

    private BATBlock(int[] nArray, int n, int n2) {
        this();
        for (int i = n; i < n2; ++i) {
            this._fields[i - n].set(nArray[i], this._data);
        }
    }

    void writeData(OutputStream outputStream) throws IOException {
        this.doWriteData(outputStream, this._data);
    }
}

