/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;

public class DebuggerWriter
implements Runnable {
    private Socket socket;
    private List<AbstractDebuggerCommand> cmdQueue = new ArrayList<AbstractDebuggerCommand>();
    private OutputStreamWriter out;
    private volatile boolean done = false;
    private Object lock = new Object();

    public DebuggerWriter(Socket s) throws IOException {
        this.socket = s;
        this.out = new OutputStreamWriter(s.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommand(AbstractDebuggerCommand cmd) {
        List<AbstractDebuggerCommand> list = this.cmdQueue;
        synchronized (list) {
            this.cmdQueue.add(cmd);
        }
    }

    public void done() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            AbstractDebuggerCommand cmd = null;
            Object object = this.cmdQueue;
            synchronized (object) {
                if (this.cmdQueue.size() > 0) {
                    cmd = this.cmdQueue.remove(0);
                }
            }
            try {
                if (cmd != null) {
                    cmd.aboutToSend();
                    this.out.write(cmd.getOutgoing());
                    this.out.write("\n");
                    this.out.flush();
                }
                object = this.lock;
                synchronized (object) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                this.done = true;
            }
            catch (IOException iOException) {
                this.done = true;
            }
            if (this.socket != null && this.socket.isConnected()) continue;
            this.done = true;
        }
    }
}

