/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.python.pydev.core.Tuple;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.model.Location;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;

public class PyRefactorView
extends ViewPart
implements IPropertyListener,
IStructuredContentProvider {
    private TableViewer viewer;
    private Action doubleClickAction;
    private List<String> elements = new ArrayList<String>();

    public void refresh() {
        this.viewer.refresh();
        this.getSite().getPage().bringToTop((IWorkbenchPart)this);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.hookDoubleClickAction();
        AbstractPyRefactoring.addPropertiesListener(this);
        AbstractPyRefactoring.firePropertiesChanged();
        this.refresh();
    }

    private void hookDoubleClickAction() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = PyRefactorView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                File realFile = new File(obj.toString());
                if (realFile.exists()) {
                    ItemPointer p = new ItemPointer(realFile, new Location(-1, -1), null);
                    new PyOpenAction().run(p);
                }
            }
        };
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PyRefactorView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void propertyChanged(Object source, int propId) {
        if (source == null || propId != 1) {
            return;
        }
        if (source instanceof Tuple) {
            Tuple sources = (Tuple)source;
            if (sources.o1 == null || sources.o2 == null) {
                return;
            }
            this.elements.clear();
            this.elements.addAll((Collection)sources.o2);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object parent) {
        return this.elements.toArray();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

