/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.PercentCompleteType;
import net.sf.mpxj.primavera.Record;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.TaskCosts;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimaveraReader {
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private Map<Integer, ProjectCalendar> m_calMap = new HashMap<Integer, ProjectCalendar>();
    private DateFormat m_calendarTimeFormat = new SimpleDateFormat("HH:mm");
    private Map<Integer, String> m_udfMap = new HashMap<Integer, String>();
    private final UserFieldCounters m_udfCounters;
    private Map<FieldType, String> m_resourceFields;
    private Map<FieldType, String> m_wbsFields;
    private Map<FieldType, String> m_taskFields;
    private Map<FieldType, String> m_assignmentFields;
    private final boolean m_matchPrimaveraWBS;
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, TaskType> TASK_TYPE_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;
    private static final Map<String, CurrencySymbolPosition> CURRENCY_SYMBOL_POSITION_MAP;

    public PrimaveraReader(UserFieldCounters userFieldCounters, Map<FieldType, String> map, Map<FieldType, String> map2, Map<FieldType, String> map3, Map<FieldType, String> map4, Map<FieldType, String> map5, boolean bl) {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig projectConfig = this.m_project.getProjectConfig();
        projectConfig.setAutoTaskUniqueID(false);
        projectConfig.setAutoResourceUniqueID(false);
        projectConfig.setAutoCalendarUniqueID(true);
        projectConfig.setAutoAssignmentUniqueID(false);
        projectConfig.setAutoWBS(false);
        this.m_resourceFields = map;
        this.m_wbsFields = map2;
        this.m_taskFields = map3;
        this.m_assignmentFields = map4;
        this.applyAliases(map5);
        this.m_udfCounters = userFieldCounters;
        this.m_udfCounters.reset();
        this.m_matchPrimaveraWBS = bl;
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public void processProjectProperties(List<Row> list) {
        if (!list.isEmpty()) {
            Row row = list.get(0);
            ProjectProperties projectProperties = this.m_project.getProjectProperties();
            projectProperties.setCreationDate(row.getDate("create_date"));
            projectProperties.setFinishDate(row.getDate("plan_end_date"));
            projectProperties.setName(row.getString("proj_short_name"));
            projectProperties.setStartDate(row.getDate("plan_start_date"));
            projectProperties.setProjectTitle(row.getString("proj_short_name"));
            projectProperties.setDefaultTaskType(TASK_TYPE_MAP.get(row.getString("def_duration_type")));
            projectProperties.setStatusDate(row.getDate("last_recalc_date"));
        }
    }

    public void processUserDefinedFields(List<Row> list) {
        for (Row row : list) {
            if (!"TASK".equals(row.getString("table_name"))) continue;
            this.parseTaskUDF(row);
        }
    }

    public void processCalendars(List<Row> list) {
        for (Row row : list) {
            this.processCalendar(row);
        }
    }

    public void processCalendar(Row row) {
        Record record;
        ProjectCalendar projectCalendar = this.m_project.addCalendar();
        Integer n = row.getInteger("clndr_id");
        this.m_calMap.put(n, projectCalendar);
        projectCalendar.setName(row.getString("clndr_name"));
        String string = row.getString("clndr_data");
        if (string != null && !string.isEmpty() && (record = this.getCalendarDataRecord(string)) != null) {
            this.processCalendarDays(projectCalendar, record);
            this.processCalendarExceptions(projectCalendar, record);
        }
        this.m_eventManager.fireCalendarReadEvent(projectCalendar);
    }

    private Record getCalendarDataRecord(String string) {
        Record record;
        try {
            record = new Record(string);
        }
        catch (Exception exception) {
            record = null;
        }
        return record;
    }

    private void processCalendarDays(ProjectCalendar projectCalendar, Record record) {
        Record record2 = record.getChild("DaysOfWeek");
        if (record2 != null) {
            for (Record record3 : record2.getChildren()) {
                this.processCalendarHours(projectCalendar, record3);
            }
        }
    }

    private void processCalendarHours(ProjectCalendar projectCalendar, Record record) {
        Day day = Day.getInstance(Integer.parseInt(record.getField()));
        List<Record> list = record.getChildren();
        if (list.size() == 0) {
            projectCalendar.setWorkingDay(day, false);
        } else {
            projectCalendar.setWorkingDay(day, true);
            ProjectCalendarHours projectCalendarHours = projectCalendar.addCalendarHours(day);
            for (Record record2 : list) {
                if (record2.getValue() == null) continue;
                String[] stringArray = record2.getValue().split("\\|");
                try {
                    Date date = this.m_calendarTimeFormat.parse(stringArray[1]);
                    Date date2 = this.m_calendarTimeFormat.parse(stringArray[3]);
                    projectCalendarHours.addRange(new DateRange(date, date2));
                }
                catch (ParseException parseException) {}
            }
        }
    }

    private void processCalendarExceptions(ProjectCalendar projectCalendar, Record record) {
        Record record2 = record.getChild("Exceptions");
        if (record2 != null) {
            for (Record record3 : record2.getChildren()) {
                int n = Integer.parseInt(record3.getValue().split("\\|")[1]);
                int n2 = n - 25567 - 2;
                Date date = new Date((long)n2 * 24L * 60L * 60L * 1000L);
                projectCalendar.addCalendarException(date, date);
            }
        }
    }

    public void processResources(List<Row> list) {
        for (Row row : list) {
            Resource resource = this.m_project.addResource();
            this.processFields(this.m_resourceFields, row, resource);
            resource.setResourceCalendar(this.getResourceCalendar(row.getInteger("clndr_id")));
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private ProjectCalendar getResourceCalendar(Integer n) {
        ProjectCalendar projectCalendar;
        ProjectCalendar projectCalendar2 = null;
        if (n != null && (projectCalendar = this.m_calMap.get(n)) != null) {
            if (!projectCalendar.isDerived()) {
                ProjectCalendar projectCalendar3 = this.m_project.addCalendar();
                projectCalendar3.setParent(projectCalendar);
                projectCalendar3.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                projectCalendar2 = projectCalendar3;
            } else if (projectCalendar.getResource() == null) {
                projectCalendar2 = projectCalendar;
            } else {
                ProjectCalendar projectCalendar4 = this.m_project.addCalendar();
                projectCalendar4.copy(projectCalendar);
                projectCalendar2 = projectCalendar4;
            }
        }
        return projectCalendar2;
    }

    public void processTasks(List<Row> list, List<Row> list2, List<Row> list3) {
        this.processTasks(list, list2, list3, null);
    }

    /*
     * WARNING - void declaration
     */
    public void processTasks(List<Row> list, List<Row> list2, List<Row> list3, List<Row> list4) {
        Task task;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Map<Integer, TaskCosts> map = this.processCosts(list3);
        for (Row object : list) {
            Task task2 = this.m_project.addTask();
            this.processFields(this.m_wbsFields, object, task2);
            hashSet.add(task2.getUniqueID());
            this.m_eventManager.fireTaskReadEvent(task2);
        }
        FieldType fieldType = this.getActivityIDField(this.m_wbsFields);
        this.m_project.getChildTasks().clear();
        for (Row row : list) {
            Task task3 = this.m_project.getTaskByUniqueID(row.getInteger("wbs_id"));
            task = this.m_project.getTaskByUniqueID(row.getInteger("parent_wbs_id"));
            if (task == null) {
                this.m_project.getChildTasks().add(task3);
                continue;
            }
            this.m_project.getChildTasks().remove(task3);
            task.getChildTasks().add(task3);
            task3.setWBS(task.getWBS() + "." + task3.getWBS());
            if (fieldType == null) continue;
            task3.set(fieldType, task3.getWBS() + " " + task3.getName());
        }
        boolean bl = true;
        this.m_clashMap.clear();
        for (Row row : list2) {
            Object object;
            Object object2;
            Integer n = row.getInteger("wbs_id");
            Task task4 = this.m_project.getTaskByUniqueID(n);
            task = task4 == null ? this.m_project.addTask() : task4.addTask();
            this.processFields(this.m_taskFields, row, task);
            task.setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(row.getString("task_type"))));
            task.setPercentageComplete(this.calculatePercentComplete(row));
            if (this.m_matchPrimaveraWBS && task4 != null) {
                task.setWBS(task4.getWBS());
            }
            if (hashSet.contains(object2 = task.getUniqueID())) {
                void var8_11;
                while (hashSet.contains((int)var8_11)) {
                    ++var8_11;
                }
                object = (int)var8_11;
                this.m_clashMap.put((Integer)object2, (Integer)object);
                object2 = object;
                task.setUniqueID((Integer)object2);
            }
            hashSet.add((Integer)object2);
            object = map.get(row.getInteger("task_id"));
            if (object != null) {
                task.setActualCost(((TaskCosts)object).getActual());
                task.setCost(((TaskCosts)object).getPlanned());
                task.setRemainingCost(((TaskCosts)object).getRemaining());
            }
            Integer n2 = row.getInteger("clndr_id");
            ProjectCalendar projectCalendar = this.m_calMap.get(n2);
            task.setCalendar(projectCalendar);
            Date date = row.getDate("act_start_date") == null ? row.getDate("restart_date") : row.getDate("act_start_date");
            task.setStart(date);
            Date date2 = row.getDate("act_end_date") == null ? row.getDate("reend_date") : row.getDate("act_end_date");
            task.setFinish(date2);
            this.populateField(task, TaskField.WORK, TaskField.BASELINE_WORK, TaskField.ACTUAL_WORK);
            List<Row> list5 = this.getTaskUDF((Integer)object2, list4);
            for (Row row2 : list5) {
                this.addTaskUDFValue(task, row2);
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
        this.updateStructure();
        this.updateDates();
    }

    private FieldType getActivityIDField(Map<FieldType, String> map) {
        FieldType fieldType = null;
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            if (!entry.getValue().equals("task_code")) continue;
            fieldType = entry.getKey();
            break;
        }
        return fieldType;
    }

    private Map<Integer, TaskCosts> processCosts(List<Row> list) {
        HashMap<Integer, TaskCosts> hashMap = new HashMap<Integer, TaskCosts>();
        for (Row row : list) {
            Integer n = row.getInteger("task_id");
            TaskCosts taskCosts = (TaskCosts)hashMap.get(n);
            if (taskCosts == null) {
                taskCosts = new TaskCosts();
                hashMap.put(n, taskCosts);
            }
            taskCosts.addActual(row.getDouble("act_cost"));
            taskCosts.addPlanned(row.getDouble("target_cost"));
            taskCosts.addRemaining(row.getDouble("remain_cost"));
        }
        return hashMap;
    }

    private void addUserDefinedField(UserFieldDataType userFieldDataType, String string) {
        try {
            String string2;
            TaskField taskField;
            while (this.m_taskFields.containsKey(taskField = TaskField.valueOf(string2 = this.m_udfCounters.nextName(userFieldDataType))) || this.m_wbsFields.containsKey(taskField)) {
            }
            this.m_project.getCustomFields().getCustomField(taskField).setAlias(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseTaskUDF(Row row) {
        Integer n = Integer.valueOf(row.getString("udf_type_id"));
        String string = row.getString("logical_data_type");
        String string2 = row.getString("udf_type_label");
        this.m_udfMap.put(n, string2);
        this.addUserDefinedField(UserFieldDataType.valueOf(string), string2);
    }

    private void addTaskUDFValue(Task task, Row row) {
        Integer n = Integer.valueOf(row.getString("udf_type_id"));
        String string = this.m_udfMap.get(n);
        Object object = null;
        FieldType fieldType = this.m_project.getCustomFields().getFieldByAlias(FieldTypeClass.TASK, string);
        if (fieldType != null) {
            DataType dataType = fieldType.getDataType();
            switch (dataType) {
                case DATE: {
                    object = row.getDate("udf_date");
                    break;
                }
                case CURRENCY: 
                case NUMERIC: {
                    object = row.getDouble("udf_number");
                    break;
                }
                case GUID: 
                case INTEGER: {
                    object = row.getInteger("udf_code_id");
                    break;
                }
                default: {
                    object = row.getString("udf_text");
                }
            }
            task.set(fieldType, object);
        }
    }

    private List<Row> getTaskUDF(Integer n, List<Row> list) {
        LinkedList<Row> linkedList = new LinkedList<Row>();
        if (list != null) {
            for (Row row : list) {
                if (!n.equals(row.getInteger("fk_id"))) continue;
                linkedList.add(row);
            }
        }
        return linkedList;
    }

    private void populateField(FieldContainer fieldContainer, FieldType fieldType, FieldType fieldType2, FieldType fieldType3) {
        Object object = fieldContainer.getCachedValue(fieldType3);
        if (object == null) {
            object = fieldContainer.getCachedValue(fieldType2);
        }
        fieldContainer.set(fieldType, object);
    }

    private void updateStructure() {
        int n = 1;
        Integer n2 = 1;
        for (Task task : this.m_project.getChildTasks()) {
            n = this.updateStructure(n, task, n2);
        }
    }

    private int updateStructure(int n, Task task, Integer n2) {
        task.setID(n++);
        task.setOutlineLevel(n2);
        n2 = n2 + 1;
        for (Task task2 : task.getChildTasks()) {
            n = this.updateStructure(n, task2, n2);
        }
        return n;
    }

    private void updateDates() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task task) {
        int n = 0;
        Date date = task.getStart();
        Date date2 = task.getFinish();
        Date date3 = task.getActualStart();
        Date date4 = task.getActualFinish();
        for (Task task2 : task.getChildTasks()) {
            this.updateDates(task2);
            if (date == null || DateHelper.compare(date, task2.getStart()) > 0) {
                date = task2.getStart();
            }
            if (date3 == null || DateHelper.compare(date3, task2.getActualStart()) > 0) {
                date3 = task2.getActualStart();
            }
            if (date2 == null || DateHelper.compare(date2, task2.getFinish()) < 0) {
                date2 = task2.getFinish();
            }
            if (date4 == null || DateHelper.compare(date4, task2.getActualFinish()) < 0) {
                date4 = task2.getFinish();
            }
            if (task2.getActualFinish() == null) continue;
            ++n;
        }
        task.setStart(date);
        task.setFinish(date2);
        task.setActualStart(date3);
        if (n == task.getChildTasks().size()) {
            task.setActualFinish(date4);
        }
    }

    public void processPredecessors(List<Row> list) {
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("task_id")));
            Task task2 = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("pred_task_id")));
            if (task == null || task2 == null) continue;
            RelationType relationType = RELATION_TYPE_MAP.get(row.getString("pred_type"));
            Duration duration = row.getDuration("lag_hr_cnt");
            Relation relation = task.addPredecessor(task2, relationType, duration);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    public void processAssignments(List<Row> list) {
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("task_id")));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("rsrc_id"));
            if (task == null || resource == null) continue;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            this.processFields(this.m_assignmentFields, row, resourceAssignment);
            this.populateField(resourceAssignment, AssignmentField.WORK, AssignmentField.BASELINE_WORK, AssignmentField.ACTUAL_WORK);
            this.populateField(resourceAssignment, AssignmentField.COST, AssignmentField.BASELINE_COST, AssignmentField.ACTUAL_COST);
            this.populateField(resourceAssignment, AssignmentField.START, AssignmentField.BASELINE_START, AssignmentField.ACTUAL_START);
            this.populateField(resourceAssignment, AssignmentField.FINISH, AssignmentField.BASELINE_FINISH, AssignmentField.ACTUAL_FINISH);
            this.m_eventManager.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    public void processDefaultCurrency(Row row) {
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        projectProperties.setCurrencySymbol(row.getString("curr_symbol"));
        projectProperties.setSymbolPosition(CURRENCY_SYMBOL_POSITION_MAP.get(row.getString("pos_curr_fmt_type")));
        projectProperties.setCurrencyDigits(row.getInteger("decimal_digit_cnt"));
        projectProperties.setThousandsSeparator(row.getString("digit_group_symbol").charAt(0));
        projectProperties.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
    }

    private void processFields(Map<FieldType, String> map, Row row, FieldContainer fieldContainer) {
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            Object object;
            FieldType fieldType = entry.getKey();
            String string = entry.getValue();
            switch (fieldType.getDataType()) {
                case INTEGER: {
                    object = row.getInteger(string);
                    break;
                }
                case BOOLEAN: {
                    object = row.getBoolean(string);
                    break;
                }
                case DATE: {
                    object = row.getDate(string);
                    break;
                }
                case CURRENCY: 
                case NUMERIC: 
                case PERCENTAGE: {
                    object = row.getDouble(string);
                    break;
                }
                case DELAY: 
                case WORK: 
                case DURATION: {
                    object = row.getDuration(string);
                    break;
                }
                case RESOURCE_TYPE: {
                    object = RESOURCE_TYPE_MAP.get(row.getString(string));
                    break;
                }
                case TASK_TYPE: {
                    object = TASK_TYPE_MAP.get(row.getString(string));
                    break;
                }
                case CONSTRAINT: {
                    object = CONSTRAINT_TYPE_MAP.get(row.getString(string));
                    break;
                }
                case PRIORITY: {
                    object = PRIORITY_MAP.get(row.getString(string));
                    break;
                }
                default: {
                    object = row.getString(string);
                }
            }
            fieldContainer.set(fieldType, object);
        }
    }

    private Integer mapTaskID(Integer n) {
        Integer n2 = this.m_clashMap.get(n);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    private void applyAliases(Map<FieldType, String> map) {
        CustomFieldContainer customFieldContainer = this.m_project.getCustomFields();
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            customFieldContainer.getCustomField(entry.getKey()).setAlias(entry.getValue());
        }
    }

    private Number calculatePercentComplete(Row row) {
        Number number;
        switch (PercentCompleteType.getInstance(row.getString("complete_pct_type"))) {
            case UNITS: {
                number = this.calculateUnitsPercentComplete(row);
                break;
            }
            case DURATION: {
                number = this.calculateDurationPercentComplete(row);
                break;
            }
            default: {
                number = this.calculatePhysicalPercentComplete(row);
            }
        }
        return number;
    }

    private Number calculatePhysicalPercentComplete(Row row) {
        return row.getDouble("phys_complete_pct");
    }

    private Number calculateUnitsPercentComplete(Row row) {
        double d;
        double d2 = 0.0;
        double d3 = NumberHelper.getDouble(row.getDouble("act_work_qty"));
        double d4 = d3 + (d = NumberHelper.getDouble(row.getDouble("act_equip_qty")));
        if (d4 != 0.0) {
            double d5;
            double d6 = NumberHelper.getDouble(row.getDouble("remain_work_qty"));
            double d7 = d6 + d3 + (d5 = NumberHelper.getDouble(row.getDouble("remain_equip_qty"))) + d;
            d2 = d7 == 0.0 ? 0.0 : d4 * 100.0 / d7;
        }
        return NumberHelper.getDouble(d2);
    }

    private Number calculateDurationPercentComplete(Row row) {
        double d = 0.0;
        double d2 = row.getDuration("target_drtn_hr_cnt").getDuration();
        double d3 = row.getDuration("remain_drtn_hr_cnt").getDuration();
        if (d2 == 0.0) {
            if (d3 == 0.0 && row.getString("status_code").equals("TK_Complete")) {
                d = 100.0;
            }
        } else if (d3 < d2) {
            d = (d2 - d3) * 100.0 / d2;
        }
        return NumberHelper.getDouble(d);
    }

    public static Map<FieldType, String> getDefaultResourceFieldMap() {
        LinkedHashMap<FieldType, String> linkedHashMap = new LinkedHashMap<FieldType, String>();
        linkedHashMap.put(ResourceField.UNIQUE_ID, "rsrc_id");
        linkedHashMap.put(ResourceField.NAME, "rsrc_name");
        linkedHashMap.put(ResourceField.CODE, "employee_code");
        linkedHashMap.put(ResourceField.EMAIL_ADDRESS, "email_addr");
        linkedHashMap.put(ResourceField.NOTES, "rsrc_notes");
        linkedHashMap.put(ResourceField.CREATED, "create_date");
        linkedHashMap.put(ResourceField.TYPE, "rsrc_type");
        linkedHashMap.put(ResourceField.INITIALS, "rsrc_short_name");
        linkedHashMap.put(ResourceField.NUMBER1, "parent_rsrc_id");
        return linkedHashMap;
    }

    public static Map<FieldType, String> getDefaultWbsFieldMap() {
        LinkedHashMap<FieldType, String> linkedHashMap = new LinkedHashMap<FieldType, String>();
        linkedHashMap.put(TaskField.UNIQUE_ID, "wbs_id");
        linkedHashMap.put(TaskField.NAME, "wbs_name");
        linkedHashMap.put(TaskField.BASELINE_COST, "orig_cost");
        linkedHashMap.put(TaskField.REMAINING_COST, "indep_remain_total_cost");
        linkedHashMap.put(TaskField.REMAINING_WORK, "indep_remain_work_qty");
        linkedHashMap.put(TaskField.BASELINE_START, "anticip_start_date");
        linkedHashMap.put(TaskField.BASELINE_FINISH, "anticip_end_date");
        linkedHashMap.put(TaskField.DATE1, "suspend_date");
        linkedHashMap.put(TaskField.DATE2, "resume_date");
        linkedHashMap.put(TaskField.TEXT1, "task_code");
        linkedHashMap.put(TaskField.WBS, "wbs_short_name");
        return linkedHashMap;
    }

    public static Map<FieldType, String> getDefaultTaskFieldMap() {
        LinkedHashMap<FieldType, String> linkedHashMap = new LinkedHashMap<FieldType, String>();
        linkedHashMap.put(TaskField.UNIQUE_ID, "task_id");
        linkedHashMap.put(TaskField.NAME, "task_name");
        linkedHashMap.put(TaskField.REMAINING_DURATION, "remain_drtn_hr_cnt");
        linkedHashMap.put(TaskField.ACTUAL_WORK, "act_work_qty");
        linkedHashMap.put(TaskField.REMAINING_WORK, "remain_work_qty");
        linkedHashMap.put(TaskField.BASELINE_WORK, "target_work_qty");
        linkedHashMap.put(TaskField.BASELINE_DURATION, "target_drtn_hr_cnt");
        linkedHashMap.put(TaskField.CONSTRAINT_DATE, "cstr_date");
        linkedHashMap.put(TaskField.ACTUAL_START, "act_start_date");
        linkedHashMap.put(TaskField.ACTUAL_FINISH, "act_end_date");
        linkedHashMap.put(TaskField.LATE_START, "late_start_date");
        linkedHashMap.put(TaskField.LATE_FINISH, "late_end_date");
        linkedHashMap.put(TaskField.EARLY_START, "early_start_date");
        linkedHashMap.put(TaskField.EARLY_FINISH, "early_end_date");
        linkedHashMap.put(TaskField.BASELINE_START, "target_start_date");
        linkedHashMap.put(TaskField.BASELINE_FINISH, "target_end_date");
        linkedHashMap.put(TaskField.CONSTRAINT_TYPE, "cstr_type");
        linkedHashMap.put(TaskField.PRIORITY, "priority_type");
        linkedHashMap.put(TaskField.CREATED, "create_date");
        linkedHashMap.put(TaskField.TYPE, "duration_type");
        linkedHashMap.put(TaskField.FREE_SLACK, "free_float_hr_cnt");
        linkedHashMap.put(TaskField.TOTAL_SLACK, "total_float_hr_cnt");
        linkedHashMap.put(TaskField.TEXT1, "task_code");
        linkedHashMap.put(TaskField.TEXT2, "task_type");
        linkedHashMap.put(TaskField.TEXT3, "status_code");
        return linkedHashMap;
    }

    public static Map<FieldType, String> getDefaultAssignmentFieldMap() {
        LinkedHashMap<FieldType, String> linkedHashMap = new LinkedHashMap<FieldType, String>();
        linkedHashMap.put(AssignmentField.UNIQUE_ID, "taskrsrc_id");
        linkedHashMap.put(AssignmentField.REMAINING_WORK, "remain_qty");
        linkedHashMap.put(AssignmentField.BASELINE_WORK, "target_qty");
        linkedHashMap.put(AssignmentField.ACTUAL_WORK, "act_reg_qty");
        linkedHashMap.put(AssignmentField.BASELINE_COST, "target_cost");
        linkedHashMap.put(AssignmentField.ACTUAL_COST, "act_reg_cost");
        linkedHashMap.put(AssignmentField.ACTUAL_START, "act_start_date");
        linkedHashMap.put(AssignmentField.ACTUAL_FINISH, "act_end_date");
        linkedHashMap.put(AssignmentField.BASELINE_START, "target_start_date");
        linkedHashMap.put(AssignmentField.BASELINE_FINISH, "target_end_date");
        linkedHashMap.put(AssignmentField.ASSIGNMENT_DELAY, "target_lag_drtn_hr_cnt");
        return linkedHashMap;
    }

    public static Map<FieldType, String> getDefaultAliases() {
        HashMap<FieldType, String> hashMap = new HashMap<FieldType, String>();
        hashMap.put(ResourceField.NUMBER1, "Parent Resource Unique ID");
        hashMap.put(TaskField.DATE1, "Suspend Date");
        hashMap.put(TaskField.DATE2, "Resume Date");
        hashMap.put(TaskField.TEXT1, "Code");
        hashMap.put(TaskField.TEXT2, "Activity Type");
        hashMap.put(TaskField.TEXT3, "Status");
        return hashMap;
    }

    static {
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Mat", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("RT_Equip", ResourceType.WORK);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("CS_MSO", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MSOB", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MSOA", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEO", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MEOB", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEOA", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_ALAP", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("CS_MANDSTART", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MANDFIN", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("PT_Top", Priority.getInstance(900));
        PRIORITY_MAP.put("PT_High", Priority.getInstance(600));
        PRIORITY_MAP.put("PT_Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("PT_Low", Priority.getInstance(400));
        PRIORITY_MAP.put("PT_Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("PR_FS", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("PR_FF", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("PR_SS", RelationType.START_START);
        RELATION_TYPE_MAP.put("PR_SF", RelationType.START_FINISH);
        TASK_TYPE_MAP = new HashMap<String, TaskType>();
        TASK_TYPE_MAP.put("DT_FixedDrtn", TaskType.FIXED_DURATION);
        TASK_TYPE_MAP.put("DT_FixedQty", TaskType.FIXED_UNITS);
        TASK_TYPE_MAP.put("DT_FixedDUR2", TaskType.FIXED_WORK);
        TASK_TYPE_MAP.put("DT_FixedRate", TaskType.FIXED_WORK);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("TT_Task", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Rsrc", Boolean.FALSE);
        MILESTONE_MAP.put("TT_LOE", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Mile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_FinMile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_WBS", Boolean.FALSE);
        CURRENCY_SYMBOL_POSITION_MAP = new HashMap<String, CurrencySymbolPosition>();
        CURRENCY_SYMBOL_POSITION_MAP.put("#1.1", CurrencySymbolPosition.BEFORE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1#", CurrencySymbolPosition.AFTER);
        CURRENCY_SYMBOL_POSITION_MAP.put("# 1.1", CurrencySymbolPosition.BEFORE_WITH_SPACE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1 #", CurrencySymbolPosition.AFTER_WITH_SPACE);
    }
}

