/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;

public abstract class WeakFactoryMap<T, V> {
    private final ConcurrentMap<T, V> myMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap();

    protected abstract V create(T var1);

    public final V get(T key) {
        Object v = this.myMap.get(key);
        if (v != null) {
            return v == ObjectUtils.NULL ? null : (V)v;
        }
        V value = this.create(key);
        V prev = this.myMap.putIfAbsent(key, WeakFactoryMap.notNull(value));
        return prev == null || prev == ObjectUtils.NULL ? value : prev;
    }

    public final boolean containsKey(T key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    private static <K> K notNull(K key) {
        return (K)(key == null ? ObjectUtils.NULL : key);
    }

    public void put(T key, V value) {
        this.myMap.put(WeakFactoryMap.notNull(key), WeakFactoryMap.notNull(value));
    }
}

