/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class DistinctRootsCollection<T>
implements Collection<T> {
    private final Collection<T> myCollection = new ArrayList<T>();

    protected abstract boolean isAncestor(@NotNull T var1, @NotNull T var2);

    public DistinctRootsCollection() {
    }

    public DistinctRootsCollection(Collection<T> collection) {
        this.addAll((Collection<? extends T>)collection);
    }

    public DistinctRootsCollection(T[] collection) {
        this(Arrays.asList(collection));
    }

    @Override
    public int size() {
        return this.myCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myCollection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myCollection.contains(o);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<T> iterator = this.myCollection.iterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/DistinctRootsCollection", "iterator"));
        }
        return iterator;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = this.myCollection.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/DistinctRootsCollection", "toArray"));
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/DistinctRootsCollection", "toArray"));
        }
        T[] TArray = this.myCollection.toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/DistinctRootsCollection", "toArray"));
        }
        return TArray;
    }

    @Override
    public boolean add(T o) {
        ArrayList<T> toRemove = new ArrayList<T>();
        for (T existing : this.myCollection) {
            if (this.isAncestor(existing, o)) {
                return false;
            }
            if (!this.isAncestor(o, existing)) continue;
            toRemove.add(existing);
        }
        this.myCollection.removeAll(toRemove);
        this.myCollection.add(o);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.myCollection.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/DistinctRootsCollection", "containsAll"));
        }
        return this.myCollection.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/DistinctRootsCollection", "addAll"));
        }
        boolean changed = false;
        for (T t : c) {
            changed |= this.add(t);
        }
        return changed;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/DistinctRootsCollection", "removeAll"));
        }
        return this.myCollection.removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/DistinctRootsCollection", "retainAll"));
        }
        return this.myCollection.retainAll(c);
    }

    @Override
    public void clear() {
        this.myCollection.clear();
    }
}

