/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ImageLoader
implements Serializable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");
    public static final Component ourComponent = new Component(){};

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        return ImageLoader.loadFromUrl(url, true);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        return ImageLoader.loadFromUrl(url, allowFloatScaling, null);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling, ImageFilter filter) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        final float scaleFactor = ImageLoader.calcScaleFactor(allowFloatScaling);
        final boolean scaleImages = scaleFactor > 1.0f && !UIUtil.isRetina();
        boolean loadRetinaImages = UIUtil.isRetina() || scaleImages;
        return ImageDescList.create(url.toString(), null, UIUtil.isUnderDarcula(), loadRetinaImages, allowFloatScaling).load(ImageConverterChain.create().withFilter(filter).withRetina().with(new ImageConverter(){

            @Override
            public Image convert(Image source, ImageDesc desc) {
                if (source != null && scaleImages && desc.type != ImageDesc.Type.SVG) {
                    if (desc.path.contains("@2x")) {
                        return ImageLoader.scaleImage(source, scaleFactor / 2.0f);
                    }
                    return ImageLoader.scaleImage(source, scaleFactor);
                }
                return source;
            }
        }));
    }

    private static float calcScaleFactor(boolean allowFloatScaling) {
        float scaleFactor;
        float f = allowFloatScaling ? JBUI.scale(1.0f) : (scaleFactor = JBUI.scale(1.0f) > 1.5f ? 2.0f : 1.0f);
        assert (scaleFactor >= 1.0f) : "By design, only scale factors >= 1.0 are supported";
        return scaleFactor;
    }

    @NotNull
    private static Image scaleImage(Image image, float scale) {
        int width = (int)(scale * (float)image.getWidth(null));
        int height = (int)(scale * (float)image.getHeight(null));
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ImageLoader", "scaleImage"));
        }
        return bufferedImage;
    }

    @Nullable
    public static Image loadFromUrl(URL url, boolean dark, boolean retina) {
        return ImageLoader.loadFromUrl(url, dark, retina, null);
    }

    @Nullable
    public static Image loadFromUrl(URL url, boolean dark, boolean retina, ImageFilter filter) {
        return ImageDescList.create(url.toString(), null, dark, retina, true).load(ImageConverterChain.create().withFilter(filter).withRetina());
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/ImageLoader", "loadFromResource"));
        }
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/ImageLoader", "loadFromResource"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ImageLoader", "loadFromResource"));
        }
        return ImageDescList.create(path, aClass, UIUtil.isUnderDarcula(), UIUtil.isRetina() || JBUI.scale(1.0f) >= 1.5f, true).load(ImageConverterChain.create().withRetina());
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "loadFromStream"));
        }
        return ImageLoader.loadFromStream(inputStream, 1);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "loadFromStream"));
        }
        return ImageLoader.loadFromStream(inputStream, scale, null);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, int scale, ImageFilter filter) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "loadFromStream"));
        }
        Image image = ImageLoader.load(inputStream, scale);
        ImageDesc desc = new ImageDesc("", null, scale, ImageDesc.Type.UNDEFINED);
        return ImageConverterChain.create().withFilter(filter).withRetina().convert(image, desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image load(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "load"));
        }
        if (scale <= 0) {
            throw new IllegalArgumentException("Scale must be 1 or greater");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            ImageLoader.waitForImage(image);
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }

    public static boolean isGoodSize(Icon icon) {
        return IconLoader.isGoodSize(icon);
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader", "getFileNames"));
        }
        return ImageLoader.getFileNames(file, false, false);
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file, boolean dark, boolean retina) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader", "getFileNames"));
        }
        new UnsupportedOperationException("unsupported method").printStackTrace();
        return new ArrayList<Pair<String, Integer>>();
    }

    private static class ImageConverterChain
    extends ArrayList<ImageConverter> {
        private ImageConverterChain() {
        }

        public static ImageConverterChain create() {
            return new ImageConverterChain();
        }

        public ImageConverterChain withFilter(final ImageFilter filter) {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    return ImageUtil.filter(source, filter);
                }
            });
        }

        public ImageConverterChain withRetina() {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    if (source != null && UIUtil.isRetina() && desc.scale > 1.0f) {
                        return RetinaImage.createFrom(source, (int)desc.scale, ourComponent);
                    }
                    return source;
                }
            });
        }

        public ImageConverterChain with(ImageConverter f) {
            this.add(f);
            return this;
        }

        public Image convert(Image image, ImageDesc desc) {
            for (ImageConverter f : this) {
                image = f.convert(image, desc);
            }
            return image;
        }
    }

    private static interface ImageConverter {
        public Image convert(@Nullable Image var1, ImageDesc var2);
    }

    private static class ImageDescList
    extends ArrayList<ImageDesc> {
        private ImageDescList() {
        }

        @Nullable
        public Image load() {
            return this.load(ImageConverterChain.create());
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters) {
            if (converters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converters", "com/intellij/util/ImageLoader$ImageDescList", "load"));
            }
            for (ImageDesc desc : this) {
                try {
                    Image image = desc.load();
                    if (image == null) continue;
                    LOG.debug("Loaded image: " + desc);
                    return converters.convert(image, desc);
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        public static ImageDescList create(@NotNull String file, @Nullable Class cls, boolean dark, boolean retina, boolean allowFloatScaling) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader$ImageDescList", "create"));
            }
            ImageDescList vars = new ImageDescList();
            if (retina || dark) {
                String name = FileUtil.getNameWithoutExtension(file);
                String ext = FileUtilRt.getExtension(file);
                float scale = ImageLoader.calcScaleFactor(allowFloatScaling);
                if (Registry.is("ide.svg.icon") && dark) {
                    vars.add(new ImageDesc(name + "_dark.svg", cls, UIUtil.isRetina() ? 2.0f : scale, ImageDesc.Type.SVG));
                }
                if (Registry.is("ide.svg.icon")) {
                    vars.add(new ImageDesc(name + ".svg", cls, UIUtil.isRetina() ? 2.0f : scale, ImageDesc.Type.SVG));
                }
                if (dark && retina) {
                    vars.add(new ImageDesc(name + "@2x_dark." + ext, cls, 2.0f, ImageDesc.Type.PNG));
                }
                if (dark) {
                    vars.add(new ImageDesc(name + "_dark." + ext, cls, 1.0f, ImageDesc.Type.PNG));
                }
                if (retina) {
                    vars.add(new ImageDesc(name + "@2x." + ext, cls, 2.0f, ImageDesc.Type.PNG));
                }
            }
            vars.add(new ImageDesc(file, cls, 1.0f, ImageDesc.Type.PNG));
            return vars;
        }
    }

    private static class ImageDesc {
        public final String path;
        @Nullable
        public final Class cls;
        public final float scale;
        public final Type type;

        public ImageDesc(String path, Class cls, float scale, Type type) {
            this.path = path;
            this.cls = cls;
            this.scale = scale;
            this.type = type;
        }

        @Nullable
        public Image load() throws IOException {
            InputStream stream = null;
            URL url = null;
            if (this.cls != null && (stream = this.cls.getResourceAsStream(this.path)) == null) {
                return null;
            }
            if (stream == null) {
                url = new URL(this.path);
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    connection.addRequestProperty("User-Agent", "IntelliJ");
                }
                stream = connection.getInputStream();
            }
            return this.type.load(url, stream, this.scale);
        }

        public String toString() {
            return this.path + ", scale: " + this.scale + ", type: " + (Object)((Object)this.type);
        }

        public static enum Type {
            PNG,
            SVG{

                @Override
                public Image load(URL url, InputStream is, float scale) throws IOException {
                    return SVGLoader.load(url, is, scale);
                }
            }
            ,
            UNDEFINED;


            public Image load(URL url, InputStream stream, float scale) throws IOException {
                return ImageLoader.load(stream, (int)scale);
            }
        }
    }
}

