/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.data;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassOrObjectInfo;

public class KtObjectInfo
extends KtClassOrObjectInfo<KtObjectDeclaration> {
    @NotNull
    private final ClassKind kind;

    protected KtObjectInfo(@NotNull KtObjectDeclaration element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/lazy/data/KtObjectInfo", "<init>"));
        }
        super(element2);
        this.kind = element2.isObjectLiteral() ? ClassKind.CLASS : ClassKind.OBJECT;
    }

    @Override
    @Nullable
    public KtTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    @NotNull
    public ClassKind getClassKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtObjectInfo", "getClassKind"));
        }
        return classKind;
    }

    public boolean isCompanionObject() {
        return ((KtObjectDeclaration)this.element).isCompanion() && ModifiersChecker.isCompanionModifierAllowed(this.element);
    }
}

