/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import gnu.trove.TIntArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/psi/KotlinStringLiteralTextEscaper;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "host", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)V", "sourceOffsets", "", "decode", "", "rangeInsideHost", "Lcom/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "getRelevantTextRange", "isOneLine", "frontend"})
public final class KotlinStringLiteralTextEscaper
extends LiteralTextEscaper<KtStringTemplateExpression> {
    private int[] sourceOffsets;

    /*
     * WARNING - void declaration
     */
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        void sourceOffset;
        Intrinsics.checkParameterIsNotNull((Object)rangeInsideHost, (String)"rangeInsideHost");
        Intrinsics.checkParameterIsNotNull((Object)outChars, (String)"outChars");
        TIntArrayList sourceOffsetsList = new TIntArrayList();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)this.myHost).getEntries();
        block0: for (int i = 0; i < ktStringTemplateEntryArray.length; ++i) {
            int it;
            int index$iv;
            int n;
            int times$iv;
            KtStringTemplateEntry child = ktStringTemplateEntryArray[i];
            TextRange childRange = TextRange.from((int)child.getStartOffsetInParent(), (int)child.getTextLength());
            if (rangeInsideHost.getEndOffset() <= childRange.getStartOffset()) break;
            if (childRange.getEndOffset() <= rangeInsideHost.getStartOffset()) continue;
            KtStringTemplateEntry ktStringTemplateEntry = child;
            if (ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry) {
                TextRange textRange = rangeInsideHost.intersection(childRange);
                if (textRange == null) {
                    Intrinsics.throwNpe();
                }
                TextRange textRange2 = textRange.shiftRight(-childRange.getStartOffset());
                outChars.append(child.getText(), textRange2.getStartOffset(), textRange2.getEndOffset());
                int n2 = textRange2.getLength();
                int n3 = 0;
                n = times$iv - 1;
                if (n3 > n) continue;
                while (true) {
                    it = ++index$iv;
                    int n4 = sourceOffset.element;
                    sourceOffset.element = n4 + 1;
                    sourceOffsetsList.add(n4);
                    if (index$iv == n) continue block0;
                }
            }
            if (ktStringTemplateEntry instanceof KtEscapeStringTemplateEntry) {
                if (!rangeInsideHost.contains(childRange)) {
                    return false;
                }
                String unescaped = ((KtEscapeStringTemplateEntry)child).getUnescapedValue();
                outChars.append(unescaped);
                times$iv = unescaped.length();
                index$iv = 0;
                n = times$iv - 1;
                if (index$iv <= n) {
                    do {
                        it = ++index$iv;
                        sourceOffsetsList.add(sourceOffset.element);
                    } while (index$iv != n);
                }
                sourceOffset.element += child.getTextLength();
                continue;
            }
            return false;
        }
        sourceOffsetsList.add(sourceOffset.element);
        this.sourceOffsets = sourceOffsetsList.toNativeArray();
        return true;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        Intrinsics.checkParameterIsNotNull((Object)rangeInsideHost, (String)"rangeInsideHost");
        int[] offsets = this.sourceOffsets;
        if (offsets == null || offsetInDecoded >= offsets.length) {
            return -1;
        }
        return Math.min(offsets[offsetInDecoded], rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    @NotNull
    public TextRange getRelevantTextRange() {
        return KtPsiUtilKt.getContentRange((KtStringTemplateExpression)this.myHost);
    }

    public boolean isOneLine() {
        return KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)this.myHost);
    }

    public KotlinStringLiteralTextEscaper(@NotNull KtStringTemplateExpression host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        super((PsiLanguageInjectionHost)host);
    }
}

