/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import java.util.Collections;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public final class FqNameUnsafe {
    public static final Name ROOT_NAME = Name.special("<root>");
    @NotNull
    private final String fqName;
    private transient FqName safe;
    private transient FqNameUnsafe parent;
    private transient Name shortName;

    FqNameUnsafe(@NotNull String fqName2, @NotNull FqName safe) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/name/FqNameUnsafe", "<init>"));
        }
        if (safe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safe", "org/jetbrains/kotlin/name/FqNameUnsafe", "<init>"));
        }
        this.fqName = fqName2;
        this.safe = safe;
    }

    public FqNameUnsafe(@NotNull String fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/name/FqNameUnsafe", "<init>"));
        }
        this.fqName = fqName2;
    }

    private FqNameUnsafe(@NotNull String fqName2, FqNameUnsafe parent2, Name shortName) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/name/FqNameUnsafe", "<init>"));
        }
        this.fqName = fqName2;
        this.parent = parent2;
        this.shortName = shortName;
    }

    public static boolean isValid(@Nullable String qualifiedName) {
        return qualifiedName != null && qualifiedName.indexOf(47) < 0 && qualifiedName.indexOf(42) < 0;
    }

    private void compute() {
        int lastDot = this.fqName.lastIndexOf(46);
        if (lastDot >= 0) {
            this.shortName = Name.guess(this.fqName.substring(lastDot + 1));
            this.parent = new FqNameUnsafe(this.fqName.substring(0, lastDot));
        } else {
            this.shortName = Name.guess(this.fqName);
            this.parent = FqName.ROOT.toUnsafe();
        }
    }

    @NotNull
    public String asString() {
        String string = this.fqName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "asString"));
        }
        return string;
    }

    public boolean isSafe() {
        return this.safe != null || this.asString().indexOf(60) < 0;
    }

    @NotNull
    public FqName toSafe() {
        if (this.safe != null) {
            FqName fqName2 = this.safe;
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "toSafe"));
            }
            return fqName2;
        }
        FqName fqName3 = this.safe = new FqName(this);
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "toSafe"));
        }
        return fqName3;
    }

    public boolean isRoot() {
        return this.fqName.isEmpty();
    }

    @NotNull
    public FqNameUnsafe parent() {
        if (this.parent != null) {
            FqNameUnsafe fqNameUnsafe = this.parent;
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "parent"));
            }
            return fqNameUnsafe;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.compute();
        FqNameUnsafe fqNameUnsafe = this.parent;
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "parent"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public FqNameUnsafe child(@NotNull Name name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/name/FqNameUnsafe", "child"));
        }
        String childFqName = this.isRoot() ? name2.asString() : this.fqName + "." + name2.asString();
        FqNameUnsafe fqNameUnsafe = new FqNameUnsafe(childFqName, this, name2);
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "child"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public Name shortName() {
        if (this.shortName != null) {
            Name name2 = this.shortName;
            if (name2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "shortName"));
            }
            return name2;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.compute();
        Name name3 = this.shortName;
        if (name3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "shortName"));
        }
        return name3;
    }

    @NotNull
    public Name shortNameOrSpecial() {
        if (this.isRoot()) {
            Name name2 = ROOT_NAME;
            if (name2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "shortNameOrSpecial"));
            }
            return name2;
        }
        Name name3 = this.shortName();
        if (name3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "shortNameOrSpecial"));
        }
        return name3;
    }

    @NotNull
    public List<Name> pathSegments() {
        List list2 = this.isRoot() ? Collections.emptyList() : ArraysKt.map((Object[])this.fqName.split("\\."), (Function1)new Function1<String, Name>(){

            public Name invoke(String name2) {
                return Name.guess(name2);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "pathSegments"));
        }
        return list2;
    }

    public boolean startsWith(@NotNull Name segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "org/jetbrains/kotlin/name/FqNameUnsafe", "startsWith"));
        }
        return !this.isRoot() && this.pathSegments().get(0).equals(segment);
    }

    @NotNull
    public static FqNameUnsafe topLevel(@NotNull Name shortName) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "org/jetbrains/kotlin/name/FqNameUnsafe", "topLevel"));
        }
        FqNameUnsafe fqNameUnsafe = new FqNameUnsafe(shortName.asString(), FqName.ROOT.toUnsafe(), shortName);
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "topLevel"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public String toString() {
        String string = this.isRoot() ? ROOT_NAME.asString() : this.fqName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/FqNameUnsafe", "toString"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FqNameUnsafe)) {
            return false;
        }
        FqNameUnsafe that = (FqNameUnsafe)o;
        return this.fqName.equals(that.fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }
}

