/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.sam;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.components.SamConversionResolver;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaConstructorDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaClassDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J&\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016J!\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u000e2\u0006\u0010\u0011\u001a\u0002H\u0010H\u0017\u00a2\u0006\u0002\u0010\u0012J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/load/java/sam/SamConversionResolverImpl;", "Lorg/jetbrains/kotlin/load/java/components/SamConversionResolver;", "()V", "findFunctionWithMostSpecificReturnType", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "supertypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveFunctionTypeIfSamInterface", "classDescriptor", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaClassDescriptor;", "resolveMethod", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/load/java/structure/JavaMethod;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolveSamAdapter", "D", "original", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolveSamConstructor", "Lorg/jetbrains/kotlin/load/java/descriptors/SamConstructorDescriptor;", "constructorOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "classifier", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "frontend.java"})
public final class SamConversionResolverImpl
implements SamConversionResolver {
    public static final SamConversionResolverImpl INSTANCE;

    @Override
    @Nullable
    public SamConstructorDescriptor resolveSamConstructor(@NotNull DeclarationDescriptor constructorOwner, @NotNull Function0<? extends ClassifierDescriptor> classifier2) {
        Intrinsics.checkParameterIsNotNull((Object)constructorOwner, (String)"constructorOwner");
        Intrinsics.checkParameterIsNotNull(classifier2, (String)"classifier");
        ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)classifier2.invoke();
        if (!(classifierDescriptor instanceof LazyJavaClassDescriptor) || ((LazyJavaClassDescriptor)classifierDescriptor).getFunctionTypeForSamInterface() == null) {
            return null;
        }
        return SingleAbstractMethodUtils.createSamConstructorFunction(constructorOwner, (JavaClassDescriptor)classifierDescriptor);
    }

    @Override
    @Nullable
    public <D extends FunctionDescriptor> D resolveSamAdapter(@NotNull D original) {
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull(original, (String)"original");
        if (!SingleAbstractMethodUtils.isSamAdapterNecessary(original)) {
            functionDescriptor = null;
        } else if (original instanceof JavaConstructorDescriptor) {
            SamAdapterDescriptor<JavaConstructorDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.createSamAdapterConstructor((JavaConstructorDescriptor)original);
            if (samAdapterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            functionDescriptor = samAdapterDescriptor;
        } else if (original instanceof JavaMethodDescriptor) {
            SamAdapterDescriptor<JavaMethodDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.createSamAdapterFunction((JavaMethodDescriptor)original);
            if (samAdapterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            functionDescriptor = samAdapterDescriptor;
        } else {
            functionDescriptor = null;
        }
        return (D)functionDescriptor;
    }

    @Override
    @Nullable
    public KotlinType resolveFunctionTypeIfSamInterface(@NotNull JavaClassDescriptor classDescriptor, @NotNull Function1<? super JavaMethod, ? extends FunctionDescriptor> resolveMethod) {
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkParameterIsNotNull(resolveMethod, (String)"resolveMethod");
        SourceElement sourceElement = classDescriptor.getSource();
        if (!(sourceElement instanceof JavaSourceElement)) {
            sourceElement = null;
        }
        JavaSourceElement javaSourceElement = (JavaSourceElement)sourceElement;
        JavaElement javaElement = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
        if (!(javaElement instanceof JavaClass)) {
            javaElement = null;
        }
        JavaClass javaClass = (JavaClass)javaElement;
        if (javaClass == null) {
            return null;
        }
        JavaClass jClass = javaClass;
        JavaMethod javaMethod = SingleAbstractMethodUtils.getSamInterfaceMethod(jClass);
        if (javaMethod == null) {
            return null;
        }
        JavaMethod samInterfaceMethod = javaMethod;
        if (Intrinsics.areEqual((Object)jClass.getFqName(), (Object)samInterfaceMethod.getContainingClass().getFqName())) {
            JavaMethod javaMethod2 = samInterfaceMethod;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaMethod2, (String)"samInterfaceMethod");
            functionDescriptor = (FunctionDescriptor)resolveMethod.invoke((Object)javaMethod2);
        } else {
            Set<KotlinType> set = TypeUtils.getAllSupertypes(classDescriptor.getDefaultType());
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"TypeUtils.getAllSupertyp\u2026ssDescriptor.defaultType)");
            functionDescriptor = this.findFunctionWithMostSpecificReturnType(set);
        }
        FunctionDescriptor abstractMethod = functionDescriptor;
        return SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(abstractMethod);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleFunctionDescriptor findFunctionWithMostSpecificReturnType(Set<? extends KotlinType> supertypes2) {
        void var3_6;
        ArrayList<SimpleFunctionDescriptor> candidates = new ArrayList<SimpleFunctionDescriptor>(supertypes2.size());
        for (KotlinType kotlinType : supertypes2) {
            List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(kotlinType);
            if (abstractMembers.isEmpty()) continue;
            CallableMemberDescriptor callableMemberDescriptor = abstractMembers.get(0);
            if (callableMemberDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
            }
            candidates.add((SimpleFunctionDescriptor)callableMemberDescriptor);
        }
        if (candidates.isEmpty()) {
            throw (Throwable)new IllegalStateException("Couldn't find abstract method in supertypes " + supertypes2);
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)candidates.get(0);
        for (SimpleFunctionDescriptor candidate : candidates) {
            Unit unit;
            KotlinType candidateReturnType = candidate.getReturnType();
            KotlinType currentMostSpecificReturnType = var3_6.getReturnType();
            boolean bl = candidateReturnType != null && currentMostSpecificReturnType != null;
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = candidate + ", " + currentMostSpecificReturnType;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            KotlinType kotlinType = candidateReturnType;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            KotlinType kotlinType2 = currentMostSpecificReturnType;
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(kotlinType, kotlinType2)) continue;
            SimpleFunctionDescriptor simpleFunctionDescriptor2 = candidate;
        }
        void v4 = var3_6;
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"currentMostSpecificType");
        return v4;
    }

    private SamConversionResolverImpl() {
        INSTANCE = this;
    }

    static {
        new SamConversionResolverImpl();
    }
}

