/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.OverrideResolver;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\b\u0010\u001a\u001a\u00020\u0017H\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH$J\u0006\u0010 \u001a\u00020\u0017J,\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0002R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "", "project", "Lcom/intellij/openapi/project/Project;", "callableDescriptor", "commandName", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCallableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getCommandName", "()Ljava/lang/String;", "kind", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkModifiable", "", "element", "Lcom/intellij/psi/PsiElement;", "forcePerformForSelectedFunctionOnly", "getClosestModifiableDescriptors", "", "performRefactoring", "", "descriptorsForChange", "run", "showSuperFunctionWarningDialog", "", "superCallables", "callableFromEditor", "options", "", "idea"})
public abstract class CallableRefactoring<T extends CallableDescriptor> {
    private final Logger LOG;
    private final CallableMemberDescriptor.Kind kind;
    @NotNull
    private final Project project;
    @NotNull
    private final T callableDescriptor;
    @NotNull
    private final String commandName;

    protected boolean forcePerformForSelectedFunctionOnly() {
        return false;
    }

    private final Collection<CallableDescriptor> getClosestModifiableDescriptors() {
        Collection<CallableMemberDescriptor> collection;
        CallableMemberDescriptor.Kind kind2 = this.kind;
        if (Intrinsics.areEqual((Object)((Object)kind2), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION))) {
            Collection<CallableMemberDescriptor> collection2 = (Collection<CallableMemberDescriptor>)Collections.singleton(this.callableDescriptor);
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"Collections.singleton(callableDescriptor)");
        } else if (Intrinsics.areEqual((Object)((Object)kind2), (Object)((Object)CallableMemberDescriptor.Kind.DELEGATION)) || Intrinsics.areEqual((Object)((Object)kind2), (Object)((Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE))) {
            T t = this.callableDescriptor;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
            }
            Collection<CallableMemberDescriptor> collection3 = OverrideResolver.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)t);
            collection = collection3;
            Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"OverrideResolver.getDire\u2026CallableMemberDescriptor)");
        } else {
            throw (Throwable)new IllegalStateException("Unexpected callable kind: " + (Object)((Object)this.kind));
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final int showSuperFunctionWarningDialog(Collection<? extends CallableDescriptor> superCallables, CallableDescriptor callableFromEditor, List<String> options) {
        void $receiver$iv;
        String string;
        CharSequence it;
        String string2;
        Object item$iv$iv;
        CharSequence $receiver$iv$iv;
        Function1 $receiver$iv2;
        Iterable iterable = superCallables;
        void var6_5 = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Object object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            void destination$iv$iv;
            item$iv$iv = object.next();
            CallableDescriptor callableDescriptor = (CallableDescriptor)item$iv$iv;
            string2 = destination$iv$iv;
            string = it.getContainingDeclaration().getName().asString();
            string2.add(string);
        }
        $receiver$iv2 = null;
        $receiver$iv$iv = null;
        int destination$iv$iv = 0;
        object = ".\n\n";
        item$iv$iv = ",\n    ";
        it = "\n    ";
        String superString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), item$iv$iv, (CharSequence)it, (CharSequence)object, (int)destination$iv$iv, $receiver$iv$iv, $receiver$iv2, (int)56, null);
        String message2 = KotlinBundle.message("x.overrides.y.in.class.list", DescriptorRenderer.COMPACT.render(callableFromEditor), callableFromEditor.getContainingDeclaration().getName().asString(), superString, "refactor");
        String string3 = IdeBundle.message((String)"title.warning", (Object[])new Object[0]);
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        String title = string3;
        Icon icon = Messages.getQuestionIcon();
        object = options;
        string = title;
        string2 = message2;
        void v1 = $receiver$iv;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)v1;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = stringArray;
        return Messages.showDialog((String)string2, (String)string, (String[])((String[])objectArray), (int)0, (Icon)icon);
    }

    protected final boolean checkModifiable(@NotNull PsiElement element2) {
        String unmodifiableFile;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (JetRefactoringUtilKt.canRefactor(element2)) {
            return true;
        }
        PsiFile psiFile = element2.getContainingFile();
        String string = psiFile != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getPresentableUrl() : (unmodifiableFile = null);
        if (unmodifiableFile != null) {
            String message2 = RefactoringBundle.message((String)"refactoring.cannot.be.performed") + "\n" + IdeBundle.message((String)"error.message.cannot.modify.file.0", (Object[])new Object[]{unmodifiableFile});
            String string2 = CommonBundle.getErrorTitle();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Messages.showErrorDialog((Project)this.project, (String)message2, (String)string2);
        } else {
            this.LOG.error("Could not find file for Psi element: " + element2.getText());
        }
        return false;
    }

    protected abstract void performRefactoring(@NotNull Collection<? extends CallableDescriptor> var1);

    /*
     * Unable to fully structure code
     */
    public final boolean run() {
        buttonPressed$ = run.1.INSTANCE;
        performForWholeHierarchy$ = run.2.INSTANCE;
        performForSelectedFunctionOnly$ = run.3.INSTANCE;
        buildDialogOptions$ = run.4.INSTANCE;
        if (Intrinsics.areEqual((Object)this.kind, (Object)CallableMemberDescriptor.Kind.SYNTHESIZED)) {
            this.LOG.error("Change signature refactoring should not be called for synthesized member " + this.callableDescriptor);
            return false;
        }
        closestModifiableDescriptors = this.getClosestModifiableDescriptors();
        if (this.forcePerformForSelectedFunctionOnly()) {
            this.performRefactoring(closestModifiableDescriptors);
            return true;
        }
        var6_6 = closestModifiableDescriptors.isEmpty() == false;
        if (_Assertions.ENABLED) {
            if (value$iv == false) {
                message$iv = "Should contain original declaration or some of its super declarations";
                throw (Throwable)new AssertionError((Object)message$iv);
            }
            v0 = Unit.INSTANCE;
        } else {
            v0 = Unit.INSTANCE;
        }
        if (!((v1 = this.callableDescriptor) instanceof CallableMemberDescriptor)) {
            v1 = null;
        }
        if ((v2 = (CallableMemberDescriptor)v1) == null) ** GOTO lbl-1000
        message$iv = v2;
        it = (CallableMemberDescriptor)$receiver$iv;
        v2 = OverrideResolver.getDeepestSuperDeclarations(it);
        if (v2 != null) {
            v3 = v2;
        } else lbl-1000:
        // 2 sources

        {
            v3 = Collections.singletonList(this.callableDescriptor);
        }
        deepestSuperDeclarations = v3;
        v4 = ApplicationManager.getApplication();
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        if (v4.isUnitTestMode()) {
            v5 = deepestSuperDeclarations;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"deepestSuperDeclarations");
            this.performRefactoring(v5);
            return true;
        }
        if (closestModifiableDescriptors.size() == 1 && CollectionsKt.subtract((Iterable)deepestSuperDeclarations, (Iterable)closestModifiableDescriptors).isEmpty()) {
            this.performRefactoring(closestModifiableDescriptors);
            return true;
        }
        isSingleFunctionSelected = closestModifiableDescriptors.size() == 1;
        selectedFunction = isSingleFunctionSelected != false ? (CallableDescriptor)CollectionsKt.first((Iterable)closestModifiableDescriptors) : this.callableDescriptor;
        optionsForDialog = buildDialogOptions$.invoke(isSingleFunctionSelected);
        v6 = deepestSuperDeclarations;
        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"deepestSuperDeclarations");
        code = this.showSuperFunctionWarningDialog(v6, (CallableDescriptor)selectedFunction, optionsForDialog);
        if (performForWholeHierarchy$.invoke(optionsForDialog, code)) {
            v7 = deepestSuperDeclarations;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"deepestSuperDeclarations");
            this.performRefactoring(v7);
        } else if (performForSelectedFunctionOnly$.invoke(optionsForDialog, code)) {
            this.performRefactoring(closestModifiableDescriptors);
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final T getCallableDescriptor() {
        return this.callableDescriptor;
    }

    @NotNull
    public final String getCommandName() {
        return this.commandName;
    }

    public CallableRefactoring(@NotNull Project project, @NotNull T callableDescriptor, @NotNull String commandName) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(callableDescriptor, (String)"callableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)commandName, (String)"commandName");
        this.project = project;
        this.callableDescriptor = callableDescriptor;
        this.commandName = commandName;
        this.LOG = Logger.getInstance(CallableRefactoring.class);
        T t = this.callableDescriptor;
        if (!(t instanceof CallableMemberDescriptor)) {
            t = null;
        }
        if ((object = (CallableMemberDescriptor)t) == null || (object = object.getKind()) == null) {
            object = CallableMemberDescriptor.Kind.DECLARATION;
        }
        this.kind = object;
    }
}

