/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MoveTypeParameterConstraintFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "element", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class MoveTypeParameterConstraintFix
extends KotlinQuickFixAction<KtTypeParameter>
implements CleanupFix {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Move type parameter constraint to 'where' clause";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Unit unit;
        ASTNode colon;
        ASTNode aSTNode;
        Unit unit2;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Name name2 = ((KtTypeParameter)this.getElement()).getNameAsName();
        if (name2 == null) {
            return;
        }
        Name typeParameterName = name2;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)file);
        KtDeclaration ktDeclaration = CreateByPatternKt.buildDeclaration(psiFactory, (Function1<? super BuilderByPattern<KtDeclaration>, Unit>)((Function1)new Function1<BuilderByPattern<KtDeclaration>, Unit>(this, typeParameterName){
            final /* synthetic */ MoveTypeParameterConstraintFix this$0;
            final /* synthetic */ Name $typeParameterName;

            public final void invoke(BuilderByPattern<KtDeclaration> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                $receiver.appendFixedText("class A<");
                Name name2 = this.$typeParameterName;
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"typeParameterName");
                $receiver.appendName(name2);
                $receiver.appendFixedText("> where ");
                Name name3 = this.$typeParameterName;
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"typeParameterName");
                $receiver.appendName(name3);
                $receiver.appendFixedText(":");
                $receiver.appendTypeReference(((KtTypeParameter)this.this$0.getElement()).getExtendsBound());
            }
            {
                this.this$0 = moveTypeParameterConstraintFix;
                this.$typeParameterName = name2;
                super(1);
            }
        }));
        if (ktDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeParameterListOwner");
        }
        KtTypeParameterListOwner templateClass2 = (KtTypeParameterListOwner)ktDeclaration;
        KtTypeConstraintList ktTypeConstraintList = templateClass2.getTypeConstraintList();
        if (ktTypeConstraintList == null) {
            Intrinsics.throwNpe();
        }
        KtTypeConstraintList templateConstraintList = ktTypeConstraintList;
        Object t = this.getElement();
        KtTypeParameterListOwner ktTypeParameterListOwner = (KtTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtTypeParameterListOwner.class, (boolean)true);
        if (ktTypeParameterListOwner == null) {
            return;
        }
        KtTypeParameterListOwner declaration = ktTypeParameterListOwner;
        KtTypeConstraintList ktTypeConstraintList2 = declaration.getTypeConstraintList();
        if (ktTypeConstraintList2 == null) {
            return;
        }
        KtTypeConstraintList constraintList = ktTypeConstraintList2;
        constraintList.addAfter(psiFactory.createComma(), null);
        constraintList.addAfter((PsiElement)templateConstraintList.getConstraints().get(0), null);
        KtTypeReference ktTypeReference = ((KtTypeParameter)this.getElement()).getExtendsBound();
        if (ktTypeReference != null) {
            ktTypeReference.delete();
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        if ((aSTNode = (colon = ((KtTypeParameter)this.getElement()).getNode().findChildByType((IElementType)KtTokens.COLON))) != null && (aSTNode = aSTNode.getPsi()) != null) {
            aSTNode.delete();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public MoveTypeParameterConstraintFix(@NotNull KtTypeParameter element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super((PsiElement)element2);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MoveTypeParameterConstraintFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            if (!(psiElement instanceof KtTypeParameter)) {
                psiElement = null;
            }
            KtTypeParameter ktTypeParameter = (KtTypeParameter)psiElement;
            if (ktTypeParameter == null) {
                return null;
            }
            KtTypeParameter typeParameter = ktTypeParameter;
            return new MoveTypeParameterConstraintFix(typeParameter);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

