/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007J\u001e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0011J\u001e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/RawFileMapping;", "", "name", "", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "lastMappedWithNewIndex", "", "lineMappings", "Lgnu/trove/TIntIntHashMap;", "getName", "()Ljava/lang/String;", "getPath", "rangeMappings", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/codegen/inline/RangeMapping;", "couldFoldInRange", "", "first", "second", "initRange", "", "start", "end", "mapLine", "source", "currentIndex", "isLastMapped", "mapNewInterval", "dest", "range", "toFileMapping", "Lorg/jetbrains/kotlin/codegen/inline/FileMapping;", "backend"})
public final class RawFileMapping {
    private final TIntIntHashMap lineMappings;
    private final ArrayList<RangeMapping> rangeMappings;
    private int lastMappedWithNewIndex;
    @NotNull
    private final String name;
    @NotNull
    private final String path;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FileMapping toFileMapping() {
        void var1_1;
        FileMapping $receiver$iv = new FileMapping(this.name, this.path);
        FileMapping $receiver = $receiver$iv;
        Iterator<RangeMapping> iterator2 = this.rangeMappings.iterator();
        while (iterator2.hasNext()) {
            RangeMapping range;
            RangeMapping rangeMapping = range = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)rangeMapping, (String)"range");
            $receiver.addRangeMapping(rangeMapping);
        }
        return (FileMapping)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void initRange(int start, int end) {
        Unit unit;
        int value$iv = this.lineMappings.isEmpty();
        if (_Assertions.ENABLED) {
            if (value$iv == 0) {
                String message$iv = "initRange should only be called for empty mapping";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        value$iv = start;
        int n = end;
        if (value$iv <= n) {
            while (true) {
                void index2;
                this.lineMappings.put((int)index2, (int)index2);
                if (index2 == n) break;
                ++index2;
            }
        }
        this.rangeMappings.add(new RangeMapping(start, start, end - start + 1));
        this.lastMappedWithNewIndex = end;
    }

    /*
     * WARNING - void declaration
     */
    public final int mapLine(int source, int currentIndex, boolean isLastMapped) {
        int dest = this.lineMappings.get(source);
        if (dest == 0) {
            void $receiver$iv;
            Collection collection = this.rangeMappings;
            if (!$receiver$iv.isEmpty() && isLastMapped && this.couldFoldInRange(this.lastMappedWithNewIndex, source)) {
                RangeMapping rangeMapping;
                RangeMapping rangeMapping2 = rangeMapping = (RangeMapping)CollectionsKt.last((List)this.rangeMappings);
                rangeMapping2.setRange(rangeMapping2.getRange() + (source - this.lastMappedWithNewIndex));
                dest = this.lineMappings.get(this.lastMappedWithNewIndex) + source - this.lastMappedWithNewIndex;
            } else {
                dest = currentIndex + 1;
                RangeMapping rangeMapping = new RangeMapping(source, dest, 0, 4, null);
                this.rangeMappings.add(rangeMapping);
            }
            this.lineMappings.put(source, dest);
            this.lastMappedWithNewIndex = source;
        }
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public final void mapNewInterval(int source, int dest, int range) {
        void $receiver$iv;
        RangeMapping rangeMapping = new RangeMapping(source, dest, range);
        this.rangeMappings.add(rangeMapping);
        Iterable iterable = (Iterable)new IntRange(source, source + range - 1);
        for (Object element$iv : $receiver$iv) {
            int it = ((Number)element$iv).intValue();
            this.lineMappings.put(source, dest);
        }
    }

    private final boolean couldFoldInRange(int first, int second) {
        int delta = second - first;
        return delta > 0 && delta <= 10;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public RawFileMapping(@NotNull String name2, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.name = name2;
        this.path = path;
        this.lineMappings = new TIntIntHashMap();
        this.rangeMappings = CollectionsKt.arrayListOf((Object[])new RangeMapping[0]);
        this.lastMappedWithNewIndex = -1000;
    }
}

