/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.eclipse.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.eclipse.model.JpsEclipseClasspathReader;
import org.jetbrains.jps.eclipse.model.JpsIdeaSpecificSettings;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.module.JpsModuleClasspathSerializer;

public class JpsEclipseClasspathSerializer
extends JpsModuleClasspathSerializer {
    @NonNls
    public static final String CLASSPATH_STORAGE_ID = "eclipse";
    private static final Logger LOG = Logger.getInstance(JpsEclipseClasspathSerializer.class);

    public JpsEclipseClasspathSerializer() {
        super(CLASSPATH_STORAGE_ID);
    }

    public void loadClasspath(@NotNull JpsModule module, @Nullable String classpathDir, @NotNull String baseModulePath, JpsMacroExpander expander, List<String> paths, JpsSdkType<?> projectSdkType) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/eclipse/model/JpsEclipseClasspathSerializer", "loadClasspath"));
        }
        if (baseModulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseModulePath", "org/jetbrains/jps/eclipse/model/JpsEclipseClasspathSerializer", "loadClasspath"));
        }
        JpsDependenciesList dependenciesList = module.getDependenciesList();
        dependenciesList.clear();
        try {
            JpsIdeaSpecificSettings settings;
            Element root;
            File classpathFile;
            if (classpathDir == null) {
                classpathDir = baseModulePath;
            }
            if (!(classpathFile = new File(classpathDir, ".classpath")).exists()) {
                return;
            }
            String eml = module.getName() + ".eml";
            File emlFile = new File(baseModulePath, eml);
            HashMap<String, String> levels = new HashMap<String, String>();
            if (emlFile.isFile()) {
                Document emlDocument = JDOMUtil.loadDocument((File)emlFile);
                root = emlDocument.getRootElement();
                settings = new JpsIdeaSpecificSettings(expander);
                settings.initLevels(root, module, levels);
            } else {
                settings = null;
                root = null;
            }
            Document document = JDOMUtil.loadDocument((File)classpathFile);
            JpsEclipseClasspathReader reader = new JpsEclipseClasspathReader(classpathDir, paths, (Set<String>)new HashSet(), levels);
            reader.readClasspath(module, null, document.getRootElement(), expander);
            if (settings != null) {
                settings.updateEntries(root, module, projectSdkType);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

