/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.DefaultWebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.NettyKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerPathHandler;", "Lorg/jetbrains/builtInWebServer/WebServerPathHandler;", "()V", "process", "", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectName", "decodedRawPath", "isCustomHost", "built-in-server"})
final class DefaultWebServerPathHandler
extends WebServerPathHandler {
    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(@NotNull String path, @NotNull Project project2, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @NotNull String projectName, @NotNull String decodedRawPath, boolean isCustomHost) {
        Matcher matcher;
        void pathInfo;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)decodedRawPath, (String)"decodedRawPath");
        Channel channel = context.channel();
        boolean isSignedRequest = BuiltInWebServerKt.isSignedRequest((HttpRequest)request);
        HttpRequest httpRequest = (HttpRequest)request;
        Channel channel2 = channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"channel");
        HttpHeaders httpHeaders = BuiltInWebServerKt.validateToken(httpRequest, channel2, isSignedRequest);
        if (httpHeaders == null) {
            return true;
        }
        HttpHeaders extraHeaders = httpHeaders;
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = (PathInfo)pathToFileManager.getPathToInfoCache().getIfPresent((Object)path);
        if ((PathInfo)pathInfo.element == null || !((PathInfo)pathInfo.element).isValid()) {
            pathInfo.element = pathToFileManager.doFindByRelativePath$built_in_server(path);
            if ((PathInfo)pathInfo.element == null) {
                Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, null, (HttpRequest)request, extraHeaders);
                return true;
            }
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)((PathInfo)pathInfo.element));
        }
        boolean indexUsed = false;
        if (((PathInfo)pathInfo.element).isDirectory()) {
            VirtualFile indexVirtualFile = null;
            File indexFile = null;
            if (((PathInfo)pathInfo.element).getFile() == null) {
                File file2 = ((PathInfo)pathInfo.element).getIoFile();
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                indexFile = BuiltInWebServerKt.findIndexFile(file2);
            } else {
                VirtualFile virtualFile = ((PathInfo)pathInfo.element).getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                indexVirtualFile = BuiltInWebServerKt.findIndexFile(virtualFile);
            }
            if (indexFile == null && indexVirtualFile == null) {
                Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, null, (HttpRequest)request, extraHeaders);
                return true;
            }
            if (!FileUtilKt.endsWithSlash(decodedRawPath)) {
                HttpRequest httpRequest2 = (HttpRequest)request;
                Channel channel3 = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)channel3, (String)"channel");
                WebServerPathHandlerKt.redirectToDirectory(httpRequest2, channel3, isCustomHost ? path : projectName + "/" + path, extraHeaders);
                return true;
            }
            indexUsed = true;
            pathInfo.element = new PathInfo(indexFile, indexVirtualFile, ((PathInfo)pathInfo.element).getRoot(), ((PathInfo)pathInfo.element).getModuleName(), ((PathInfo)pathInfo.element).isLibrary());
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)((PathInfo)pathInfo.element));
        }
        String userAgent = NettyKt.getUserAgent((HttpRequest)request);
        if (!isSignedRequest && userAgent != null && NettyKt.isRegularBrowser((HttpRequest)request) && NettyKt.getOrigin((HttpRequest)request) == null && NettyKt.getReferrer((HttpRequest)request) == null && (matcher = DefaultWebServerPathHandlerKt.access$getChromeVersionFromUserAgent$p().matcher(userAgent)).find() && StringUtil.compareVersionNumbers((String)matcher.group(1), (String)"51") < 0 && !DefaultWebServerPathHandlerKt.access$canBeAccessedDirectly(((PathInfo)pathInfo.element).getName())) {
            Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, (HttpRequest)request);
            return true;
        }
        if (!indexUsed && !FileUtilKt.endsWithName(path, ((PathInfo)pathInfo.element).getName())) {
            if (FileUtilKt.endsWithSlash(decodedRawPath)) {
                indexUsed = true;
            } else {
                String parentPath = FileUtilKt.getParentPath(((PathInfo)pathInfo.element).getPath());
                if (parentPath != null) {
                    String string = PathUtilRt.getFileName((String)parentPath);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getFileName(parentPath)");
                    if (FileUtilKt.endsWithName(path, string)) {
                        HttpRequest httpRequest3 = (HttpRequest)request;
                        Channel channel4 = channel;
                        Intrinsics.checkExpressionValueIsNotNull((Object)channel4, (String)"channel");
                        WebServerPathHandlerKt.redirectToDirectory(httpRequest3, channel4, isCustomHost ? path : projectName + "/" + path, extraHeaders);
                        return true;
                    }
                }
            }
        }
        PathInfo pathInfo2 = (PathInfo)pathInfo.element;
        Channel channel5 = channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)channel5, (String)"channel");
        if (!DefaultWebServerPathHandlerKt.access$checkAccess(pathInfo2, channel5, (HttpRequest)request)) {
            return true;
        }
        String canonicalPath = indexUsed ? path + "/" + ((PathInfo)pathInfo.element).getName() : path;
        WebServerFileHandler[] webServerFileHandlerArray = (WebServerFileHandler[])WebServerFileHandler.Companion.getEP_NAME$built_in_server().getExtensions();
        for (int i = 0; i < webServerFileHandlerArray.length; ++i) {
            WebServerFileHandler fileHandler = webServerFileHandlerArray[i];
            Logger logger = BuiltInWebServerKt.getLOG();
            try {
                PathInfo pathInfo3 = (PathInfo)pathInfo.element;
                if (pathInfo3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pathInfo3, (String)"pathInfo!!");
                CharSequence charSequence = canonicalPath;
                Channel channel6 = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)channel6, (String)"channel");
                if (!fileHandler.process(pathInfo3, charSequence, project2, request, channel6, isCustomHost ? (String)null : projectName, extraHeaders)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
                continue;
            }
            catch (Throwable e$iv) {
                void $receiver$iv;
                $receiver$iv.error(e$iv);
            }
        }
        Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, null, (HttpRequest)request, extraHeaders);
        return true;
    }
}

