/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleCheckedLockingInspection
extends BaseInspection {
    public boolean ignoreOnVolatileVariables = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.checked.locking.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/DoubleCheckedLockingInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("double.checked.locking.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/DoubleCheckedLockingInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("double.checked.locking.ignore.on.volatiles.option", new Object[0]), (InspectionProfileEntry)this, "ignoreOnVolatileVariables");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        if (field == null) {
            return null;
        }
        return new DoubleCheckedLockingFix(field);
    }

    @Nullable
    private static PsiField findCheckedField(PsiExpression expression) {
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return null;
            }
            return (PsiField)target;
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.EQEQ.equals(tokenType) && !JavaTokenType.NE.equals(tokenType)) {
                return null;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            PsiField field = DoubleCheckedLockingInspection.findCheckedField(lhs);
            if (field != null) {
                return field;
            }
            return DoubleCheckedLockingInspection.findCheckedField(rhs);
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.EXCL.equals(tokenType)) {
                return null;
            }
            return DoubleCheckedLockingInspection.findCheckedField(prefixExpression.getOperand());
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleCheckedLockingVisitor();
    }

    private class DoubleCheckedLockingVisitor
    extends BaseInspectionVisitor {
        private DoubleCheckedLockingVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement2) {
            PsiField field;
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/DoubleCheckedLockingInspection$DoubleCheckedLockingVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(statement2);
            PsiExpression outerCondition = statement2.getCondition();
            if (outerCondition == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(outerCondition)) {
                return;
            }
            PsiStatement thenBranch = statement2.getThenBranch();
            if (!((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) instanceof PsiSynchronizedStatement)) {
                return;
            }
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)thenBranch;
            PsiCodeBlock body = synchronizedStatement.getBody();
            PsiStatement firstStatement = ControlFlowUtils.getOnlyStatementInBlock(body);
            if (!(firstStatement instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement innerIf = (PsiIfStatement)firstStatement;
            PsiExpression innerCondition = innerIf.getCondition();
            if (!EquivalenceChecker.expressionsAreEquivalent(innerCondition, outerCondition)) {
                return;
            }
            if (DoubleCheckedLockingInspection.this.ignoreOnVolatileVariables) {
                field = DoubleCheckedLockingInspection.findCheckedField(innerCondition);
                if (field != null && field.hasModifierProperty("volatile")) {
                    return;
                }
            } else {
                field = null;
            }
            this.registerStatementError((PsiStatement)statement2, field);
        }
    }

    private static class DoubleCheckedLockingFix
    extends InspectionGadgetsFix {
        private final String myFieldName;

        private DoubleCheckedLockingFix(PsiField field) {
            this.myFieldName = field.getName();
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("double.checked.locking.quickfix", this.myFieldName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/DoubleCheckedLockingInspection$DoubleCheckedLockingFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Make field volatile" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/DoubleCheckedLockingInspection$DoubleCheckedLockingFix", "getFamilyName"));
            }
            return "Make field volatile";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiField field = DoubleCheckedLockingInspection.findCheckedField(condition);
            if (field == null) {
                return;
            }
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.setModifierProperty("volatile", true);
        }
    }
}

