/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class MakeClassFinalFix
extends InspectionGadgetsFix {
    private final String className;

    public MakeClassFinalFix(PsiClass aClass) {
        this.className = aClass.getName();
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.class.final.fix.name", this.className);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MakeClassFinalFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Make class final" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MakeClassFinalFix", "getFamilyName"));
        }
        return "Make class final";
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
        boolean conflictsDialogOK;
        PsiElement element = descriptor.getPsiElement();
        final PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (containingClass == null) {
            return;
        }
        final PsiModifierList modifierList = containingClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (!this.isOnTheFly()) {
            if (ClassInheritorsSearch.search((PsiClass)containingClass).findFirst() != null) {
                return;
            }
            modifierList.setModifierProperty("final", true);
            modifierList.setModifierProperty("abstract", false);
            return;
        }
        final MultiMap conflicts = new MultiMap();
        Query search = ClassInheritorsSearch.search((PsiClass)containingClass);
        search.forEach((Processor)new Processor<PsiClass>(){

            public boolean process(PsiClass aClass) {
                conflicts.putValue((Object)containingClass, (Object)InspectionGadgetsBundle.message("0.will.no.longer.be.overridable.by.1", RefactoringUIUtil.getDescription((PsiElement)containingClass, false), RefactoringUIUtil.getDescription((PsiElement)aClass, false)));
                return true;
            }
        });
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(element.getProject(), (MultiMap<PsiElement, String>)conflicts, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            modifierList.setModifierProperty("final", true);
                            modifierList.setModifierProperty("abstract", false);
                        }
                    });
                }
            });
            conflictsDialogOK = conflictsDialog.showAndGet();
        } else {
            conflictsDialogOK = true;
        }
        if (conflictsDialogOK) {
            modifierList.setModifierProperty("final", true);
            modifierList.setModifierProperty("abstract", false);
        }
    }
}

