/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodMatcher;
import java.util.Collections;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class IgnoreResultOfCallInspectionBase
extends BaseInspection {
    public boolean m_reportAllNonLibraryCalls = false;
    protected final MethodMatcher myMethodMatcher = new MethodMatcher(true, "callCheckString").add("java.io.File", ".*").add("java.io.InputStream", "read|skip|available|markSupported").add("java.io.Reader", "read|skip|ready|markSupported").add("java.lang.Boolean", ".*").add("java.lang.Byte", ".*").add("java.lang.Character", ".*").add("java.lang.Double", ".*").add("java.lang.Float", ".*").add("java.lang.Integer", ".*").add("java.lang.Long", ".*").add("java.lang.Math", ".*").add("java.lang.Object", "equals|hashCode|toString").add("java.lang.Short", ".*").add("java.lang.StrictMath", ".*").add("java.lang.String", ".*").add("java.math.BigInteger", ".*").add("java.math.BigDecimal", ".*").add("java.net.InetAddress", ".*").add("java.net.URI", ".*").add("java.util.UUID", ".*").add("java.util.regex.Matcher", "pattern|toMatchResult|start|end|group|groupCount|matches|find|lookingAt|quoteReplacement|replaceAll|replaceFirst|regionStart|regionEnd|hasTransparantBounds|hasAnchoringBounds|hitEnd|requireEnd").add("java.util.regex.Pattern", ".*").finishDefault();

    @NotNull
    public String getID() {
        if ("ResultOfMethodCallIgnored" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "getID"));
        }
        return "ResultOfMethodCallIgnored";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass containingClass = (PsiClass)infos[0];
        String className = containingClass.getName();
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.problem.descriptor", className);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "writeSettings"));
        }
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IgnoreResultOfCallVisitor();
    }

    private class IgnoreResultOfCallVisitor
    extends BaseInspectionVisitor {
        private IgnoreResultOfCallVisitor() {
        }

        public void visitExpressionStatement(@NotNull PsiExpressionStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase$IgnoreResultOfCallVisitor", "visitExpressionStatement"));
            }
            super.visitExpressionStatement(statement2);
            PsiExpression expression = statement2.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            PsiMethod method = call.resolveMethod();
            if (method == null || method.isConstructor()) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (PsiType.VOID.equals((Object)returnType)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)statement2)) {
                return;
            }
            if (IgnoreResultOfCallInspectionBase.this.m_reportAllNonLibraryCalls && !LibraryUtil.classIsInLibrary(aClass)) {
                this.registerMethodCallError(call, aClass);
                return;
            }
            PsiAnnotation anno = ControlFlowAnalyzer.findContractAnnotation(method);
            boolean honorInferred = Registry.is((String)"ide.ignore.call.result.inspection.honor.inferred.pure");
            if (anno != null && (honorInferred || !AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno)) && Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)anno, (String)"pure"))) {
                this.registerMethodCallError(call, aClass);
                return;
            }
            PsiAnnotation anno2 = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton("javax.annotation.CheckReturnValue"));
            if (anno2 != null) {
                this.registerMethodCallError(call, aClass);
            }
            if (!IgnoreResultOfCallInspectionBase.this.myMethodMatcher.matches(method)) {
                return;
            }
            this.registerMethodCallError(call, aClass);
        }
    }
}

