/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerEvaluateActionHandler
extends XDebuggerActionHandler {
    @Override
    protected void perform(final @NotNull XDebugSession session, DataContext dataContext) {
        XValue value;
        String text;
        String selectedText;
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "perform"));
        }
        final XDebuggerEditorsProvider editorsProvider = session.getDebugProcess().getEditorsProvider();
        final XStackFrame stackFrame = session.getCurrentStackFrame();
        final XDebuggerEvaluator evaluator = session.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        EvaluationMode mode = EvaluationMode.EXPRESSION;
        String string = selectedText = editor != null ? editor.getSelectionModel().getSelectedText() : null;
        if (selectedText != null) {
            selectedText = evaluator.formatTextForEvaluation(selectedText);
            mode = evaluator.getEvaluationMode(selectedText, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext));
        }
        if ((text = selectedText) == null && editor != null) {
            text = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, (Project)CommonDataKeys.PROJECT.getData(dataContext), editor);
        }
        final VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (text == null && (value = XDebuggerTreeActionBase.getSelectedValue(dataContext)) != null) {
            value.calculateEvaluationExpression().done((Consumer)new Consumer<XExpression>(){

                public void consume(final XExpression expression) {
                    if (expression != null) {
                        AppUIUtil.invokeOnEdt(new Runnable(){

                            @Override
                            public void run() {
                                XDebuggerEvaluateActionHandler.showDialog(session, file2, editorsProvider, stackFrame, evaluator, expression);
                            }
                        });
                    }
                }
            });
            return;
        }
        XExpressionImpl expression = XExpressionImpl.fromText(StringUtil.notNullize((String)text), mode);
        XDebuggerEvaluateActionHandler.showDialog(session, file2, editorsProvider, stackFrame, evaluator, expression);
    }

    private static void showDialog(@NotNull XDebugSession session, VirtualFile file2, XDebuggerEditorsProvider editorsProvider, XStackFrame stackFrame, XDebuggerEvaluator evaluator, @NotNull XExpression expression) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "showDialog"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "showDialog"));
        }
        if (expression.getLanguage() == null) {
            XSourcePosition position;
            Language language = null;
            if (stackFrame != null && (position = stackFrame.getSourcePosition()) != null) {
                language = LanguageUtil.getFileLanguage((VirtualFile)position.getFile());
            }
            if (language == null && file2 != null) {
                language = LanguageUtil.getFileTypeLanguage((FileType)file2.getFileType());
            }
            expression = new XExpressionImpl(expression.getExpression(), language, expression.getCustomInfo(), expression.getMode());
        }
        new XDebuggerEvaluationDialog(session, editorsProvider, evaluator, expression, stackFrame == null ? null : stackFrame.getSourcePosition()).show();
    }

    @Nullable
    public static String getExpressionText(@Nullable XDebuggerEvaluator evaluator, @Nullable Project project2, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
        }
        if (project2 == null || evaluator == null) {
            return null;
        }
        Document document = editor.getDocument();
        return XDebuggerEvaluateActionHandler.getExpressionText(evaluator.getExpressionInfoAtOffset(project2, document, editor.getCaretModel().getOffset(), true), document);
    }

    @Nullable
    public static String getExpressionText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
        }
        if (expressionInfo == null) {
            return null;
        }
        String text = expressionInfo.getExpressionText();
        return text == null ? document.getText(expressionInfo.getTextRange()) : text;
    }

    @Nullable
    public static String getDisplayText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getDisplayText"));
        }
        if (expressionInfo == null) {
            return null;
        }
        String text = expressionInfo.getDisplayText();
        return text == null ? document.getText(expressionInfo.getTextRange()) : text;
    }

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session, DataContext dataContext) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "isEnabled"));
        }
        return session.getDebugProcess().getEvaluator() != null;
    }
}

