/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BranchPopupBuilder {
    @NotNull
    private final VcsLogDataPack myDataPack;
    @Nullable
    private final Collection<VirtualFile> myVisibleRoots;
    @Nullable
    private final List<List<String>> myRecentItems;

    protected BranchPopupBuilder(@NotNull VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, @Nullable List<List<String>> recentItems) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/filter/BranchPopupBuilder", "<init>"));
        }
        this.myDataPack = dataPack;
        this.myVisibleRoots = visibleRoots;
        this.myRecentItems = recentItems;
    }

    @NotNull
    protected abstract AnAction createAction(@NotNull String var1);

    protected void createRecentAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> recentItem) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/vcs/log/ui/filter/BranchPopupBuilder", "createRecentAction"));
        }
        if (recentItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recentItem", "com/intellij/vcs/log/ui/filter/BranchPopupBuilder", "createRecentAction"));
        }
        assert (this.myRecentItems == null);
    }

    @NotNull
    protected AnAction createCollapsedAction(String actionName) {
        AnAction anAction = this.createAction(actionName);
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchPopupBuilder", "createCollapsedAction"));
        }
        return anAction;
    }

    public ActionGroup build() {
        return this.createActions(BranchPopupBuilder.prepareGroups(this.myDataPack, this.myVisibleRoots, this.myRecentItems));
    }

    private static Groups prepareGroups(@NotNull VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, @Nullable List<List<String>> recentItems) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/filter/BranchPopupBuilder", "prepareGroups"));
        }
        Groups filteredGroups = new Groups();
        Collection allRefs = dataPack.getRefs().getBranches();
        for (Map.Entry entry : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            if (visibleRoots != null && !visibleRoots.contains(root)) continue;
            Collection refs = (Collection)entry.getValue();
            VcsLogProvider provider = (VcsLogProvider)dataPack.getLogProviders().get(root);
            VcsLogRefManager refManager = provider.getReferenceManager();
            List refGroups = refManager.group(refs);
            BranchPopupBuilder.putActionsForReferences(refGroups, filteredGroups);
        }
        if (recentItems != null) {
            for (List list : recentItems) {
                if (list.size() == 1) {
                    final String item = (String)ContainerUtil.getFirstItem((List)list);
                    if (filteredGroups.singletonGroups.contains(item) || ContainerUtil.find(filteredGroups.expandedGroups.values(), (Condition)new Condition<TreeSet<String>>(){

                        public boolean value(TreeSet<String> strings) {
                            return strings.contains(item);
                        }
                    }) != null) continue;
                }
                filteredGroups.recentGroups.add(list);
            }
        }
        return filteredGroups;
    }

    private DefaultActionGroup createActions(@NotNull Groups groups) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/vcs/log/ui/filter/BranchPopupBuilder", "createActions"));
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (String string : groups.singletonGroups) {
            actionGroup.add(this.createAction(string));
        }
        if (!groups.recentGroups.isEmpty()) {
            actionGroup.addSeparator("Recent");
            for (List list : groups.recentGroups) {
                this.createRecentAction(actionGroup, list);
            }
        }
        for (Map.Entry entry : groups.expandedGroups.entrySet()) {
            actionGroup.addSeparator((String)entry.getKey());
            for (String actionName : (TreeSet)entry.getValue()) {
                actionGroup.add(this.createAction(actionName));
            }
        }
        actionGroup.addSeparator();
        for (Map.Entry entry : groups.collapsedGroups.entrySet()) {
            DefaultActionGroup popupGroup = new DefaultActionGroup((String)entry.getKey(), true);
            for (String actionName : (TreeSet)entry.getValue()) {
                popupGroup.add(this.createCollapsedAction(actionName));
            }
            actionGroup.add((AnAction)popupGroup);
        }
        return actionGroup;
    }

    private static void putActionsForReferences(List<RefGroup> references, Groups actions) {
        for (RefGroup refGroup : references) {
            if (refGroup instanceof SingletonRefGroup) {
                String name = refGroup.getName();
                if (actions.singletonGroups.contains(name)) continue;
                actions.singletonGroups.add(name);
                continue;
            }
            if (refGroup.isExpanded()) {
                BranchPopupBuilder.addToGroup(refGroup, actions.expandedGroups);
                continue;
            }
            BranchPopupBuilder.addToGroup(refGroup, actions.collapsedGroups);
        }
    }

    private static void addToGroup(RefGroup refGroup, TreeMap<String, TreeSet<String>> groupToAdd) {
        TreeSet<String> existingGroup = groupToAdd.get(refGroup.getName());
        TreeSet<String> actions = new TreeSet<String>();
        for (VcsRef ref : refGroup.getRefs()) {
            actions.add(ref.getName());
        }
        if (existingGroup == null) {
            groupToAdd.put(refGroup.getName(), actions);
        } else {
            for (String action : actions) {
                existingGroup.add(action);
            }
        }
    }

    private static class Groups {
        private final TreeSet<String> singletonGroups = ContainerUtil.newTreeSet();
        private final List<List<String>> recentGroups = ContainerUtil.newArrayList();
        private final TreeMap<String, TreeSet<String>> expandedGroups = ContainerUtil.newTreeMap();
        private final TreeMap<String, TreeSet<String>> collapsedGroups = ContainerUtil.newTreeMap();

        private Groups() {
        }
    }
}

