/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.FullIntList;
import com.intellij.vcs.log.graph.utils.impl.SmartDeltaCompressor;
import org.jetbrains.annotations.NotNull;

public class CompressedIntList
implements IntList {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    private final int myBlockSize;
    @NotNull
    private final int[] myStrongValues;
    @NotNull
    private final IntList myCompressedDeltas;

    @NotNull
    public static IntList newInstance(int[] delegateArray) {
        IntList intList = CompressedIntList.newInstance(delegateArray, 30);
        if (intList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/CompressedIntList", "newInstance"));
        }
        return intList;
    }

    @NotNull
    public static IntList newInstance(final int[] delegateArray, int blockSize) {
        IntList intList = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return delegateArray.length;
            }

            @Override
            public int get(int index) {
                return delegateArray[index];
            }
        }, blockSize);
        if (intList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/CompressedIntList", "newInstance"));
        }
        return intList;
    }

    @NotNull
    public static IntList newInstance(final IntList delegateList, final int blockSize) {
        if (blockSize < 1) {
            throw new IllegalArgumentException("Unsupported blockSize:" + blockSize);
        }
        if (delegateList.size() == 0) {
            FullIntList fullIntList = new FullIntList(new int[0]);
            if (fullIntList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/CompressedIntList", "newInstance"));
            }
            return fullIntList;
        }
        SmartDeltaCompressor intDeltaCompressor = SmartDeltaCompressor.newInstance(new IntList(){

            @Override
            public int size() {
                return delegateList.size();
            }

            @Override
            public int get(int index) {
                return delegateList.get(index) - delegateList.get(index - index % blockSize);
            }
        });
        int[] strongValues = new int[(delegateList.size() - 1) / blockSize + 1];
        for (int i = 0; i < strongValues.length; ++i) {
            strongValues[i] = delegateList.get(i * blockSize);
        }
        CompressedIntList compressedIntList = new CompressedIntList(blockSize, strongValues, intDeltaCompressor);
        if (compressedIntList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/CompressedIntList", "newInstance"));
        }
        return compressedIntList;
    }

    private CompressedIntList(int blockSize, @NotNull int[] strongValues, @NotNull IntList compressedDeltas) {
        if (strongValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strongValues", "com/intellij/vcs/log/graph/utils/impl/CompressedIntList", "<init>"));
        }
        if (compressedDeltas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compressedDeltas", "com/intellij/vcs/log/graph/utils/impl/CompressedIntList", "<init>"));
        }
        this.myBlockSize = blockSize;
        this.myStrongValues = strongValues;
        this.myCompressedDeltas = compressedDeltas;
    }

    @Override
    public int size() {
        return this.myCompressedDeltas.size();
    }

    @Override
    public int get(int index) {
        int strongIndex = index / this.myBlockSize;
        return this.myStrongValues[strongIndex] + this.myCompressedDeltas.get(index);
    }
}

