/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Consumer;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class MergingBackgroundExecutor<T> {
    private final Consumer<T> myConsumer;
    private final BoundedTaskExecutor myExecutorService;

    public MergingBackgroundExecutor(int maxThreads, @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/MergingBackgroundExecutor", "<init>"));
        }
        this.myConsumer = consumer;
        this.myExecutorService = new BoundedTaskExecutor((Executor)PooledThreadExecutor.INSTANCE, maxThreads);
    }

    public void queue(final @NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/MergingBackgroundExecutor", "queue"));
        }
        this.myExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                MergingBackgroundExecutor.this.myConsumer.consume(t);
            }
        });
    }

    @NotNull
    public static MergingBackgroundExecutor<Runnable> newRunnableExecutor(int maxThreads) {
        MergingBackgroundExecutor<Runnable> mergingBackgroundExecutor = new MergingBackgroundExecutor<Runnable>(maxThreads, new Consumer<Runnable>(){

            public void consume(Runnable runnable2) {
                runnable2.run();
            }
        });
        if (mergingBackgroundExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/MergingBackgroundExecutor", "newRunnableExecutor"));
        }
        return mergingBackgroundExecutor;
    }
}

