/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;

public class ContentManagerUtil {
    private ContentManagerUtil() {
    }

    public static ContentManager getContentManagerFromContext(DataContext dataContext, boolean requiresVisibleToolWindow) {
        ToolWindowEx toolWindow;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return null;
        }
        ToolWindowManagerEx mgr = ToolWindowManagerEx.getInstanceEx(project2);
        String id = mgr.getActiveToolWindowId();
        if (id == null && mgr.isEditorComponentActive()) {
            id = mgr.getLastActiveToolWindowId();
        }
        ToolWindowEx toolWindowEx = toolWindow = id != null ? (ToolWindowEx)mgr.getToolWindow(id) : null;
        if (requiresVisibleToolWindow && (toolWindow == null || !toolWindow.isVisible())) {
            return null;
        }
        ContentManager fromToolWindow = toolWindow != null ? toolWindow.getContentManager() : null;
        ContentManager fromContext = (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData(dataContext);
        return (ContentManager)ObjectUtils.chooseNotNull((Object)fromContext, (Object)fromToolWindow);
    }
}

