/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.Nullable;

public class JavaReferenceEditorUtil {
    private JavaReferenceEditorUtil() {
    }

    public static ReferenceEditorWithBrowseButton createReferenceEditorWithBrowseButton(ActionListener browseActionListener, String text, final Project project2, final boolean toAcceptClasses) {
        return new ReferenceEditorWithBrowseButton(browseActionListener, project2, (Function<String, Document>)new NullableFunction<String, Document>(){

            public Document fun(String s) {
                return JavaReferenceEditorUtil.createDocument(s, project2, toAcceptClasses);
            }
        }, text);
    }

    @Nullable
    public static Document createDocument(String text, Project project2, boolean isClassesAccepted) {
        return JavaReferenceEditorUtil.createDocument(text, project2, isClassesAccepted, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
    }

    @Nullable
    public static Document createDocument(String text, Project project2, boolean isClassesAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project2).findPackage("");
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project2);
        PsiJavaCodeReferenceCodeFragment fragment = factory.createReferenceCodeFragment(text, (PsiElement)defaultPackage, true, isClassesAccepted);
        fragment.setVisibilityChecker(visibilityChecker);
        return PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)fragment);
    }

    @Nullable
    public static Document createTypeDocument(String text, Project project2) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project2).findPackage("");
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project2);
        PsiTypeCodeFragment fragment = factory.createTypeCodeFragment(text, (PsiElement)defaultPackage, true);
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        return PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)fragment);
    }
}

