/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TempDirectory
extends TemporaryFolder {
    private String myName = null;
    private File myRoot = null;

    public Statement apply(Statement base, Description description) {
        this.myName = FileUtil.sanitizeFileName((String)description.getMethodName(), (boolean)false);
        return super.apply(base, description);
    }

    protected void before() throws IOException {
        if (this.myName == null) {
            throw new IllegalStateException("apply() was not called");
        }
        File dir = File.createTempFile("unitTest_" + this.myName + "_", "");
        Assert.assertTrue((String)("Cannot delete: " + dir.getPath()), (dir.delete() || !dir.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Cannot create: " + dir.getPath()), (dir.mkdir() || dir.isDirectory() ? 1 : 0) != 0);
        this.myRoot = dir.getCanonicalFile();
    }

    protected void after() {
        if (this.myRoot == null) {
            throw new IllegalStateException("before() was not called");
        }
        FileUtil.delete((File)this.myRoot);
        this.myRoot = null;
        this.myName = null;
    }

    public File getRoot() {
        if (this.myRoot == null) {
            throw new IllegalStateException("before() was not called");
        }
        return this.myRoot;
    }
}

