/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class StructuralSearchUsageTarget
implements ConfigurableUsageTarget,
ItemPresentation {
    private final Configuration myConfiguration;
    private final Runnable mySearchStarter;
    private final SearchContext mySearchContext;

    StructuralSearchUsageTarget(Configuration configuration, SearchContext searchContext, Runnable searchStarter) {
        this.myConfiguration = configuration;
        this.mySearchStarter = searchStarter;
        this.mySearchContext = searchContext;
    }

    @NotNull
    public String getPresentableText() {
        String string = this.myConfiguration.getMatchOptions().getSearchPattern();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/StructuralSearchUsageTarget", "getPresentableText"));
        }
        return string;
    }

    public String getLocationString() {
        return "Do Not Know Where";
    }

    public Icon getIcon(boolean open2) {
        return null;
    }

    public void findUsages() {
        this.mySearchStarter.run();
    }

    public void findUsagesInEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/structuralsearch/plugin/ui/StructuralSearchUsageTarget", "findUsagesInEditor"));
        }
        throw new UnsupportedOperationException();
    }

    public void highlightUsages(@NotNull PsiFile file2, @NotNull Editor editor, boolean clearHighlights) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/structuralsearch/plugin/ui/StructuralSearchUsageTarget", "highlightUsages"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/structuralsearch/plugin/ui/StructuralSearchUsageTarget", "highlightUsages"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean isValid() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public VirtualFile[] getFiles() {
        return null;
    }

    public void update() {
    }

    public String getName() {
        return "my name";
    }

    public ItemPresentation getPresentation() {
        return this;
    }

    public void navigate(boolean requestFocus) {
        throw new UnsupportedOperationException();
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public void showSettings() {
        UIUtil.invokeAction(this.myConfiguration, this.mySearchContext);
    }

    public KeyboardShortcut getShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(this.myConfiguration instanceof ReplaceConfiguration ? "StructuralSearchPlugin.StructuralReplaceAction" : "StructuralSearchPlugin.StructuralSearchAction");
    }

    @NotNull
    public String getLongDescriptiveName() {
        String result;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        String pattern = matchOptions.getSearchPattern();
        String scope = matchOptions.getScope().getDisplayName();
        if (this.myConfiguration instanceof ReplaceConfiguration) {
            ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)this.myConfiguration;
            String replacement = replaceConfiguration.getOptions().getReplacement();
            result = SSRBundle.message("replace.occurrences.of.0.with.1.in.2", pattern, replacement, scope);
        } else {
            result = SSRBundle.message("occurrences.of.0.in.1", pattern, scope);
        }
        String string = StringUtil.shortenTextWithEllipsis((String)result, (int)150, (int)0, (boolean)true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/StructuralSearchUsageTarget", "getLongDescriptiveName"));
        }
        return string;
    }
}

