/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkCredentialsBuilder {
    private String myInterpreterPath = null;
    private String myHelpersPath = null;
    private RemoteCredentials myRemoteCredentials = null;
    private String myHelpersDefaultDirName = ".idea_helpers";

    public RemoteSdkCredentials build() {
        RemoteSdkCredentialsHolder result = new RemoteSdkCredentialsHolder(this.myHelpersDefaultDirName);
        if (this.myRemoteCredentials != null) {
            RemoteSdkCredentialsBuilder.copyCredentials(this.myRemoteCredentials, result);
        }
        if (this.myInterpreterPath != null) {
            result.setInterpreterPath(this.myInterpreterPath);
        }
        if (this.myHelpersPath != null) {
            result.setHelpersPath(this.myHelpersPath);
        }
        return result;
    }

    public static void copyRemoteSdkCredentials(@NotNull RemoteSdkCredentials data, @NotNull RemoteSdkCredentials copyTo) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/remote/RemoteSdkCredentialsBuilder", "copyRemoteSdkCredentials"));
        }
        if (copyTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyTo", "com/intellij/remote/RemoteSdkCredentialsBuilder", "copyRemoteSdkCredentials"));
        }
        RemoteSdkCredentialsBuilder.copyCredentials(data, copyTo);
        copyTo.setInterpreterPath(data.getInterpreterPath());
        copyTo.setHelpersPath(data.getHelpersPath());
        copyTo.setHelpersVersionChecked(data.isHelpersVersionChecked());
        copyTo.setRemoteRoots(data.getRemoteRoots());
    }

    public static void copyCredentials(@NotNull RemoteCredentials data, @NotNull MutableRemoteCredentials copyTo) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/remote/RemoteSdkCredentialsBuilder", "copyCredentials"));
        }
        if (copyTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyTo", "com/intellij/remote/RemoteSdkCredentialsBuilder", "copyCredentials"));
        }
        copyTo.setHost(data.getHost());
        copyTo.setLiteralPort(data.getLiteralPort());
        copyTo.setAnonymous(data.isAnonymous());
        copyTo.setUserName(data.getUserName());
        copyTo.setPassword(data.getPassword());
        copyTo.setPrivateKeyFile(data.getPrivateKeyFile());
        copyTo.setKnownHostsFile(data.getKnownHostsFile());
        copyTo.setPassphrase(data.getPassphrase());
        copyTo.setUseKeyPair(data.isUseKeyPair());
        copyTo.setStorePassword(data.isStorePassword());
        copyTo.setStorePassphrase(data.isStorePassphrase());
    }

    public RemoteSdkCredentialsBuilder withCredentials(@Nullable RemoteCredentials remoteCredentials) {
        this.myRemoteCredentials = remoteCredentials;
        return this;
    }

    public RemoteSdkCredentialsBuilder withInterpreterPath(String interpreterPath) {
        this.myInterpreterPath = interpreterPath;
        return this;
    }
}

