/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.occurrences;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurrences.OccurrenceFilter;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import java.util.ArrayList;

public abstract class BaseOccurrenceManager
implements OccurrenceManager {
    private PsiExpression[] myOccurrences = null;
    private PsiElement myAnchorStatement = null;
    protected final OccurrenceFilter myFilter;

    public BaseOccurrenceManager(OccurrenceFilter filter) {
        this.myFilter = filter;
    }

    @Override
    public PsiExpression[] getOccurrences() {
        if (this.myOccurrences == null) {
            this.myOccurrences = this.findOccurrences();
            if (this.myFilter != null) {
                ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
                for (PsiExpression occurrence : this.myOccurrences) {
                    if (!this.myFilter.isOK(occurrence)) continue;
                    result.add(occurrence);
                }
                this.myOccurrences = result.isEmpty() ? this.defaultOccurrences() : result.toArray(new PsiExpression[result.size()]);
            }
            if (this.getAnchorStatementForAll() == null) {
                this.myOccurrences = this.defaultOccurrences();
            }
        }
        return this.myOccurrences;
    }

    protected abstract PsiExpression[] defaultOccurrences();

    protected abstract PsiExpression[] findOccurrences();

    @Override
    public boolean isInFinalContext() {
        return BaseOccurrenceManager.needToDeclareFinal(this.myOccurrences);
    }

    @Override
    public PsiElement getAnchorStatementForAll() {
        if (this.myAnchorStatement == null) {
            this.myAnchorStatement = this.getAnchorStatementForAllInScope(null);
        }
        return this.myAnchorStatement;
    }

    @Override
    public PsiElement getAnchorStatementForAllInScope(PsiElement scope) {
        return RefactoringUtil.getAnchorElementForMultipleExpressions(this.myOccurrences, scope);
    }

    private static boolean needToDeclareFinal(PsiExpression[] occurrences) {
        Object scopeToDeclare = null;
        for (PsiExpression occurrence : occurrences) {
            PsiElement data = (PsiElement)occurrence.getUserData(ElementToWorkOn.PARENT);
            scopeToDeclare = scopeToDeclare == null ? (data != null ? data : occurrence) : PsiTreeUtil.findCommonParent((PsiElement)scopeToDeclare, (PsiElement)(data != null ? data : occurrence));
        }
        if (scopeToDeclare == null) {
            return false;
        }
        for (PsiExpression occurrence : occurrences) {
            PsiElement parent = (PsiElement)occurrence.getUserData(ElementToWorkOn.PARENT);
            if (parent == null) {
                parent = occurrence;
            }
            while (!parent.equals(scopeToDeclare)) {
                if (!((parent = parent.getParent()) instanceof PsiClass)) continue;
                return true;
            }
        }
        return false;
    }
}

