/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.extractMethod.ExtractMethodHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.method.title");

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "invoke"));
        }
        if (dataContext != null) {
            PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (file2 != null && editor != null) {
                ExtractMethodHandler.invokeOnElements(project2, editor, file2, elements);
            }
        }
    }

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "invoke"));
        }
        Pass<PsiElement[]> callback = new Pass<PsiElement[]>(){

            public void pass(PsiElement[] selectedValue) {
                ExtractMethodHandler.invokeOnElements(project2, editor, file2, selectedValue);
            }
        };
        ExtractMethodHandler.selectAndPass(project2, editor, file2, callback);
    }

    public static void selectAndPass(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, final @NotNull Pass<PsiElement[]> callback) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "selectAndPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "selectAndPass"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "selectAndPass"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "selectAndPass"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (!editor.getSelectionModel().hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            List<PsiExpression> expressions = IntroduceVariableBase.collectExpressions(file2, editor, offset, true);
            if (expressions.isEmpty()) {
                editor.getSelectionModel().selectLineAtCaret();
            } else {
                if (expressions.size() == 1) {
                    callback.pass((Object)new PsiElement[]{(PsiElement)expressions.get(0)});
                    return;
                }
                IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PsiExpression>(){

                    public void pass(PsiExpression psiExpression) {
                        callback.pass((Object)new PsiElement[]{psiExpression});
                    }
                }, new PsiExpressionTrimRenderer.RenderFunction());
                return;
            }
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        callback.pass((Object)ExtractMethodHandler.getElements(project2, editor, file2));
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "isAvailableForQuickList"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "isAvailableForQuickList"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "isAvailableForQuickList"));
        }
        PsiElement[] elements = ExtractMethodHandler.getElements(file2.getProject(), editor, file2);
        return elements != null && elements.length > 0;
    }

    public static PsiElement[] getElements(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "getElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "getElements"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "getElements"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement[] elements;
            int endOffset;
            int startOffset = selectionModel.getSelectionStart();
            PsiExpression expr = CodeInsightUtil.findExpressionInRange(file2, startOffset, endOffset = selectionModel.getSelectionEnd());
            if (expr != null) {
                elements = new PsiElement[]{expr};
            } else {
                PsiType originalType;
                PsiExpression expression;
                elements = CodeInsightUtil.findStatementsInRange(file2, startOffset, endOffset);
                if (elements.length == 0 && (expression = IntroduceVariableBase.getSelectedExpression(project2, file2, startOffset, endOffset)) != null && IntroduceVariableBase.getErrorMessage(expression) == null && (originalType = RefactoringUtil.getTypeByExpressionWithExpectedType(expression)) != null) {
                    elements = new PsiElement[]{expression};
                }
            }
            return elements;
        }
        List<PsiExpression> expressions = IntroduceVariableBase.collectExpressions(file2, editor, editor.getCaretModel().getOffset());
        return expressions.toArray(new PsiElement[expressions.size()]);
    }

    private static void invokeOnElements(final Project project2, final Editor editor, PsiFile file2, PsiElement[] elements) {
        ExtractMethodHandler.getProcessor(elements, project2, file2, editor, true, new Pass<ExtractMethodProcessor>(){

            public void pass(ExtractMethodProcessor processor2) {
                ExtractMethodHandler.invokeOnElements(project2, editor, processor2, true);
            }
        });
    }

    private static boolean invokeOnElements(Project project2, Editor editor, @NotNull ExtractMethodProcessor processor2, boolean directTypes) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "invokeOnElements"));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)processor2.getTargetClass().getContainingFile())) {
            return false;
        }
        if (processor2.showDialog(directTypes)) {
            ExtractMethodHandler.run(project2, editor, processor2);
            DuplicatesImpl.processDuplicates(processor2, project2, editor);
            return true;
        }
        return false;
    }

    public static void run(final @NotNull Project project2, Editor editor, final ExtractMethodProcessor processor2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "run"));
        }
        CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

            @Override
            public void run() {
                PostprocessReformattingAspect.getInstance(project2).postponeFormattingInside(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RefactoringEventData beforeData = new RefactoringEventData();
                            beforeData.addElements(processor2.myElements);
                            ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.extract.method", beforeData);
                            processor2.doRefactoring();
                            RefactoringEventData data = new RefactoringEventData();
                            data.addElement((PsiElement)processor2.getExtractedMethod());
                            ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.extract.method", data);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, REFACTORING_NAME, null);
    }

    @Nullable
    private static ExtractMethodProcessor getProcessor(PsiElement[] elements, Project project2, PsiFile file2, Editor editor, boolean showErrorMessages, @Nullable Pass<ExtractMethodProcessor> pass) {
        if (elements == null || elements.length == 0) {
            if (showErrorMessages) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractMethod");
            }
            return null;
        }
        for (PsiElement element : elements) {
            if (!(element instanceof PsiStatement) || !JavaHighlightUtil.isSuperOrThisCall((PsiStatement)element, true, true)) continue;
            if (showErrorMessages) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.contains.invocation.of.another.class.constructor"));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractMethod");
            }
            return null;
        }
        ExtractMethodProcessor processor2 = new ExtractMethodProcessor(project2, editor, elements, null, REFACTORING_NAME, "", "refactoring.extractMethod");
        processor2.setShowErrorDialogs(showErrorMessages);
        try {
            if (!processor2.prepare(pass)) {
                return null;
            }
        }
        catch (PrepareFailedException e) {
            if (showErrorMessages) {
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)e.getMessage(), (String)REFACTORING_NAME, (String)"refactoring.extractMethod");
                ExtractMethodHandler.highlightPrepareError(e, file2, editor, project2);
            }
            return null;
        }
        return processor2;
    }

    public static void highlightPrepareError(PrepareFailedException e, PsiFile file2, Editor editor, Project project2) {
        if (e.getFile() == file2) {
            TextRange textRange = e.getTextRange();
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
            EditorColorsManager colorsManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, null);
            LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
            editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
            WindowManager.getInstance().getStatusBar(project2).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
        }
    }

    @Nullable
    public static ExtractMethodProcessor getProcessor(Project project2, PsiElement[] elements, PsiFile file2, boolean openEditor) {
        return ExtractMethodHandler.getProcessor(elements, project2, file2, openEditor ? ExtractMethodHandler.openEditor(project2, file2) : null, false, null);
    }

    public static boolean invokeOnElements(Project project2, @NotNull ExtractMethodProcessor processor2, PsiFile file2, boolean directTypes) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/extractMethod/ExtractMethodHandler", "invokeOnElements"));
        }
        return ExtractMethodHandler.invokeOnElements(project2, ExtractMethodHandler.openEditor(project2, file2), processor2, directTypes);
    }

    @Nullable
    private static Editor openEditor(Project project2, PsiFile file2) {
        VirtualFile virtualFile = file2.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project2, virtualFile);
        return FileEditorManager.getInstance((Project)project2).openTextEditor(fileDescriptor, false);
    }
}

