/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.StubHierarchyConnector;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import com.intellij.psi.stubsHierarchy.stubs.ClassDeclaration;
import com.intellij.psi.stubsHierarchy.stubs.Declaration;
import com.intellij.psi.stubsHierarchy.stubs.MemberDeclaration;
import com.intellij.psi.stubsHierarchy.stubs.Unit;
import com.intellij.psi.stubsHierarchy.stubs.UnitInfo;
import java.util.ArrayList;
import java.util.Arrays;

public class StubEnter {
    private NameEnvironment myNameEnvironment;
    private Symbols mySymbols;
    private StubHierarchyConnector myStubHierarchyConnector;
    private ArrayList<Symbol.ClassSymbol> uncompleted = new ArrayList();

    public StubEnter(NameEnvironment nameEnvironment, Symbols symbols) {
        this.myNameEnvironment = nameEnvironment;
        this.mySymbols = symbols;
        this.myStubHierarchyConnector = new StubHierarchyConnector(nameEnvironment, symbols);
    }

    void unitEnter(Unit tree) {
        Symbol.PackageSymbol pkg = tree.myPackageId != null ? this.mySymbols.enterPackage(tree.myPackageId) : this.mySymbols.myRootPackage;
        this.enter(tree.myClasses, tree.myUnitInfo, (Symbol)pkg);
    }

    private void enter(ClassDeclaration[] trees, UnitInfo info, Symbol owner) {
        for (ClassDeclaration tree : trees) {
            this.enter(tree, info, owner);
        }
    }

    private Symbol.ClassSymbol[] enter(Declaration[] trees, UnitInfo info, Symbol owner) {
        Symbol.ClassSymbol[] members = new Symbol.ClassSymbol[trees.length];
        int i = 0;
        for (Declaration tree : trees) {
            Symbol.ClassSymbol member = this.enter(tree, info, owner);
            if (member == null || member.myShortName == 0) continue;
            members[i++] = member;
        }
        members = members.length == 0 ? Symbol.ClassSymbol.EMPTY_ARRAY : Arrays.copyOf(members, i);
        Arrays.sort(members, Symbol.CLASS_SYMBOL_BY_NAME_COMPARATOR);
        return members;
    }

    private Symbol.ClassSymbol enter(Declaration tree, UnitInfo info, Symbol owner) {
        if (tree instanceof ClassDeclaration) {
            return this.classEnter((ClassDeclaration)tree, info, owner);
        }
        if (tree instanceof MemberDeclaration) {
            this.memberEnter((MemberDeclaration)tree, info, owner);
            return null;
        }
        return null;
    }

    private void memberEnter(MemberDeclaration tree, UnitInfo info, Symbol owner) {
        Symbol.MemberSymbol mc = new Symbol.MemberSymbol(owner);
        Symbol.ClassSymbol[] members = this.enter(tree.myDeclarations, info, (Symbol)mc);
        mc.setMembers(members);
    }

    private Symbol.ClassSymbol classEnter(ClassDeclaration tree, UnitInfo info, Symbol owner) {
        int flags = StubEnter.checkFlags(tree.mods, owner);
        if (info.getType() == IndexTree.BYTECODE) {
            flags |= 0x80;
        }
        QualifiedName[] supers = tree.mySupers;
        if ((tree.mods & 0x20) != 0) {
            supers = this.myNameEnvironment.annotation;
        }
        Symbol.ClassSymbol classSymbol = this.mySymbols.enterClass(tree.myClassAnchor, flags, tree.myName, owner, info, supers, this.myStubHierarchyConnector);
        if (this.uncompleted != null) {
            this.uncompleted.add(classSymbol);
        }
        Symbol.ClassSymbol[] members = this.enter(tree.myDeclarations, info, (Symbol)classSymbol);
        classSymbol.setMembers(members);
        return classSymbol;
    }

    public void connect1() {
        for (Symbol.ClassSymbol classSymbol : this.uncompleted) {
            classSymbol.connect();
        }
        this.uncompleted = new ArrayList();
    }

    public void connect2() {
        for (Symbol.ClassSymbol classSymbol : this.uncompleted) {
            classSymbol.connect();
        }
        this.uncompleted = null;
    }

    public static int checkFlags(long flags, Symbol owner) {
        int mask = 0;
        if (owner.isClass() && (owner.myOwner.isPackage() || owner.isStatic()) && (flags & 0x58L) != 0L) {
            mask |= 8;
        }
        return mask;
    }
}

