/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeCopyHandler;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeGenerator;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CharTable;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeUtil {
    public static void encodeInformation(TreeElement element) {
        ChangeUtil.encodeInformation(element, element);
    }

    private static void encodeInformation(TreeElement element, ASTNode original) {
        DebugUtil.startPsiModification(null);
        try {
            ChangeUtil.encodeInformation(element, original, (Map<Object, Object>)new HashMap());
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    private static void encodeInformation(TreeElement element, ASTNode original, Map<Object, Object> state) {
        for (TreeCopyHandler handler2 : (TreeCopyHandler[])Extensions.getExtensions(TreeCopyHandler.EP_NAME)) {
            handler2.encodeInformation(element, original, state);
        }
        if (original instanceof CompositeElement) {
            TreeElement child = element.getFirstChildNode();
            ASTNode child1 = original.getFirstChildNode();
            while (child != null) {
                ChangeUtil.encodeInformation(child, child1, state);
                child = child.getTreeNext();
                child1 = child1.getTreeNext();
            }
        }
    }

    public static TreeElement decodeInformation(TreeElement element) {
        DebugUtil.startPsiModification(null);
        try {
            TreeElement treeElement = ChangeUtil.decodeInformation(element, (Map<Object, Object>)new HashMap());
            return treeElement;
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    private static TreeElement decodeInformation(TreeElement element, Map<Object, Object> state) {
        for (TreeElement child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            child = ChangeUtil.decodeInformation(child, state);
        }
        for (TreeCopyHandler handler2 : (TreeCopyHandler[])Extensions.getExtensions(TreeCopyHandler.EP_NAME)) {
            TreeElement handled = handler2.decodeInformation(element, state);
            if (handled == null) continue;
            return handled;
        }
        return element;
    }

    @NotNull
    public static LeafElement copyLeafWithText(@NotNull LeafElement original, @NotNull String text) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/psi/impl/source/tree/ChangeUtil", "copyLeafWithText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/tree/ChangeUtil", "copyLeafWithText"));
        }
        LeafElement element = ASTFactory.leaf(original.getElementType(), text);
        original.copyCopyableDataTo((UserDataHolderBase)element);
        ChangeUtil.encodeInformation(element, original);
        TreeUtil.clearCaches(element);
        ChangeUtil.saveIndentationToCopy(original, element);
        LeafElement leafElement = element;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/ChangeUtil", "copyLeafWithText"));
        }
        return leafElement;
    }

    public static TreeElement copyElement(@NotNull TreeElement original, CharTable table) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/psi/impl/source/tree/ChangeUtil", "copyElement"));
        }
        CompositeElement treeParent = original.getTreeParent();
        return ChangeUtil.copyElement(original, treeParent == null ? null : treeParent.getPsi(), table);
    }

    public static TreeElement copyElement(TreeElement original, PsiElement context, CharTable table) {
        TreeElement element = (TreeElement)original.clone();
        PsiManagerEx manager = original.getManager();
        DummyHolderFactory.createHolder(manager, element, context, table).getTreeElement();
        ChangeUtil.encodeInformation(element, original);
        TreeUtil.clearCaches(element);
        ChangeUtil.saveIndentationToCopy(original, element);
        return element;
    }

    private static void saveIndentationToCopy(TreeElement original, TreeElement element) {
        if (original == null || element == null || CodeEditUtil.isNodeGenerated(original)) {
            return;
        }
        int indentation = CodeEditUtil.getOldIndentation(original);
        if (indentation < 0) {
            CodeEditUtil.saveWhitespacesInfo(original);
        }
        CodeEditUtil.setOldIndentation(element, CodeEditUtil.getOldIndentation(original));
        if (indentation < 0) {
            CodeEditUtil.setOldIndentation(original, -1);
        }
    }

    public static TreeElement copyToElement(PsiElement original) {
        DummyHolder holder = DummyHolderFactory.createHolder(original.getManager(), null, original.getLanguage());
        FileElement holderElement = holder.getTreeElement();
        TreeElement treeElement = ChangeUtil.generateTreeElement(original, holderElement.getCharTable(), original.getManager());
        holderElement.rawAddChildren(treeElement);
        TreeUtil.clearCaches(holderElement);
        ChangeUtil.saveIndentationToCopy((TreeElement)original.getNode(), treeElement);
        return treeElement;
    }

    @Nullable
    public static TreeElement generateTreeElement(@Nullable PsiElement original, @NotNull CharTable table, @NotNull PsiManager manager) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/psi/impl/source/tree/ChangeUtil", "generateTreeElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/tree/ChangeUtil", "generateTreeElement"));
        }
        if (original == null) {
            return null;
        }
        PsiUtilCore.ensureValid((PsiElement)original);
        if (SourceTreeToPsiMap.hasTreeElement(original)) {
            return ChangeUtil.copyElement((TreeElement)SourceTreeToPsiMap.psiElementToTree(original), table);
        }
        for (TreeGenerator generator : (TreeGenerator[])Extensions.getExtensions(TreeGenerator.EP_NAME)) {
            TreeElement element = generator.generateTreeFor(original, table, manager);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public static void prepareAndRunChangeAction(final ChangeAction action, final TreeElement changedElement) {
        final FileElement changedFile = TreeUtil.getFileElement(changedElement);
        PsiManagerEx manager = changedFile.getManager();
        final PomModel model = PomManager.getModel((Project)manager.getProject());
        final TreeAspect treeAspect = (TreeAspect)model.getModelAspect(TreeAspect.class);
        model.runTransaction((PomTransaction)new PomTransactionBase(changedElement.getPsi(), treeAspect){

            public PomModelEvent runInner() {
                PomModelEvent event = new PomModelEvent(model);
                TreeChangeEventImpl destinationTreeChange = new TreeChangeEventImpl(treeAspect, changedFile);
                event.registerChangeSet((PomModelAspect)treeAspect, (PomChangeSet)destinationTreeChange);
                action.makeChange(destinationTreeChange);
                TreeUtil.clearCaches(changedElement);
                if (changedElement instanceof CompositeElement) {
                    ((CompositeElement)changedElement).subtreeChanged();
                }
                return event;
            }
        });
    }

    public static interface ChangeAction {
        public void makeChange(TreeChangeEvent var1);
    }
}

