/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PathListReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = this.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    protected boolean disableNonSlashedPaths() {
        return true;
    }

    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        Object[] refs;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider", "getReferencesByElement"));
        }
        Object[] result = PsiReference.EMPTY_ARRAY;
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        TextRange range = manipulator.getRangeInElement(element);
        String s = range.substring(element.getText());
        int offset = range.getStartOffset();
        if (this.disableNonSlashedPaths() && !s.trim().startsWith("/")) {
            return result;
        }
        int pos = -1;
        char separator = this.getSeparator();
        while (true) {
            int nextPos;
            if ((nextPos = s.indexOf(separator, pos + 1)) == -1) break;
            refs = this.createReferences(element, s.substring(pos + 1, nextPos), pos + offset + 1, false);
            result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])refs);
            pos = nextPos;
        }
        refs = this.createReferences(element, s.substring(pos + 1), pos + offset + 1, false);
        result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])refs);
        return result;
    }

    protected char getSeparator() {
        return ',';
    }

    protected PsiReference[] createReferences(@NotNull PsiElement element, String s, int offset, final boolean soft) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider", "createReferences"));
        }
        int contentOffset = StringUtil.findFirst((CharSequence)s, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        if (contentOffset >= 0) {
            offset += contentOffset;
        }
        return new FileReferenceSet(s.trim(), element, offset, this, true){

            @Override
            protected boolean isSoft() {
                return soft;
            }
        }.getAllReferences();
    }
}

