/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.annotations.NotNull;

public class FormatCommentsProcessor
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor", "process"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor", "process"));
        }
        PsiElement e = SourceTreeToPsiMap.treeElementToPsi(element);
        assert (e != null);
        Project project2 = e.getProject();
        if (!CodeStyleSettingsManager.getSettings((Project)project2).ENABLE_JAVADOC_FORMATTING || element.getPsi().getContainingFile().getLanguage() != JavaLanguage.INSTANCE || InjectedLanguageManager.getInstance((Project)project2).isInjectedFragment(element.getPsi().getContainingFile())) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor", "process"));
            }
            return textRange;
        }
        TextRange textRange = FormatCommentsProcessor.formatCommentsInner(project2, element, range);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor", "process"));
        }
        return textRange;
    }

    @NotNull
    private static TextRange formatCommentsInner(@NotNull Project project2, @NotNull ASTNode element, @NotNull TextRange markedRange) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor", "formatCommentsInner"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor", "formatCommentsInner"));
        }
        if (markedRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markedRange", "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor", "formatCommentsInner"));
        }
        TextRange resultTextRange = markedRange;
        PsiElement elementPsi = element.getPsi();
        boolean shouldFormat = markedRange.contains(element.getTextRange());
        if (shouldFormat) {
            ASTNode rangeAnchor = elementPsi instanceof PsiDocComment ? element.getTreeParent() : element;
            TextRange before = rangeAnchor.getTextRange();
            new CommentFormatter(project2).processComment(element);
            int deltaRange = rangeAnchor.getTextRange().getLength() - before.getLength();
            resultTextRange = new TextRange(markedRange.getStartOffset(), markedRange.getEndOffset() + deltaRange);
        }
        if (shouldFormat && (elementPsi instanceof PsiMethod || elementPsi instanceof PsiField || elementPsi instanceof PsiDocComment) || markedRange.getEndOffset() < element.getStartOffset()) {
            TextRange textRange = resultTextRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor", "formatCommentsInner"));
            }
            return textRange;
        }
        for (ASTNode current = element.getFirstChildNode(); current != null; current = current.getTreeNext()) {
            if (shouldFormat && current.getPsi() instanceof PsiDocComment && elementPsi instanceof PsiClass) continue;
            resultTextRange = FormatCommentsProcessor.formatCommentsInner(project2, current, resultTextRange);
        }
        TextRange textRange = resultTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor", "formatCommentsInner"));
        }
        return textRange;
    }
}

