/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.TIntProcedure;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LowLevelSearchUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.LowLevelSearchUtil");

    private static Boolean processInjectedFile(PsiElement element, TextOccurenceProcessor processor2, StringSearcher searcher, ProgressIndicator progress, InjectedLanguageManager injectedLanguageManager) {
        if (!(element instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        if (injectedLanguageManager == null) {
            return null;
        }
        List list = injectedLanguageManager.getInjectedPsiFiles(element);
        if (list == null) {
            return null;
        }
        for (Pair pair : list) {
            PsiElement injected = (PsiElement)pair.getFirst();
            if (LowLevelSearchUtil.processElementsContainingWordInElement(processor2, injected, searcher, false, progress)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static TreeElement processTreeUp(@NotNull Project project2, @NotNull TextOccurenceProcessor processor2, @NotNull PsiElement scope, @NotNull StringSearcher searcher, int offset, boolean processInjectedPsi, ProgressIndicator progress, TreeElement lastElement) {
        int start;
        boolean useTree;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        int scopeStartOffset = scope.getTextRange().getStartOffset();
        int patternLength = searcher.getPatternLength();
        ASTNode scopeNode = scope.getNode();
        boolean bl = useTree = scopeNode != null;
        assert (scope.isValid());
        TreeElement leafNode = null;
        PsiElement leafElement = null;
        if (useTree) {
            leafNode = LowLevelSearchUtil.findNextLeafElementAt(scopeNode, lastElement, offset);
            if (leafNode == null) {
                return lastElement;
            }
            start = offset - leafNode.getStartOffset() + scopeStartOffset;
        } else {
            leafElement = scope instanceof PsiFile ? ((PsiFile)scope).getViewProvider().findElementAt(offset, scope.getLanguage()) : scope.findElementAt(offset);
            if (leafElement == null) {
                return lastElement;
            }
            assert (leafElement.isValid());
            start = offset - leafElement.getTextRange().getStartOffset() + scopeStartOffset;
        }
        if (start < 0) {
            throw new AssertionError((Object)("offset=" + offset + " scopeStartOffset=" + scopeStartOffset + " leafElement=" + leafElement + "  scope=" + scope));
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project2);
        lastElement = leafNode;
        boolean contains = false;
        PsiElement prev = null;
        TreeElement prevNode = null;
        PsiElement run = null;
        while (run != scope) {
            if (progress != null) {
                progress.checkCanceled();
            }
            if (useTree) {
                start += prevNode == null ? 0 : prevNode.getStartOffsetInParent();
                prevNode = leafNode;
                run = leafNode.getPsi();
            } else {
                start += prev == null ? 0 : prev.getStartOffsetInParent();
                prev = run;
                run = leafElement;
            }
            if (!contains) {
                boolean bl2 = contains = run.getTextLength() - start >= patternLength;
            }
            if (contains) {
                Boolean result;
                if (processInjectedPsi && (result = LowLevelSearchUtil.processInjectedFile(run, processor2, searcher, progress, injectedLanguageManager)) != null) {
                    return result != false ? lastElement : null;
                }
                if (!processor2.execute(run, start)) {
                    return null;
                }
            }
            if (!(useTree ? (leafNode = leafNode.getTreeParent()) == null : (leafElement = leafElement.getParent()) == null)) continue;
        }
        assert (run == scope) : "Malbuilt PSI: scopeNode=" + scope + "; leafNode=" + run + "; isAncestor=" + PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)run, (boolean)false);
        return lastElement;
    }

    private static TreeElement findNextLeafElementAt(ASTNode scopeNode, TreeElement last, int offset) {
        int offsetR = offset;
        if (last != null) {
            offsetR -= last.getStartOffset() - scopeNode.getStartOffset() + last.getTextLength();
            while (offsetR >= 0) {
                TreeElement next = last.getTreeNext();
                if (next == null) {
                    last = last.getTreeParent();
                    continue;
                }
                int length = next.getTextLength();
                offsetR -= length;
                last = next;
            }
            scopeNode = last;
            offsetR += scopeNode.getTextLength();
        }
        return (LeafElement)scopeNode.findLeafElementAt(offsetR);
    }

    public static boolean processElementsContainingWordInElement(final @NotNull TextOccurenceProcessor processor2, final @NotNull PsiElement scope, final @NotNull StringSearcher searcher, final boolean processInjectedPsi, final ProgressIndicator progress) {
        int scopeStart;
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsContainingWordInElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsContainingWordInElement"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsContainingWordInElement"));
        }
        if (progress != null) {
            progress.checkCanceled();
        }
        PsiFile file2 = scope.getContainingFile();
        FileViewProvider viewProvider = file2.getViewProvider();
        CharSequence buffer = viewProvider.getContents();
        TextRange range = scope.getTextRange();
        if (range == null) {
            LOG.error("Element " + scope + " of class " + scope.getClass() + " has null range");
            return true;
        }
        int startOffset = scopeStart = range.getStartOffset();
        int endOffset = range.getEndOffset();
        if (endOffset > buffer.length()) {
            LowLevelSearchUtil.diagnoseInvalidRange(scope, file2, viewProvider, buffer, range);
            return true;
        }
        final Project project2 = file2.getProject();
        final TreeElement[] lastElement = new TreeElement[]{null};
        return LowLevelSearchUtil.processTextOccurrences(buffer, startOffset, endOffset, searcher, progress, new TIntProcedure(){

            public boolean execute(int offset) {
                if (progress != null) {
                    progress.checkCanceled();
                }
                lastElement[0] = LowLevelSearchUtil.processTreeUp(project2, processor2, scope, searcher, offset - scopeStart, processInjectedPsi, progress, lastElement[0]);
                return lastElement[0] != null;
            }
        });
    }

    private static void diagnoseInvalidRange(@NotNull PsiElement scope, PsiFile file2, FileViewProvider viewProvider, CharSequence buffer, TextRange range) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/LowLevelSearchUtil", "diagnoseInvalidRange"));
        }
        String msg = "Range for element: '" + scope + "' = " + range + " is out of file '" + file2 + "' range: " + file2.getTextRange();
        msg = msg + "; file contents length: " + buffer.length();
        msg = msg + "\n file provider: " + viewProvider;
        Document document = viewProvider.getDocument();
        if (document != null) {
            msg = msg + "\n committed=" + PsiDocumentManager.getInstance((Project)file2.getProject()).isCommitted(document);
        }
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            msg = msg + "\n root " + language + " length=" + root.getTextLength() + (root instanceof PsiFileImpl ? "; contentsLoaded=" + ((PsiFileImpl)root).isContentsLoaded() : "");
        }
        LOG.error(msg);
    }

    public static boolean processTextOccurrences(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, @Nullable ProgressIndicator progress, @NotNull TIntProcedure processor2) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTextOccurrences"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTextOccurrences"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTextOccurrences"));
        }
        if (endOffset > text.length()) {
            throw new AssertionError((Object)"end>length");
        }
        for (int index = startOffset; index < endOffset; ++index) {
            if (progress != null) {
                progress.checkCanceled();
            }
            if ((index = searcher.scan(text, index, endOffset)) < 0) break;
            if (!LowLevelSearchUtil.checkJavaIdentifier(text, startOffset, endOffset, searcher, index) || processor2.execute(index)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkJavaIdentifier(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, int index) {
        char c;
        char c2;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/LowLevelSearchUtil", "checkJavaIdentifier"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "checkJavaIdentifier"));
        }
        if (!searcher.isJavaIdentifier()) {
            return true;
        }
        if (index > startOffset && (Character.isJavaIdentifierPart(c2 = text.charAt(index - 1)) && c2 != '$' ? !searcher.isHandleEscapeSequences() || index < 2 || LowLevelSearchUtil.isEscapedBackslash(text, startOffset, index - 2) : index > 0 && searcher.isHandleEscapeSequences() && !LowLevelSearchUtil.isEscapedBackslash(text, startOffset, index - 1))) {
            return false;
        }
        int patternLength = searcher.getPattern().length();
        return index + patternLength >= endOffset || !Character.isJavaIdentifierPart(c = text.charAt(index + patternLength)) || c == '$';
    }

    private static boolean isEscapedBackslash(CharSequence text, int startOffset, int index) {
        return StringUtil.isEscapedBackslash((CharSequence)text, (int)startOffset, (int)index);
    }
}

